/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.ops;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityQuery;
import com.espertech.esper.common.internal.epl.expression.ops.ExprRelationalOpAllAnyNodeForge;
import com.espertech.esper.common.internal.type.RelationalOpEnum;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;

public class ExprRelationalOpAllAnyNodeForgeEval
implements ExprEvaluator {
    private final ExprRelationalOpAllAnyNodeForge forge;
    private final ExprEvaluator[] evaluators;

    public ExprRelationalOpAllAnyNodeForgeEval(ExprRelationalOpAllAnyNodeForge forge, ExprEvaluator[] evaluators) {
        this.forge = forge;
        this.evaluators = evaluators;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Boolean result = this.evaluateInternal(eventsPerStream, isNewData, exprEvaluatorContext);
        return result;
    }

    private Boolean evaluateInternal(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        if (this.evaluators.length == 1) {
            return false;
        }
        boolean isAll = this.forge.getForgeRenderable().isAll();
        RelationalOpEnum.Computer computer = this.forge.getComputer();
        Object valueLeft = this.evaluators[0].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        int len = this.evaluators.length - 1;
        if (this.forge.isHasCollectionOrArray()) {
            boolean hasNonNullRow = false;
            boolean hasRows = false;
            for (int i = 1; i <= len; ++i) {
                Object valueRight = this.evaluators[i].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
                if (valueRight == null) continue;
                if (valueRight instanceof Collection) {
                    Collection coll = (Collection)valueRight;
                    hasRows = true;
                    for (Object item : coll) {
                        if (!(item instanceof Number)) {
                            if (!isAll || item != null) continue;
                            return null;
                        }
                        hasNonNullRow = true;
                        if (valueLeft == null) continue;
                        if (isAll) {
                            if (computer.compare(valueLeft, item)) continue;
                            return false;
                        }
                        if (!computer.compare(valueLeft, item)) continue;
                        return true;
                    }
                    continue;
                }
                if (valueRight instanceof Map) {
                    Map coll = (Map)valueRight;
                    hasRows = true;
                    for (Object item : coll.keySet()) {
                        if (!(item instanceof Number)) {
                            if (!isAll || item != null) continue;
                            return null;
                        }
                        hasNonNullRow = true;
                        if (valueLeft == null) continue;
                        if (isAll) {
                            if (computer.compare(valueLeft, item)) continue;
                            return false;
                        }
                        if (!computer.compare(valueLeft, item)) continue;
                        return true;
                    }
                    continue;
                }
                if (valueRight.getClass().isArray()) {
                    hasRows = true;
                    int arrayLength = Array.getLength(valueRight);
                    for (int index = 0; index < arrayLength; ++index) {
                        Object item;
                        item = Array.get(valueRight, index);
                        if (item == null) {
                            if (!isAll) continue;
                            return null;
                        }
                        hasNonNullRow = true;
                        if (valueLeft == null) continue;
                        if (isAll) {
                            if (computer.compare(valueLeft, item)) continue;
                            return false;
                        }
                        if (!computer.compare(valueLeft, item)) continue;
                        return true;
                    }
                    continue;
                }
                if (!(valueRight instanceof Number)) {
                    if (!isAll) continue;
                    return null;
                }
                hasNonNullRow = true;
                if (isAll) {
                    if (computer.compare(valueLeft, valueRight)) continue;
                    return false;
                }
                if (!computer.compare(valueLeft, valueRight)) continue;
                return true;
            }
            if (isAll) {
                if (!hasRows) {
                    return true;
                }
                if (!hasNonNullRow || valueLeft == null) {
                    return null;
                }
                return true;
            }
            if (!hasRows) {
                return false;
            }
            if (!hasNonNullRow || valueLeft == null) {
                return null;
            }
            return false;
        }
        boolean hasNonNullRow = false;
        boolean hasRows = false;
        for (int i = 1; i <= len; ++i) {
            Object valueRight = this.evaluators[i].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            hasRows = true;
            if (valueRight != null) {
                hasNonNullRow = true;
            } else if (isAll) {
                return null;
            }
            if (valueRight == null || valueLeft == null) continue;
            if (isAll) {
                if (computer.compare(valueLeft, valueRight)) continue;
                return false;
            }
            if (!computer.compare(valueLeft, valueRight)) continue;
            return true;
        }
        if (isAll) {
            if (!hasRows) {
                return true;
            }
            if (!hasNonNullRow || valueLeft == null) {
                return null;
            }
            return true;
        }
        if (!hasRows) {
            return false;
        }
        if (!hasNonNullRow || valueLeft == null) {
            return null;
        }
        return false;
    }

    public static CodegenExpression codegen(ExprRelationalOpAllAnyNodeForge forge, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        ExprForge[] forges = ExprNodeUtilityQuery.getForges(forge.getForgeRenderable().getChildNodes());
        Class valueLeftType = forges[0].getEvaluationType();
        boolean isAll = forge.getForgeRenderable().isAll();
        if (forges.length == 1) {
            return CodegenExpressionBuilder.constant(isAll);
        }
        CodegenMethod methodNode = codegenMethodScope.makeChild(Boolean.class, ExprRelationalOpAllAnyNodeForgeEval.class, (CodegenScope)codegenClassScope);
        CodegenBlock block = methodNode.getBlock().declareVar(Boolean.TYPE, "hasNonNullRow", CodegenExpressionBuilder.constantFalse()).declareVar(valueLeftType, "valueLeft", forges[0].evaluateCodegen(valueLeftType, methodNode, exprSymbol, codegenClassScope));
        for (int i = 1; i < forges.length; ++i) {
            CodegenBlock ifLeftNotNull;
            CodegenBlock ifNotNumberElse;
            CodegenBlock ifNotNumber;
            CodegenBlock forEach;
            CodegenBlock blockIfNotNull;
            ExprForge refforge = forges[i];
            String refname = "r" + i;
            Class reftype = refforge.getEvaluationType();
            block.declareVar(reftype, refname, refforge.evaluateCodegen(reftype, methodNode, exprSymbol, codegenClassScope));
            if (JavaClassHelper.isImplementsInterface(reftype, Collection.class)) {
                blockIfNotNull = block.ifCondition(CodegenExpressionBuilder.notEqualsNull(CodegenExpressionBuilder.ref(refname)));
                forEach = blockIfNotNull.forEach(Object.class, "item", CodegenExpressionBuilder.ref(refname));
                ifNotNumber = forEach.ifCondition(CodegenExpressionBuilder.not(CodegenExpressionBuilder.instanceOf(CodegenExpressionBuilder.ref("item"), Number.class)));
                if (isAll) {
                    ifNotNumber.ifRefNullReturnNull("item");
                }
                ifNotNumberElse = ifNotNumber.ifElse();
                ifNotNumberElse.assignRef("hasNonNullRow", CodegenExpressionBuilder.constantTrue());
                ifLeftNotNull = ifNotNumberElse.ifCondition(CodegenExpressionBuilder.notEqualsNull(CodegenExpressionBuilder.ref("valueLeft")));
                ifLeftNotNull.ifCondition(CodegenExpressionBuilder.notOptional(isAll, forge.getComputer().codegen(CodegenExpressionBuilder.ref("valueLeft"), valueLeftType, CodegenExpressionBuilder.cast(Number.class, (CodegenExpression)CodegenExpressionBuilder.ref("item")), Number.class))).blockReturn(isAll ? CodegenExpressionBuilder.constantFalse() : CodegenExpressionBuilder.constantTrue());
                continue;
            }
            if (JavaClassHelper.isImplementsInterface(reftype, Map.class)) {
                blockIfNotNull = block.ifCondition(CodegenExpressionBuilder.notEqualsNull(CodegenExpressionBuilder.ref(refname)));
                forEach = blockIfNotNull.forEach(Object.class, "item", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref(refname), "keySet", new CodegenExpression[0]));
                ifNotNumber = forEach.ifCondition(CodegenExpressionBuilder.not(CodegenExpressionBuilder.instanceOf(CodegenExpressionBuilder.ref("item"), Number.class)));
                if (isAll) {
                    ifNotNumber.ifRefNullReturnNull("item");
                }
                ifNotNumberElse = ifNotNumber.ifElse();
                ifNotNumberElse.assignRef("hasNonNullRow", CodegenExpressionBuilder.constantTrue());
                ifLeftNotNull = ifNotNumberElse.ifCondition(CodegenExpressionBuilder.notEqualsNull(CodegenExpressionBuilder.ref("valueLeft")));
                ifLeftNotNull.ifCondition(CodegenExpressionBuilder.notOptional(isAll, forge.getComputer().codegen(CodegenExpressionBuilder.ref("valueLeft"), valueLeftType, CodegenExpressionBuilder.cast(Number.class, (CodegenExpression)CodegenExpressionBuilder.ref("item")), Number.class))).blockReturn(isAll ? CodegenExpressionBuilder.constantFalse() : CodegenExpressionBuilder.constantTrue());
                continue;
            }
            if (reftype.isArray()) {
                blockIfNotNull = block.ifCondition(CodegenExpressionBuilder.notEqualsNull(CodegenExpressionBuilder.ref(refname)));
                CodegenBlock forLoopArray = blockIfNotNull.forLoopIntSimple("index", CodegenExpressionBuilder.arrayLength(CodegenExpressionBuilder.ref(refname)));
                forLoopArray.declareVar(JavaClassHelper.getBoxedType(reftype.getComponentType()), "item", CodegenExpressionBuilder.arrayAtIndex(CodegenExpressionBuilder.ref(refname), CodegenExpressionBuilder.ref("index")));
                CodegenBlock ifItemNull = forLoopArray.ifCondition(CodegenExpressionBuilder.equalsNull(CodegenExpressionBuilder.ref("item")));
                if (isAll) {
                    ifItemNull.ifReturn(CodegenExpressionBuilder.constantNull());
                }
                CodegenBlock ifItemNotNull = ifItemNull.ifElse();
                ifItemNotNull.assignRef("hasNonNullRow", CodegenExpressionBuilder.constantTrue());
                ifLeftNotNull = ifItemNotNull.ifCondition(CodegenExpressionBuilder.notEqualsNull(CodegenExpressionBuilder.ref("valueLeft")));
                ifLeftNotNull.ifCondition(CodegenExpressionBuilder.notOptional(isAll, forge.getComputer().codegen(CodegenExpressionBuilder.ref("valueLeft"), valueLeftType, CodegenExpressionBuilder.ref("item"), Number.class))).blockReturn(isAll ? CodegenExpressionBuilder.constantFalse() : CodegenExpressionBuilder.constantTrue());
                continue;
            }
            if (!JavaClassHelper.isSubclassOrImplementsInterface(JavaClassHelper.getBoxedType(reftype), Number.class)) {
                if (!reftype.isPrimitive()) {
                    block.ifRefNullReturnNull(refname);
                }
                block.assignRef("hasNonNullRow", CodegenExpressionBuilder.constantTrue());
                if (!isAll) continue;
                block.blockReturn(CodegenExpressionBuilder.constantNull());
                continue;
            }
            if (reftype.isPrimitive()) {
                block.assignRef("hasNonNullRow", CodegenExpressionBuilder.constantTrue());
                block.ifCondition(CodegenExpressionBuilder.notOptional(isAll, forge.getComputer().codegen(CodegenExpressionBuilder.ref("valueLeft"), valueLeftType, CodegenExpressionBuilder.ref(refname), reftype))).blockReturn(isAll ? CodegenExpressionBuilder.constantFalse() : CodegenExpressionBuilder.constantTrue());
                continue;
            }
            if (isAll) {
                block.ifRefNullReturnNull(refname);
            }
            CodegenBlock ifRefNotNull = block.ifRefNotNull(refname);
            ifRefNotNull.assignRef("hasNonNullRow", CodegenExpressionBuilder.constantTrue());
            CodegenBlock ifLeftNotNull2 = ifRefNotNull.ifCondition(CodegenExpressionBuilder.notEqualsNull(CodegenExpressionBuilder.ref("valueLeft")));
            ifLeftNotNull2.ifCondition(CodegenExpressionBuilder.notOptional(isAll, forge.getComputer().codegen(CodegenExpressionBuilder.ref("valueLeft"), valueLeftType, CodegenExpressionBuilder.ref(refname), Number.class))).blockReturn(isAll ? CodegenExpressionBuilder.constantFalse() : CodegenExpressionBuilder.constantTrue());
        }
        block.ifCondition(CodegenExpressionBuilder.not(CodegenExpressionBuilder.ref("hasNonNullRow"))).blockReturn(CodegenExpressionBuilder.constantNull());
        if (!valueLeftType.isPrimitive()) {
            block.ifRefNullReturnNull("valueLeft");
        }
        block.methodReturn(CodegenExpressionBuilder.constant(isAll));
        return CodegenExpressionBuilder.localMethod(methodNode, new CodegenExpression[0]);
    }
}

