/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.prev;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.prev.ExprPreviousEvalStrategy;
import com.espertech.esper.common.internal.view.access.RandomAccessByIndex;
import com.espertech.esper.common.internal.view.access.RandomAccessByIndexGetter;
import com.espertech.esper.common.internal.view.access.RelativeAccessByEventNIndex;
import com.espertech.esper.common.internal.view.access.RelativeAccessByEventNIndexGetter;
import java.lang.reflect.Array;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public class ExprPreviousEvalStrategyWindow
implements ExprPreviousEvalStrategy {
    private final int streamNumber;
    private final ExprEvaluator evalNode;
    private final Class componentType;
    private final RandomAccessByIndexGetter randomAccessGetter;
    private final RelativeAccessByEventNIndexGetter relativeAccessGetter;

    public ExprPreviousEvalStrategyWindow(int streamNumber, ExprEvaluator evalNode, Class componentType, RandomAccessByIndexGetter randomAccessGetter, RelativeAccessByEventNIndexGetter relativeAccessGetter) {
        this.streamNumber = streamNumber;
        this.evalNode = evalNode;
        this.componentType = componentType;
        this.randomAccessGetter = randomAccessGetter;
        this.relativeAccessGetter = relativeAccessGetter;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, ExprEvaluatorContext exprEvaluatorContext) {
        int size;
        Iterator<EventBean> events;
        if (this.randomAccessGetter != null) {
            RandomAccessByIndex randomAccess = this.randomAccessGetter.getAccessor();
            events = randomAccess.getWindowIterator();
            size = randomAccess.getWindowCount();
        } else {
            EventBean evalEvent = eventsPerStream[this.streamNumber];
            RelativeAccessByEventNIndex relativeAccess = this.relativeAccessGetter.getAccessor(evalEvent);
            if (relativeAccess == null) {
                return null;
            }
            size = relativeAccess.getWindowToEventCount();
            events = relativeAccess.getWindowToEvent();
        }
        if (size <= 0) {
            return null;
        }
        EventBean originalEvent = eventsPerStream[this.streamNumber];
        Object[] result = (Object[])Array.newInstance(this.componentType, size);
        for (int i = 0; i < size; ++i) {
            Object evalResult;
            eventsPerStream[this.streamNumber] = events.next();
            result[i] = evalResult = this.evalNode.evaluate(eventsPerStream, true, exprEvaluatorContext);
        }
        eventsPerStream[this.streamNumber] = originalEvent;
        return result;
    }

    @Override
    public Collection<EventBean> evaluateGetCollEvents(EventBean[] eventsPerStream, ExprEvaluatorContext context) {
        Collection<EventBean> events;
        if (this.randomAccessGetter != null) {
            RandomAccessByIndex randomAccess = this.randomAccessGetter.getAccessor();
            events = randomAccess.getWindowCollectionReadOnly();
        } else {
            EventBean evalEvent = eventsPerStream[this.streamNumber];
            RelativeAccessByEventNIndex relativeAccess = this.relativeAccessGetter.getAccessor(evalEvent);
            if (relativeAccess == null) {
                return null;
            }
            events = relativeAccess.getWindowToEventCollReadOnly();
        }
        return events;
    }

    @Override
    public Collection evaluateGetCollScalar(EventBean[] eventsPerStream, ExprEvaluatorContext context) {
        int size;
        Iterator<EventBean> events;
        if (this.randomAccessGetter != null) {
            RandomAccessByIndex randomAccess = this.randomAccessGetter.getAccessor();
            events = randomAccess.getWindowIterator();
            size = randomAccess.getWindowCount();
        } else {
            EventBean evalEvent = eventsPerStream[this.streamNumber];
            RelativeAccessByEventNIndex relativeAccess = this.relativeAccessGetter.getAccessor(evalEvent);
            if (relativeAccess == null) {
                return null;
            }
            size = relativeAccess.getWindowToEventCount();
            events = relativeAccess.getWindowToEvent();
        }
        if (size <= 0) {
            return Collections.emptyList();
        }
        EventBean originalEvent = eventsPerStream[this.streamNumber];
        ArrayDeque<Object> deque = new ArrayDeque<Object>(size);
        for (int i = 0; i < size; ++i) {
            eventsPerStream[this.streamNumber] = events.next();
            Object evalResult = this.evalNode.evaluate(eventsPerStream, true, context);
            deque.add(evalResult);
        }
        eventsPerStream[this.streamNumber] = originalEvent;
        return deque;
    }

    @Override
    public EventBean evaluateGetEventBean(EventBean[] eventsPerStream, ExprEvaluatorContext context) {
        return null;
    }
}

