/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.subquery;

import com.espertech.esper.common.internal.compile.stage1.spec.GroupByClauseElement;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.subquery.ExprSubselectExistsNode;
import com.espertech.esper.common.internal.epl.expression.subquery.ExprSubselectNode;
import com.espertech.esper.common.internal.epl.expression.subquery.SubselectForgeNR;
import com.espertech.esper.common.internal.epl.expression.subquery.SubselectForgeNREqualsAllAnyAggregated;
import com.espertech.esper.common.internal.epl.expression.subquery.SubselectForgeNREqualsAllAnyWGroupBy;
import com.espertech.esper.common.internal.epl.expression.subquery.SubselectForgeNREqualsDefault;
import com.espertech.esper.common.internal.epl.expression.subquery.SubselectForgeNREqualsIn;
import com.espertech.esper.common.internal.epl.expression.subquery.SubselectForgeNREqualsInAggregated;
import com.espertech.esper.common.internal.epl.expression.subquery.SubselectForgeNREqualsInWGroupBy;
import com.espertech.esper.common.internal.epl.expression.subquery.SubselectForgeNRExistsAggregated;
import com.espertech.esper.common.internal.epl.expression.subquery.SubselectForgeNRExistsAlwaysTrue;
import com.espertech.esper.common.internal.epl.expression.subquery.SubselectForgeNRExistsDefault;
import com.espertech.esper.common.internal.epl.expression.subquery.SubselectForgeNRExistsWGroupBy;
import com.espertech.esper.common.internal.epl.expression.subquery.SubselectForgeNRExistsWGroupByWHaving;
import com.espertech.esper.common.internal.epl.expression.subquery.SubselectForgeNRRelOpAllAnyAggregated;
import com.espertech.esper.common.internal.epl.expression.subquery.SubselectForgeNRRelOpAllDefault;
import com.espertech.esper.common.internal.epl.expression.subquery.SubselectForgeNRRelOpAllWGroupBy;
import com.espertech.esper.common.internal.epl.expression.subquery.SubselectForgeNRRelOpAnyWGroupBy;
import com.espertech.esper.common.internal.epl.expression.subquery.SubselectForgeStrategyNRRelOpAnyDefault;
import com.espertech.esper.common.internal.settings.ClasspathImportServiceCompileTime;
import com.espertech.esper.common.internal.type.RelationalOpEnum;
import com.espertech.esper.common.internal.util.CoercionException;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import com.espertech.esper.common.internal.util.SimpleNumberCoercer;
import com.espertech.esper.common.internal.util.SimpleNumberCoercerFactory;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class SubselectNRForgeFactory {
    public static SubselectForgeNR createStrategyExists(ExprSubselectExistsNode subselectExpression) {
        boolean aggregated = SubselectNRForgeFactory.aggregated(subselectExpression.getSubselectAggregationType());
        boolean grouped = SubselectNRForgeFactory.grouped(subselectExpression.getStatementSpecCompiled().getRaw().getGroupByExpressions());
        if (grouped) {
            if (subselectExpression.havingExpr != null) {
                return new SubselectForgeNRExistsWGroupByWHaving(subselectExpression, subselectExpression.havingExpr);
            }
            return new SubselectForgeNRExistsWGroupBy(subselectExpression);
        }
        if (aggregated) {
            if (subselectExpression.havingExpr != null) {
                return new SubselectForgeNRExistsAggregated(subselectExpression.havingExpr);
            }
            return SubselectForgeNRExistsAlwaysTrue.INSTANCE;
        }
        return new SubselectForgeNRExistsDefault(subselectExpression.filterExpr, subselectExpression.havingExpr);
    }

    public static SubselectForgeNR createStrategyAnyAllIn(ExprSubselectNode subselectExpression, boolean isNot, boolean isAll, boolean isAny, RelationalOpEnum relationalOp, ClasspathImportServiceCompileTime classpathImportService) throws ExprValidationException {
        if (subselectExpression.getChildNodes().length != 1) {
            throw new ExprValidationException("The Subselect-IN requires 1 child expression");
        }
        ExprNode valueExpr = subselectExpression.getChildNodes()[0];
        Class typeOne = JavaClassHelper.getBoxedType(subselectExpression.getChildNodes()[0].getForge().getEvaluationType());
        if (typeOne.isArray() || JavaClassHelper.isImplementsInterface(typeOne, Collection.class) || JavaClassHelper.isImplementsInterface(typeOne, Map.class)) {
            throw new ExprValidationException("Collection or array comparison is not allowed for the IN, ANY, SOME or ALL keywords");
        }
        Class typeTwo = subselectExpression.getSelectClause() != null ? subselectExpression.getSelectClause()[0].getForge().getEvaluationType() : subselectExpression.getRawEventType().getUnderlyingType();
        boolean aggregated = SubselectNRForgeFactory.aggregated(subselectExpression.getSubselectAggregationType());
        boolean grouped = SubselectNRForgeFactory.grouped(subselectExpression.getStatementSpecCompiled().getRaw().getGroupByExpressions());
        ExprForge selectEval = subselectExpression.getSelectClause() == null ? null : subselectExpression.getSelectClause()[0].getForge();
        ExprForge valueEval = valueExpr.getForge();
        ExprForge filterEval = subselectExpression.filterExpr;
        ExprForge havingEval = subselectExpression.havingExpr;
        if (relationalOp != null) {
            if (typeOne != String.class || typeTwo != String.class) {
                if (!JavaClassHelper.isNumeric(typeOne)) {
                    throw new ExprValidationException("Implicit conversion from datatype '" + typeOne.getSimpleName() + "' to numeric is not allowed");
                }
                if (!JavaClassHelper.isNumeric(typeTwo)) {
                    throw new ExprValidationException("Implicit conversion from datatype '" + typeTwo.getSimpleName() + "' to numeric is not allowed");
                }
            }
            Class compareType = JavaClassHelper.getCompareToCoercionType(typeOne, typeTwo);
            RelationalOpEnum.Computer computer = relationalOp.getComputer(compareType, typeOne, typeTwo);
            if (isAny) {
                if (grouped) {
                    return new SubselectForgeNRRelOpAnyWGroupBy(subselectExpression, valueEval, selectEval, false, computer, havingEval);
                }
                if (aggregated) {
                    return new SubselectForgeNRRelOpAllAnyAggregated(subselectExpression, valueEval, selectEval, false, computer, havingEval);
                }
                return new SubselectForgeStrategyNRRelOpAnyDefault(subselectExpression, valueEval, selectEval, false, computer, filterEval);
            }
            if (grouped) {
                return new SubselectForgeNRRelOpAllWGroupBy(subselectExpression, valueEval, selectEval, true, computer, havingEval);
            }
            if (aggregated) {
                return new SubselectForgeNRRelOpAllAnyAggregated(subselectExpression, valueEval, selectEval, true, computer, havingEval);
            }
            return new SubselectForgeNRRelOpAllDefault(subselectExpression, valueEval, selectEval, true, computer, filterEval);
        }
        SimpleNumberCoercer coercer = SubselectNRForgeFactory.getCoercer(typeOne, typeTwo);
        if (isAll) {
            if (grouped) {
                return new SubselectForgeNREqualsAllAnyWGroupBy(subselectExpression, valueEval, selectEval, true, isNot, coercer, havingEval, true);
            }
            if (aggregated) {
                return new SubselectForgeNREqualsAllAnyAggregated(subselectExpression, valueEval, selectEval, true, isNot, coercer, havingEval);
            }
            return new SubselectForgeNREqualsDefault(subselectExpression, valueEval, selectEval, true, isNot, coercer, filterEval, true);
        }
        if (isAny) {
            if (grouped) {
                return new SubselectForgeNREqualsAllAnyWGroupBy(subselectExpression, valueEval, selectEval, false, isNot, coercer, havingEval, false);
            }
            if (aggregated) {
                return new SubselectForgeNREqualsAllAnyAggregated(subselectExpression, valueEval, selectEval, true, isNot, coercer, havingEval);
            }
            return new SubselectForgeNREqualsDefault(subselectExpression, valueEval, selectEval, false, isNot, coercer, filterEval, false);
        }
        if (grouped) {
            return new SubselectForgeNREqualsInWGroupBy(subselectExpression, valueEval, selectEval, isNot, isNot, coercer, havingEval);
        }
        if (aggregated) {
            return new SubselectForgeNREqualsInAggregated(subselectExpression, valueEval, selectEval, isNot, isNot, coercer, havingEval);
        }
        return new SubselectForgeNREqualsIn(subselectExpression, valueEval, selectEval, isNot, isNot, coercer, filterEval);
    }

    private static SimpleNumberCoercer getCoercer(Class typeOne, Class typeTwo) throws ExprValidationException {
        Class coercionType;
        try {
            coercionType = JavaClassHelper.getCompareToCoercionType(typeOne, typeTwo);
        }
        catch (CoercionException ex) {
            throw new ExprValidationException("Implicit conversion from datatype '" + typeTwo.getSimpleName() + "' to '" + typeOne.getSimpleName() + "' is not allowed");
        }
        boolean mustCoerce = false;
        if ((coercionType != JavaClassHelper.getBoxedType(typeOne) || coercionType != JavaClassHelper.getBoxedType(typeTwo)) && JavaClassHelper.isNumeric(coercionType)) {
            mustCoerce = true;
        }
        return !mustCoerce ? null : SimpleNumberCoercerFactory.getCoercer(null, coercionType);
    }

    private static boolean grouped(List<GroupByClauseElement> groupByExpressions) {
        return groupByExpressions != null && !groupByExpressions.isEmpty();
    }

    private static boolean aggregated(ExprSubselectNode.SubqueryAggregationType subqueryAggregationType) {
        return subqueryAggregationType != null && subqueryAggregationType != ExprSubselectNode.SubqueryAggregationType.NONE;
    }
}

