/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.variable;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.util.NameAccessModifier;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionField;
import com.espertech.esper.common.internal.epl.expression.codegen.CodegenLegoCast;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprForgeConstantType;
import com.espertech.esper.common.internal.epl.expression.core.ExprForgeInstrumentable;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeBase;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeRenderable;
import com.espertech.esper.common.internal.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.variable.ExprVariableNode;
import com.espertech.esper.common.internal.epl.streamtype.DuplicatePropertyException;
import com.espertech.esper.common.internal.epl.streamtype.PropertyNotFoundException;
import com.espertech.esper.common.internal.epl.variable.compiletime.VariableMetaData;
import com.espertech.esper.common.internal.epl.variable.compiletime.VariableReaderCodegenFieldSharable;
import com.espertech.esper.common.internal.epl.variable.compiletime.VariableReaderPerCPCodegenFieldSharable;
import com.espertech.esper.common.internal.epl.variable.core.VariableReader;
import com.espertech.esper.common.internal.event.core.EventPropertyGetterSPI;
import com.espertech.esper.common.internal.event.core.EventTypeSPI;
import com.espertech.esper.common.internal.metrics.instrumentation.InstrumentationBuilderExpr;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.io.StringWriter;

public class ExprVariableNodeImpl
extends ExprNodeBase
implements ExprForgeInstrumentable,
ExprEvaluator,
ExprVariableNode {
    private static final long serialVersionUID = 0L;
    private final VariableMetaData variableMeta;
    private final String optSubPropName;
    private EventPropertyGetterSPI optSubPropGetter;
    private Class variableType;

    public ExprVariableNodeImpl(VariableMetaData variableMeta, String optSubPropName) {
        this.variableMeta = variableMeta;
        this.optSubPropName = optSubPropName;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    @Override
    public VariableMetaData getVariableMetadata() {
        return this.variableMeta;
    }

    @Override
    public Class getEvaluationType() {
        return this.variableType;
    }

    @Override
    public ExprForge getForge() {
        return this;
    }

    @Override
    public ExprNodeRenderable getForgeRenderable() {
        return this;
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        boolean hasPropertyAgnosticType = false;
        EventType[] types = validationContext.getStreamTypeService().getEventTypes();
        for (int i = 0; i < validationContext.getStreamTypeService().getEventTypes().length; ++i) {
            if (!(types[i] instanceof EventTypeSPI)) continue;
            hasPropertyAgnosticType |= ((EventTypeSPI)types[i]).getMetadata().isPropertyAgnostic();
        }
        if (!hasPropertyAgnosticType) {
            String variableName = this.variableMeta.getVariableName();
            try {
                validationContext.getStreamTypeService().resolveByPropertyName(variableName, false);
                throw new ExprValidationException("The variable by name '" + variableName + "' is ambiguous to a property of the same name");
            }
            catch (DuplicatePropertyException e) {
                throw new ExprValidationException("The variable by name '" + variableName + "' is ambiguous to a property of the same name");
            }
            catch (PropertyNotFoundException propertyNotFoundException) {
                // empty catch block
            }
        }
        String variableName = this.variableMeta.getVariableName();
        if (this.optSubPropName != null) {
            if (this.variableMeta.getEventType() == null) {
                throw new ExprValidationException("Property '" + this.optSubPropName + "' is not valid for variable '" + variableName + "'");
            }
            this.optSubPropGetter = ((EventTypeSPI)this.variableMeta.getEventType()).getGetterSPI(this.optSubPropName);
            if (this.optSubPropGetter == null) {
                throw new ExprValidationException("Property '" + this.optSubPropName + "' is not valid for variable '" + variableName + "'");
            }
            this.variableType = this.variableMeta.getEventType().getPropertyType(this.optSubPropName);
        } else {
            this.variableType = this.variableMeta.getType();
        }
        this.variableType = JavaClassHelper.getBoxedType(this.variableType);
        return null;
    }

    public String toString() {
        return "variableName=" + this.variableMeta.getVariableName();
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        if (this.variableMeta.isCompileTimeConstant()) {
            return this.variableMeta.getValueWhenAvailable();
        }
        throw new IllegalStateException("Cannot evaluate at compile time");
    }

    @Override
    public CodegenExpression evaluateCodegenUninstrumented(Class requiredType, CodegenMethodScope parent, ExprForgeCodegenSymbol symbols, CodegenClassScope classScope) {
        CodegenExpression readerExpression;
        CodegenMethod methodNode = parent.makeChild(this.variableType, ExprVariableNodeImpl.class, (CodegenScope)classScope);
        if (this.variableMeta.getOptionalContextName() == null) {
            readerExpression = classScope.addOrGetFieldSharable(new VariableReaderCodegenFieldSharable(this.variableMeta));
        } else {
            CodegenExpressionField field = classScope.addOrGetFieldSharable(new VariableReaderPerCPCodegenFieldSharable(this.variableMeta));
            CodegenExpression cpid = CodegenExpressionBuilder.exprDotMethod(symbols.getAddExprEvalCtx(methodNode), "getAgentInstanceId", new CodegenExpression[0]);
            readerExpression = CodegenExpressionBuilder.cast(VariableReader.class, CodegenExpressionBuilder.exprDotMethod(field, "get", cpid));
        }
        CodegenBlock block = methodNode.getBlock().declareVar(VariableReader.class, "reader", readerExpression);
        if (this.variableMeta.getEventType() == null) {
            block.declareVar(this.variableType, "value", CodegenExpressionBuilder.cast(this.variableType, CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("reader"), "getValue", new CodegenExpression[0]))).methodReturn(CodegenExpressionBuilder.ref("value"));
        } else {
            block.declareVar(Object.class, "value", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("reader"), "getValue", new CodegenExpression[0])).ifRefNullReturnNull("value").declareVar(EventBean.class, "theEvent", CodegenExpressionBuilder.cast(EventBean.class, (CodegenExpression)CodegenExpressionBuilder.ref("value")));
            if (this.optSubPropName == null) {
                block.methodReturn(CodegenExpressionBuilder.cast(this.variableType, CodegenExpressionBuilder.exprDotUnderlying(CodegenExpressionBuilder.ref("theEvent"))));
            } else {
                block.methodReturn(CodegenLegoCast.castSafeFromObjectType(this.variableType, this.optSubPropGetter.eventBeanGetCodegen(CodegenExpressionBuilder.ref("theEvent"), methodNode, classScope)));
            }
        }
        return CodegenExpressionBuilder.localMethod(methodNode, new CodegenExpression[0]);
    }

    @Override
    public CodegenExpression codegenGetDeployTimeConstValue(CodegenClassScope classScope) {
        CodegenExpressionField readerExpression = classScope.addOrGetFieldSharable(new VariableReaderCodegenFieldSharable(this.variableMeta));
        if (this.variableMeta.getEventType() == null) {
            return CodegenExpressionBuilder.cast(this.variableType, CodegenExpressionBuilder.exprDotMethod(readerExpression, "getValue", new CodegenExpression[0]));
        }
        CodegenExpression unpack = CodegenExpressionBuilder.exprDotUnderlying(CodegenExpressionBuilder.cast(EventBean.class, CodegenExpressionBuilder.exprDotMethod(readerExpression, "getValue", new CodegenExpression[0])));
        return CodegenExpressionBuilder.cast(this.variableType, unpack);
    }

    @Override
    public CodegenExpression evaluateCodegen(Class requiredType, CodegenMethodScope parent, ExprForgeCodegenSymbol symbols, CodegenClassScope classScope) {
        return new InstrumentationBuilderExpr(this.getClass(), this, "ExprVariable", requiredType, parent, symbols, classScope).build();
    }

    @Override
    public ExprForgeConstantType getForgeConstantType() {
        if (this.variableMeta.getOptionalContextName() != null) {
            return ExprForgeConstantType.NONCONST;
        }
        if (this.variableMeta.isConstant() && this.variableMeta.isCreatedByCurrentModule() && this.variableMeta.getVariableVisibility() != NameAccessModifier.PRECONFIGURED && this.variableMeta.getEventType() == null) {
            return ExprForgeConstantType.COMPILETIMECONST;
        }
        return this.variableMeta.isConstant() ? ExprForgeConstantType.DEPLOYCONST : ExprForgeConstantType.NONCONST;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        writer.append(this.variableMeta.getVariableName());
        if (this.optSubPropName != null) {
            writer.append(".");
            writer.append(this.optSubPropName);
        }
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.UNARY;
    }

    @Override
    public boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        if (!(node instanceof ExprVariableNodeImpl)) {
            return false;
        }
        ExprVariableNodeImpl that = (ExprVariableNodeImpl)node;
        if (this.optSubPropName != null ? !this.optSubPropName.equals(that.optSubPropName) : that.optSubPropName != null) {
            return false;
        }
        return that.variableMeta.getVariableName().equals(this.variableMeta.getVariableName());
    }

    @Override
    public String getVariableNameWithSubProp() {
        if (this.optSubPropName == null) {
            return this.variableMeta.getVariableName();
        }
        return this.variableMeta.getVariableName() + "." + this.optSubPropName;
    }
}

