/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.visitor;

import com.espertech.esper.common.internal.epl.enummethod.dot.ExprLambdaGoesNode;
import com.espertech.esper.common.internal.epl.expression.agg.base.ExprAggregateNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprIdentNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodePropOrStreamDesc;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodePropOrStreamExprDesc;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodePropOrStreamPropDesc;
import com.espertech.esper.common.internal.epl.expression.core.ExprStreamRefNode;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ExprNodeIdentifierAndStreamRefVisitor
implements ExprNodeVisitor {
    private final boolean isVisitAggregateNodes;
    private List<ExprNodePropOrStreamDesc> refs;

    public ExprNodeIdentifierAndStreamRefVisitor(boolean isVisitAggregateNodes) {
        this.isVisitAggregateNodes = isVisitAggregateNodes;
    }

    @Override
    public boolean isVisit(ExprNode exprNode) {
        if (exprNode instanceof ExprLambdaGoesNode) {
            return false;
        }
        if (this.isVisitAggregateNodes) {
            return true;
        }
        return !(exprNode instanceof ExprAggregateNode);
    }

    public List<ExprNodePropOrStreamDesc> getRefs() {
        if (this.refs == null) {
            return Collections.emptyList();
        }
        return this.refs;
    }

    @Override
    public void visit(ExprNode exprNode) {
        if (exprNode instanceof ExprIdentNode) {
            ExprIdentNode identNode = (ExprIdentNode)exprNode;
            int streamId = identNode.getStreamId();
            String propertyName = identNode.getResolvedPropertyName();
            this.checkAllocatedRefs();
            this.refs.add(new ExprNodePropOrStreamPropDesc(streamId, propertyName));
        } else if (exprNode instanceof ExprStreamRefNode) {
            ExprStreamRefNode streamRefNode = (ExprStreamRefNode)exprNode;
            Integer stream = streamRefNode.getStreamReferencedIfAny();
            this.checkAllocatedRefs();
            if (stream != null) {
                this.refs.add(new ExprNodePropOrStreamExprDesc(stream, streamRefNode));
            }
        }
    }

    public void reset() {
        if (this.refs != null) {
            this.refs.clear();
        }
    }

    private void checkAllocatedRefs() {
        if (this.refs == null) {
            this.refs = new ArrayList<ExprNodePropOrStreamDesc>(4);
        }
    }
}

