/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.visitor;

import com.espertech.esper.common.internal.epl.expression.agg.base.ExprAggregateNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprIdentNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprStreamUnderlyingNode;
import com.espertech.esper.common.internal.epl.expression.prev.ExprPreviousNode;
import com.espertech.esper.common.internal.epl.expression.prior.ExprPriorNode;
import com.espertech.esper.common.internal.epl.expression.subquery.ExprSubselectNode;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeVisitor;

public class ExprNodeSummaryVisitor
implements ExprNodeVisitor {
    private boolean hasProperties;
    private boolean hasAggregation;
    private boolean hasSubselect;
    private boolean hasStreamSelect;
    private boolean hasPreviousPrior;

    @Override
    public boolean isVisit(ExprNode exprNode) {
        return true;
    }

    @Override
    public void visit(ExprNode exprNode) {
        if (exprNode instanceof ExprIdentNode) {
            this.hasProperties = true;
        } else if (exprNode instanceof ExprSubselectNode) {
            this.hasSubselect = true;
        } else if (exprNode instanceof ExprAggregateNode) {
            this.hasAggregation = true;
        } else if (exprNode instanceof ExprStreamUnderlyingNode) {
            this.hasStreamSelect = true;
        } else if (exprNode instanceof ExprPriorNode || exprNode instanceof ExprPreviousNode) {
            this.hasPreviousPrior = true;
        }
    }

    public boolean isPlain() {
        return !(this.hasProperties | this.hasAggregation | this.hasSubselect | this.hasStreamSelect | this.hasPreviousPrior);
    }

    public boolean isHasProperties() {
        return this.hasProperties;
    }

    public boolean isHasAggregation() {
        return this.hasAggregation;
    }

    public boolean isHasSubselect() {
        return this.hasSubselect;
    }

    public boolean isHasStreamSelect() {
        return this.hasStreamSelect;
    }

    public boolean isHasPreviousPrior() {
        return this.hasPreviousPrior;
    }

    public String getMessage() {
        if (this.hasProperties) {
            return "event properties";
        }
        if (this.hasAggregation) {
            return "aggregation functions";
        }
        if (this.hasSubselect) {
            return "sub-selects";
        }
        if (this.hasStreamSelect) {
            return "stream selects or event instance methods";
        }
        if (this.hasPreviousPrior) {
            return "previous or prior functions";
        }
        return null;
    }
}

