/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.fafquery.querymethod;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.context.ContextPartitionSelector;
import com.espertech.esper.common.internal.context.mgr.ContextManagementService;
import com.espertech.esper.common.internal.context.module.StatementAIFactoryAssignmentsImpl;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.context.util.InternalEventRouteDest;
import com.espertech.esper.common.internal.epl.fafquery.processor.FireAndForgetInstance;
import com.espertech.esper.common.internal.epl.fafquery.processor.FireAndForgetProcessor;
import com.espertech.esper.common.internal.epl.fafquery.querymethod.EPPreparedQueryResult;
import com.espertech.esper.common.internal.epl.fafquery.querymethod.FAFQueryMethod;
import com.espertech.esper.common.internal.epl.fafquery.querymethod.FAFQueryMethodAssignerSetter;
import com.espertech.esper.common.internal.epl.fafquery.querymethod.FAFQueryMethodUtil;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraph;
import com.espertech.esper.common.internal.epl.table.strategy.ExprTableEvalHelperStart;
import com.espertech.esper.common.internal.epl.table.strategy.ExprTableEvalStrategy;
import com.espertech.esper.common.internal.epl.table.strategy.ExprTableEvalStrategyFactory;
import com.espertech.esper.common.internal.util.CollectionUtil;
import java.lang.annotation.Annotation;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class FAFQueryMethodIUDBase
implements FAFQueryMethod {
    private String contextName;
    private FireAndForgetProcessor processor;
    private InternalEventRouteDest internalEventRouteDest;
    protected QueryGraph queryGraph;
    private Annotation[] annotations;
    private Map<Integer, ExprTableEvalStrategyFactory> tableAccesses;
    private boolean hasTableAccess;

    public void setContextName(String contextName) {
        this.contextName = contextName;
    }

    public void setProcessor(FireAndForgetProcessor processor) {
        this.processor = processor;
    }

    public void setInternalEventRouteDest(InternalEventRouteDest internalEventRouteDest) {
        this.internalEventRouteDest = internalEventRouteDest;
    }

    public void setQueryGraph(QueryGraph queryGraph) {
        this.queryGraph = queryGraph;
    }

    public void setAnnotations(Annotation[] annotations) {
        this.annotations = annotations;
    }

    public void setTableAccesses(Map<Integer, ExprTableEvalStrategyFactory> tableAccesses) {
        this.tableAccesses = tableAccesses;
    }

    public void setHasTableAccess(boolean hasTableAccess) {
        this.hasTableAccess = hasTableAccess;
    }

    protected abstract EventBean[] execute(FireAndForgetInstance var1);

    @Override
    public void ready() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EPPreparedQueryResult execute(AtomicBoolean serviceStatusProvider, FAFQueryMethodAssignerSetter assignerSetter, ContextPartitionSelector[] contextPartitionSelectors, ContextManagementService contextManagementService) {
        if (!serviceStatusProvider.get()) {
            throw FAFQueryMethodUtil.runtimeDestroyed();
        }
        try {
            FireAndForgetInstance processorInstance;
            ContextPartitionSelector optionalSingleSelector;
            if (contextPartitionSelectors != null && contextPartitionSelectors.length != 1) {
                throw new IllegalArgumentException("Number of context partition selectors must be one");
            }
            ContextPartitionSelector contextPartitionSelector = optionalSingleSelector = contextPartitionSelectors != null && contextPartitionSelectors.length > 0 ? contextPartitionSelectors[0] : null;
            if (this.processor.getContextName() != null && this.contextName != null && !this.processor.getContextName().equals(this.contextName)) {
                throw new EPException("Context for named window is '" + this.processor.getContextName() + "' and query specifies context '" + this.contextName + "'");
            }
            if (this.contextName == null && (processorInstance = this.processor.getProcessorInstanceNoContext()) != null) {
                this.assign(processorInstance.getAgentInstanceContext(), assignerSetter);
                EventBean[] rows = this.execute(processorInstance);
                if (rows != null && rows.length > 0) {
                    this.dispatch();
                }
                EPPreparedQueryResult ePPreparedQueryResult = new EPPreparedQueryResult(this.processor.getEventTypePublic(), rows);
                return ePPreparedQueryResult;
            }
            Collection<Integer> agentInstanceIds = FAFQueryMethodUtil.agentInstanceIds(this.processor, optionalSingleSelector, contextManagementService);
            if (agentInstanceIds.isEmpty()) {
                EPPreparedQueryResult rows = new EPPreparedQueryResult(this.processor.getEventTypeResultSetProcessor(), CollectionUtil.EVENTBEANARRAY_EMPTY);
                return rows;
            }
            if (agentInstanceIds.size() == 1) {
                int agentInstanceId = agentInstanceIds.iterator().next();
                FireAndForgetInstance processorInstance2 = this.processor.getProcessorInstanceContextById(agentInstanceId);
                this.assign(processorInstance2.getAgentInstanceContext(), assignerSetter);
                EventBean[] rows = this.execute(processorInstance2);
                if (rows.length > 0) {
                    this.dispatch();
                }
                EPPreparedQueryResult ePPreparedQueryResult = new EPPreparedQueryResult(this.processor.getEventTypeResultSetProcessor(), rows);
                return ePPreparedQueryResult;
            }
            ArrayDeque<EventBean> allRows = new ArrayDeque<EventBean>();
            Object object = agentInstanceIds.iterator();
            while (object.hasNext()) {
                int agentInstanceId = object.next();
                FireAndForgetInstance processorInstance3 = this.processor.getProcessorInstanceContextById(agentInstanceId);
                if (processorInstance3 == null) continue;
                this.assign(processorInstance3.getAgentInstanceContext(), assignerSetter);
                EventBean[] rows = this.execute(processorInstance3);
                allRows.addAll(Arrays.asList(rows));
            }
            if (allRows.size() > 0) {
                this.dispatch();
            }
            object = new EPPreparedQueryResult(this.processor.getEventTypeResultSetProcessor(), allRows.toArray(new EventBean[allRows.size()]));
            return object;
        }
        finally {
            if (this.hasTableAccess) {
                this.processor.getStatementContext().getTableExprEvaluatorContext().releaseAcquiredLocks();
            }
        }
    }

    @Override
    public EventType getEventType() {
        return this.processor.getEventTypeResultSetProcessor();
    }

    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    protected void dispatch() {
        this.internalEventRouteDest.processThreadWorkQueue();
    }

    private void assign(AgentInstanceContext agentInstanceContext, FAFQueryMethodAssignerSetter assignerSetter) {
        Map<Integer, ExprTableEvalStrategy> tableAccessEvals = ExprTableEvalHelperStart.startTableAccess(this.tableAccesses, agentInstanceContext);
        assignerSetter.assign(new StatementAIFactoryAssignmentsImpl(null, null, null, Collections.emptyMap(), tableAccessEvals, null));
    }
}

