/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.historical.database.core;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.compile.multikey.MultiKeyPlan;
import com.espertech.esper.common.internal.compile.multikey.MultiKeyPlanner;
import com.espertech.esper.common.internal.compile.stage3.StatementBaseInfo;
import com.espertech.esper.common.internal.compile.stage3.StatementCompileTimeServices;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeableFactory;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprIdentNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeOrigin;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityQuery;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityValidate;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContextBuilder;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeIdentifierCollectVisitor;
import com.espertech.esper.common.internal.epl.historical.common.HistoricalEventViewableForgeBase;
import com.espertech.esper.common.internal.epl.historical.database.core.DBOutputTypeDesc;
import com.espertech.esper.common.internal.epl.historical.database.core.HistoricalEventViewableDatabaseFactory;
import com.espertech.esper.common.internal.epl.streamtype.StreamTypeService;
import com.espertech.esper.common.internal.util.CollectionUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HistoricalEventViewableDatabaseForge
extends HistoricalEventViewableForgeBase {
    private final String databaseName;
    private final String[] inputParameters;
    private final String preparedStatementText;
    private final Map<String, DBOutputTypeDesc> outputTypes;

    public HistoricalEventViewableDatabaseForge(int streamNum, EventType eventType, String databaseName, String[] inputParameters, String preparedStatementText, Map<String, DBOutputTypeDesc> outputTypes) {
        super(streamNum, eventType);
        this.databaseName = databaseName;
        this.inputParameters = inputParameters;
        this.preparedStatementText = preparedStatementText;
        this.outputTypes = outputTypes;
    }

    @Override
    public List<StmtClassForgeableFactory> validate(StreamTypeService typeService, StatementBaseInfo base, StatementCompileTimeServices services) throws ExprValidationException {
        int count = 0;
        ExprValidationContext validationContext = new ExprValidationContextBuilder(typeService, base.getStatementRawInfo(), services).withAllowBindingConsumption(true).build();
        ExprNode[] inputParamNodes = new ExprNode[this.inputParameters.length];
        for (String inputParam : this.inputParameters) {
            ExprNode raw = HistoricalEventViewableDatabaseForge.findSQLExpressionNode(this.streamNum, count, base.getStatementSpec().getRaw().getSqlParameters());
            if (raw == null) {
                throw new ExprValidationException("Internal error find expression for historical stream parameter " + count + " stream " + this.streamNum);
            }
            ExprNode evaluator = ExprNodeUtilityValidate.getValidatedSubtree(ExprNodeOrigin.DATABASEPOLL, raw, validationContext);
            inputParamNodes[count++] = evaluator;
            ExprNodeIdentifierCollectVisitor visitor = new ExprNodeIdentifierCollectVisitor();
            visitor.visit(evaluator);
            for (ExprIdentNode identNode : visitor.getExprProperties()) {
                if (identNode.getStreamId() == this.streamNum) {
                    throw new ExprValidationException("Invalid expression '" + inputParam + "' resolves to the historical data itself");
                }
                this.subordinateStreams.add(identNode.getStreamId());
            }
        }
        this.inputParamEvaluators = ExprNodeUtilityQuery.getForges(inputParamNodes);
        MultiKeyPlan multiKeyPlan = MultiKeyPlanner.planMultiKey(this.inputParamEvaluators, false, base.getStatementRawInfo(), services.getSerdeResolver());
        this.multiKeyClassRef = multiKeyPlan.getClassRef();
        return multiKeyPlan.getMultiKeyForgeables();
    }

    @Override
    public Class typeOfImplementation() {
        return HistoricalEventViewableDatabaseFactory.class;
    }

    @Override
    public void codegenSetter(CodegenExpressionRef ref, CodegenMethod method, SAIFFInitializeSymbol symbols, CodegenClassScope classScope) {
        method.getBlock().exprDotMethod(ref, "setDatabaseName", CodegenExpressionBuilder.constant(this.databaseName)).exprDotMethod(ref, "setInputParameters", CodegenExpressionBuilder.constant(this.inputParameters)).exprDotMethod(ref, "setPreparedStatementText", CodegenExpressionBuilder.constant(this.preparedStatementText)).exprDotMethod(ref, "setOutputTypes", this.makeOutputTypes(method, symbols, classScope));
    }

    private CodegenExpression makeOutputTypes(CodegenMethodScope parent, SAIFFInitializeSymbol symbols, CodegenClassScope classScope) {
        CodegenMethod method = parent.makeChild(Map.class, this.getClass(), (CodegenScope)classScope);
        method.getBlock().declareVar(Map.class, "types", CodegenExpressionBuilder.newInstance(HashMap.class, CodegenExpressionBuilder.constant(CollectionUtil.capacityHashMap(this.outputTypes.size()))));
        for (Map.Entry<String, DBOutputTypeDesc> entry : this.outputTypes.entrySet()) {
            method.getBlock().exprDotMethod(CodegenExpressionBuilder.ref("types"), "put", CodegenExpressionBuilder.constant(entry.getKey()), entry.getValue().make());
        }
        method.getBlock().methodReturn(CodegenExpressionBuilder.ref("types"));
        return CodegenExpressionBuilder.localMethod(method, new CodegenExpression[0]);
    }

    private static ExprNode findSQLExpressionNode(int myStreamNumber, int count, Map<Integer, List<ExprNode>> sqlParameters) {
        if (sqlParameters == null || sqlParameters.isEmpty()) {
            return null;
        }
        List<ExprNode> parameters = sqlParameters.get(myStreamNumber);
        if (parameters == null || parameters.isEmpty() || parameters.size() < count + 1) {
            return null;
        }
        return parameters.get(count);
    }
}

