/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.historical.datacache;

import com.espertech.esper.common.client.util.CacheReferenceType;
import com.espertech.esper.common.internal.collection.apachecommons.ReferenceMap;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.context.util.EPStatementHandleCallbackSchedule;
import com.espertech.esper.common.internal.epl.expression.time.abacus.TimeAbacus;
import com.espertech.esper.common.internal.epl.historical.datacache.HistoricalDataCache;
import com.espertech.esper.common.internal.epl.index.base.EventTable;
import com.espertech.esper.common.internal.schedule.ScheduleHandleCallback;
import com.espertech.esper.common.internal.schedule.ScheduleObjectType;
import com.espertech.esper.common.internal.schedule.SchedulingService;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;

public class HistoricalDataCacheExpiringImpl
implements HistoricalDataCache,
ScheduleHandleCallback {
    private static final String NAME_AUDITPROVIDER_SCHEDULE = "historical data-cache";
    private final double maxAgeSec;
    private final double purgeIntervalSec;
    private final AgentInstanceContext agentInstanceContext;
    private final long scheduleSlot;
    private final Map<Object, Item> cache;
    private boolean isScheduled;

    public HistoricalDataCacheExpiringImpl(double maxAgeSec, double purgeIntervalSec, CacheReferenceType cacheReferenceType, AgentInstanceContext agentInstanceContext, long scheduleSlot) {
        this.maxAgeSec = maxAgeSec;
        this.purgeIntervalSec = purgeIntervalSec;
        this.agentInstanceContext = agentInstanceContext;
        this.scheduleSlot = scheduleSlot;
        this.cache = cacheReferenceType == CacheReferenceType.HARD ? new HashMap<Object, Item>() : (cacheReferenceType == CacheReferenceType.SOFT ? new ReferenceMap(1, 1) : new WeakHashMap<Object, Item>());
    }

    @Override
    public EventTable[] getCached(Object methodParams) {
        Object key = methodParams;
        Item item = this.cache.get(key);
        if (item == null) {
            return null;
        }
        long now = this.agentInstanceContext.getSchedulingService().getTime();
        long maxAgeMSec = this.agentInstanceContext.getClasspathImportServiceRuntime().getTimeAbacus().deltaForSecondsDouble(this.maxAgeSec);
        if (now - item.getTime() > maxAgeMSec) {
            this.cache.remove(key);
            return null;
        }
        return item.getData();
    }

    @Override
    public void put(Object methodParams, EventTable[] rows) {
        SchedulingService schedulingService = this.agentInstanceContext.getSchedulingService();
        TimeAbacus timeAbacus = this.agentInstanceContext.getClasspathImportServiceRuntime().getTimeAbacus();
        Object key = methodParams;
        long now = schedulingService.getTime();
        Item item = new Item(rows, now);
        this.cache.put(key, item);
        if (!this.isScheduled) {
            EPStatementHandleCallbackSchedule callback = new EPStatementHandleCallbackSchedule(this.agentInstanceContext.getEpStatementAgentInstanceHandle(), this);
            long timeDelta = timeAbacus.deltaForSecondsDouble(this.purgeIntervalSec);
            this.agentInstanceContext.getAuditProvider().scheduleAdd(timeDelta, this.agentInstanceContext, callback, ScheduleObjectType.historicaldatacache, NAME_AUDITPROVIDER_SCHEDULE);
            schedulingService.add(timeDelta, callback, this.scheduleSlot);
            this.isScheduled = true;
        }
    }

    protected double getMaxAgeSec() {
        return this.maxAgeSec;
    }

    public double getPurgeIntervalSec() {
        return this.purgeIntervalSec;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    protected long getSize() {
        return this.cache.size();
    }

    @Override
    public void scheduledTrigger() {
        this.agentInstanceContext.getInstrumentationProvider().qHistoricalScheduledEval();
        this.agentInstanceContext.getAuditProvider().scheduleFire(this.agentInstanceContext, ScheduleObjectType.historicaldatacache, NAME_AUDITPROVIDER_SCHEDULE);
        long now = this.agentInstanceContext.getSchedulingService().getTime();
        Iterator<Object> it = this.cache.keySet().iterator();
        long maxAgeMSec = this.agentInstanceContext.getClasspathImportServiceRuntime().getTimeAbacus().deltaForSecondsDouble(this.maxAgeSec);
        while (it.hasNext()) {
            Item item = this.cache.get(it.next());
            if (now - item.getTime() <= maxAgeMSec) continue;
            it.remove();
        }
        this.isScheduled = false;
        this.agentInstanceContext.getInstrumentationProvider().aHistoricalScheduledEval();
    }

    @Override
    public void destroy() {
    }

    private static class Item {
        private EventTable[] data;
        private long time;

        public Item(EventTable[] data, long time) {
            this.data = data;
            this.time = time;
        }

        public EventTable[] getData() {
            return this.data;
        }

        public long getTime() {
            return this.time;
        }
    }
}

