/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.historical.datacache;

import com.espertech.esper.common.internal.epl.historical.datacache.HistoricalDataCache;
import com.espertech.esper.common.internal.epl.index.base.EventTable;
import java.util.LinkedHashMap;
import java.util.Map;

public class HistoricalDataCacheLRUImpl
implements HistoricalDataCache {
    private final int cacheSize;
    private static final float HASH_TABLE_LOAD_FACTOR = 0.75f;
    private final LinkedHashMap<Object, EventTable[]> cache;

    public HistoricalDataCacheLRUImpl(int cacheSize) {
        this.cacheSize = cacheSize;
        int hashTableCapacity = (int)Math.ceil((float)cacheSize / 0.75f) + 1;
        this.cache = new LinkedHashMap<Object, EventTable[]>(hashTableCapacity, 0.75f, true){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<Object, EventTable[]> eldest) {
                return this.size() > HistoricalDataCacheLRUImpl.this.cacheSize;
            }
        };
    }

    @Override
    public EventTable[] getCached(Object methodParams) {
        Object key = methodParams;
        return this.cache.get(key);
    }

    @Override
    public synchronized void put(Object methodParams, EventTable[] rows) {
        Object key = methodParams;
        this.cache.put(key, rows);
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public void destroy() {
    }
}

