/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.historical.indexingstrategy;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventPropertyValueGetter;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.historical.indexingstrategy.PollResultIndexingStrategy;
import com.espertech.esper.common.internal.epl.historical.indexingstrategy.UnindexedEventTableList;
import com.espertech.esper.common.internal.epl.index.base.EventTable;
import com.espertech.esper.common.internal.epl.index.composite.PropertyCompositeEventTableFactory;
import java.util.List;

public class PollResultIndexingStrategyComposite
implements PollResultIndexingStrategy {
    private int streamNum;
    private String[] optionalKeyedProps;
    private Class[] optKeyCoercedTypes;
    private EventPropertyValueGetter hashGetter;
    private String[] rangeProps;
    private Class[] optRangeCoercedTypes;
    private EventPropertyValueGetter[] rangeGetters;
    private PropertyCompositeEventTableFactory factory;

    @Override
    public EventTable[] index(List<EventBean> pollResult, boolean isActiveCache, AgentInstanceContext agentInstanceContext) {
        EventTable[] tables;
        if (!isActiveCache) {
            return new EventTable[]{new UnindexedEventTableList(pollResult, this.streamNum)};
        }
        for (EventTable table : tables = this.factory.makeEventTables(agentInstanceContext, null)) {
            table.add(pollResult.toArray(new EventBean[pollResult.size()]), (ExprEvaluatorContext)agentInstanceContext);
        }
        return tables;
    }

    public void init() {
        this.factory = new PropertyCompositeEventTableFactory(this.streamNum, this.optionalKeyedProps, this.optKeyCoercedTypes, this.hashGetter, null, this.rangeProps, this.optRangeCoercedTypes, this.rangeGetters);
    }

    public void setStreamNum(int streamNum) {
        this.streamNum = streamNum;
    }

    public void setOptionalKeyedProps(String[] optionalKeyedProps) {
        this.optionalKeyedProps = optionalKeyedProps;
    }

    public void setOptKeyCoercedTypes(Class[] optKeyCoercedTypes) {
        this.optKeyCoercedTypes = optKeyCoercedTypes;
    }

    public void setHashGetter(EventPropertyValueGetter hashGetter) {
        this.hashGetter = hashGetter;
    }

    public void setRangeProps(String[] rangeProps) {
        this.rangeProps = rangeProps;
    }

    public void setOptRangeCoercedTypes(Class[] optRangeCoercedTypes) {
        this.optRangeCoercedTypes = optRangeCoercedTypes;
    }

    public void setRangeGetters(EventPropertyValueGetter[] rangeGetters) {
        this.rangeGetters = rangeGetters;
    }

    public void setFactory(PropertyCompositeEventTableFactory factory) {
        this.factory = factory;
    }
}

