/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.index.advanced.index.quadtree;

import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeOrigin;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodePropOrStreamDesc;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityQuery;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityValidate;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.declared.compiletime.ExprDeclaredNode;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotNode;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotNodeImpl;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeIdentifierAndStreamRefVisitor;
import com.espertech.esper.common.internal.epl.index.advanced.index.service.AdvancedIndexFactoryProvider;
import com.espertech.esper.common.internal.epl.index.advanced.index.service.FilterExprAnalyzerAffectorIndexProvision;
import com.espertech.esper.common.internal.epl.join.analyze.FilterExprAnalyzerAffector;
import com.espertech.esper.common.internal.epl.lookup.AdvancedIndexConfigContextPartition;
import com.espertech.esper.common.internal.filterspec.FilterSpecCompilerAdvIndexDesc;
import com.espertech.esper.common.internal.settings.ClasspathImportException;
import com.espertech.esper.common.internal.settings.SettingsApplicationDotMethod;
import com.espertech.esper.common.internal.util.CollectionUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;

public abstract class SettingsApplicationDotMethodBase
implements SettingsApplicationDotMethod {
    protected static final String LHS_VALIDATION_NAME = "left-hand-side";
    protected static final String RHS_VALIDATION_NAME = "right-hand-side";
    protected final ExprDotNodeImpl parent;
    private final String lhsName;
    private final ExprNode[] lhs;
    private final String dotMethodName;
    private final String rhsName;
    private final ExprNode[] rhs;
    private final ExprNode[] indexNamedParameter;
    private String optionalIndexName;
    private AdvancedIndexConfigContextPartition optionalIndexConfig;
    private transient ExprForge forge;

    protected abstract ExprForge validateAll(String var1, ExprNode[] var2, String var3, ExprNode[] var4, ExprValidationContext var5) throws ExprValidationException;

    protected abstract String indexTypeName();

    protected abstract String operationName();

    public SettingsApplicationDotMethodBase(ExprDotNodeImpl parent, String lhsName, ExprNode[] lhs, String dotMethodName, String rhsName, ExprNode[] rhs, ExprNode[] indexNamedParameter) {
        this.parent = parent;
        this.lhsName = lhsName;
        this.lhs = lhs;
        this.dotMethodName = dotMethodName;
        this.rhsName = rhsName;
        this.rhs = rhs;
        this.indexNamedParameter = indexNamedParameter;
    }

    @Override
    public ExprForge getForge() {
        return this.forge;
    }

    @Override
    public String getLhsName() {
        return this.lhsName;
    }

    @Override
    public ExprNode[] getLhs() {
        return this.lhs;
    }

    @Override
    public String getDotMethodName() {
        return this.dotMethodName;
    }

    @Override
    public String getRhsName() {
        return this.rhsName;
    }

    @Override
    public ExprNode[] getRhs() {
        return this.rhs;
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        ExprNodeUtilityValidate.getValidatedSubtree(ExprNodeOrigin.DOTNODEPARAMETER, this.lhs, validationContext);
        ExprNodeUtilityValidate.getValidatedSubtree(ExprNodeOrigin.DOTNODEPARAMETER, this.rhs, validationContext);
        this.forge = this.validateAll(this.lhsName, this.lhs, this.rhsName, this.rhs, validationContext);
        if (this.indexNamedParameter != null) {
            this.validateIndexNamedParameter(validationContext);
        }
        return null;
    }

    @Override
    public FilterExprAnalyzerAffector getFilterExprAnalyzerAffector() {
        ExprNodeIdentifierAndStreamRefVisitor visitor = new ExprNodeIdentifierAndStreamRefVisitor(false);
        for (ExprNode lhsNode : this.lhs) {
            lhsNode.accept(visitor);
        }
        HashSet<Integer> indexedPropertyStreams = new HashSet<Integer>();
        for (ExprNodePropOrStreamDesc ref : visitor.getRefs()) {
            indexedPropertyStreams.add(ref.getStreamNum());
        }
        if (indexedPropertyStreams.size() == 0 || indexedPropertyStreams.size() > 1) {
            return null;
        }
        int streamNumIndex = (Integer)indexedPropertyStreams.iterator().next();
        ArrayList<Pair<ExprNode, int[]>> keyExpressions = new ArrayList<Pair<ExprNode, int[]>>();
        HashSet<Integer> dependencies = new HashSet<Integer>();
        for (ExprNode node : this.rhs) {
            visitor.reset();
            dependencies.clear();
            node.accept(visitor);
            for (ExprNodePropOrStreamDesc ref : visitor.getRefs()) {
                dependencies.add(ref.getStreamNum());
            }
            if (dependencies.contains(streamNumIndex)) {
                return null;
            }
            Pair<ExprNode, int[]> pair = new Pair<ExprNode, int[]>(node, CollectionUtil.intArray(dependencies));
            keyExpressions.add(pair);
        }
        return new FilterExprAnalyzerAffectorIndexProvision(this.operationName(), this.lhs, keyExpressions, streamNumIndex);
    }

    @Override
    public FilterSpecCompilerAdvIndexDesc getFilterSpecCompilerAdvIndexDesc() {
        if (this.indexNamedParameter == null) {
            return null;
        }
        return new FilterSpecCompilerAdvIndexDesc(this.lhs, this.rhs, this.optionalIndexConfig, this.indexTypeName(), this.optionalIndexName);
    }

    private void validateIndexNamedParameter(ExprValidationContext validationContext) throws ExprValidationException {
        if (this.indexNamedParameter.length != 1 || !(this.indexNamedParameter[0] instanceof ExprDeclaredNode)) {
            throw this.getIndexNameMessage("requires an expression name");
        }
        ExprDeclaredNode node = (ExprDeclaredNode)this.indexNamedParameter[0];
        if (!(node.getBody() instanceof ExprDotNode)) {
            throw this.getIndexNameMessage("requires an index expression");
        }
        ExprDotNode dotNode = (ExprDotNode)node.getBody();
        if (dotNode.getChainSpec().size() > 1) {
            throw this.getIndexNameMessage("invalid chained index expression");
        }
        List<ExprNode> params = dotNode.getChainSpec().get(0).getParameters();
        String indexTypeName = dotNode.getChainSpec().get(0).getName();
        this.optionalIndexName = node.getPrototype().getName();
        AdvancedIndexFactoryProvider provider = null;
        try {
            provider = validationContext.getClasspathImportService().resolveAdvancedIndexProvider(indexTypeName);
        }
        catch (ClasspathImportException e) {
            throw new ExprValidationException(e.getMessage(), e);
        }
        if (!indexTypeName.toLowerCase(Locale.ENGLISH).equals(this.indexTypeName())) {
            throw new ExprValidationException("Invalid index type '" + indexTypeName + "', expected '" + this.indexTypeName() + "'");
        }
        this.optionalIndexConfig = provider.validateConfigureFilterIndex(this.optionalIndexName, indexTypeName, ExprNodeUtilityQuery.toArray(params), validationContext);
    }

    private ExprValidationException getIndexNameMessage(String message) {
        return new ExprValidationException("Named parameter 'filterindex' " + message);
    }
}

