/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.index.base;

import com.espertech.esper.common.client.EventPropertyValueGetter;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.serde.DataInputOutputSerde;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.epl.index.base.EventTable;
import com.espertech.esper.common.internal.epl.index.base.EventTableFactory;
import com.espertech.esper.common.internal.epl.index.base.EventTableIndexService;
import com.espertech.esper.common.internal.epl.join.queryplan.QueryPlanIndexItem;

public class EventTableUtil {
    public static EventTable buildIndex(AgentInstanceContext agentInstanceContext, int indexedStreamNum, QueryPlanIndexItem item, EventType eventType, boolean coerceOnAddOnly, boolean unique, String optionalIndexName, DataInputOutputSerde<Object> optionalValueSerde, boolean isFireAndForget) {
        EventTable table;
        String[] indexProps = item.getHashProps();
        Class[] indexTypes = item.getHashPropTypes();
        EventPropertyValueGetter indexGetter = item.getHashGetter();
        String[] rangeProps = item.getRangeProps();
        Class[] rangeTypes = item.getRangePropTypes();
        EventPropertyValueGetter[] rangeGetters = item.getRangeGetters();
        DataInputOutputSerde<Object>[] rangeKeySerdes = item.getRangeKeySerdes();
        EventTableIndexService eventTableIndexService = agentInstanceContext.getStatementContext().getEventTableIndexService();
        if (item.getAdvancedIndexProvisionDesc() != null) {
            table = eventTableIndexService.createCustom(optionalIndexName, indexedStreamNum, eventType, item.isUnique(), item.getAdvancedIndexProvisionDesc()).makeEventTables(agentInstanceContext, null)[0];
        } else if (rangeProps == null || rangeProps.length == 0) {
            if (indexProps == null || indexProps.length == 0) {
                EventTableFactory factory = eventTableIndexService.createUnindexed(indexedStreamNum, eventType, optionalValueSerde, isFireAndForget, agentInstanceContext.getStatementContext());
                table = factory.makeEventTables(agentInstanceContext, null)[0];
            } else {
                EventTableFactory factory = eventTableIndexService.createHashedOnly(indexedStreamNum, eventType, indexProps, indexTypes, item.getTransformFireAndForget(), item.getHashKeySerde(), unique, optionalIndexName, indexGetter, optionalValueSerde, isFireAndForget, agentInstanceContext.getStatementContext());
                table = factory.makeEventTables(agentInstanceContext, null)[0];
            }
        } else if (rangeProps.length == 1 && (indexProps == null || indexProps.length == 0)) {
            EventTableFactory factory = eventTableIndexService.createSorted(indexedStreamNum, eventType, rangeProps[0], rangeTypes[0], rangeGetters[0], rangeKeySerdes[0], optionalValueSerde, isFireAndForget, agentInstanceContext.getStatementContext());
            table = factory.makeEventTables(agentInstanceContext, null)[0];
        } else {
            EventTableFactory factory = eventTableIndexService.createComposite(indexedStreamNum, eventType, indexProps, indexTypes, indexGetter, item.getTransformFireAndForget(), item.getHashKeySerde(), rangeProps, rangeTypes, rangeGetters, rangeKeySerdes, optionalValueSerde, isFireAndForget);
            return factory.makeEventTables(agentInstanceContext, null)[0];
        }
        return table;
    }
}

