/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.index.hash;

import com.espertech.esper.common.client.EventPropertyValueGetter;
import com.espertech.esper.common.internal.collection.MultiKeyFromObjectArray;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.epl.index.base.EventTable;
import com.espertech.esper.common.internal.epl.index.base.EventTableFactory;
import com.espertech.esper.common.internal.epl.index.base.EventTableOrganization;
import com.espertech.esper.common.internal.epl.index.base.EventTableOrganizationType;
import com.espertech.esper.common.internal.epl.index.hash.PropertyHashedEventTableUnadorned;
import com.espertech.esper.common.internal.epl.index.hash.PropertyHashedEventTableUnique;
import java.util.Arrays;

public class PropertyHashedEventTableFactory
implements EventTableFactory {
    protected final int streamNum;
    protected final String[] propertyNames;
    protected final boolean unique;
    protected final String optionalIndexName;
    protected final EventPropertyValueGetter propertyGetter;
    protected final MultiKeyFromObjectArray multiKeyTransform;

    public PropertyHashedEventTableFactory(int streamNum, String[] propertyNames, boolean unique, String optionalIndexName, EventPropertyValueGetter propertyGetter, MultiKeyFromObjectArray multiKeyTransform) {
        this.streamNum = streamNum;
        this.propertyNames = propertyNames;
        this.unique = unique;
        this.optionalIndexName = optionalIndexName;
        this.propertyGetter = propertyGetter;
        this.multiKeyTransform = multiKeyTransform;
        if (propertyGetter == null) {
            throw new IllegalArgumentException("Property-getter is null");
        }
    }

    @Override
    public EventTable[] makeEventTables(AgentInstanceContext agentInstanceContext, Integer subqueryNumber) {
        if (this.unique) {
            return new EventTable[]{new PropertyHashedEventTableUnique(this)};
        }
        return new EventTable[]{new PropertyHashedEventTableUnadorned(this)};
    }

    @Override
    public Class getEventTableClass() {
        if (this.unique) {
            return PropertyHashedEventTableUnique.class;
        }
        return PropertyHashedEventTableUnadorned.class;
    }

    @Override
    public String toQueryPlan() {
        return this.getClass().getSimpleName() + (this.unique ? " unique" : " non-unique") + " streamNum=" + this.streamNum + " propertyNames=" + Arrays.asList(this.propertyNames);
    }

    public EventTableOrganization getOrganization() {
        return new EventTableOrganization(this.optionalIndexName, this.unique, false, this.streamNum, this.propertyNames, EventTableOrganizationType.HASH);
    }
}

