/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.index.hash;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.index.base.EventTableAsSet;
import com.espertech.esper.common.internal.epl.index.hash.PropertyHashedEventTable;
import com.espertech.esper.common.internal.epl.index.hash.PropertyHashedEventTableFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class PropertyHashedEventTableUnique
extends PropertyHashedEventTable
implements EventTableAsSet {
    private final Map<Object, EventBean> propertyIndex = new HashMap<Object, EventBean>();

    public PropertyHashedEventTableUnique(PropertyHashedEventTableFactory factory) {
        super(factory);
    }

    @Override
    public Set<EventBean> lookup(Object key) {
        EventBean event = this.propertyIndex.get(key);
        if (event != null) {
            return Collections.singleton(event);
        }
        return null;
    }

    @Override
    public int getNumKeys() {
        return this.propertyIndex.size();
    }

    @Override
    public Object getIndex() {
        return this.propertyIndex;
    }

    @Override
    public void addRemove(EventBean[] newData, EventBean[] oldData, ExprEvaluatorContext exprEvaluatorContext) {
        exprEvaluatorContext.getInstrumentationProvider().qIndexAddRemove(this, newData, oldData);
        if (oldData != null) {
            for (EventBean theEvent : oldData) {
                this.remove(theEvent, exprEvaluatorContext);
            }
        }
        if (newData != null) {
            for (EventBean theEvent : newData) {
                this.add(theEvent, exprEvaluatorContext);
            }
        }
        exprEvaluatorContext.getInstrumentationProvider().aIndexAddRemove();
    }

    @Override
    public void add(EventBean theEvent, ExprEvaluatorContext exprEvaluatorContext) {
        Object key = this.getKey(theEvent);
        EventBean existing = this.propertyIndex.put(key, theEvent);
        if (existing != null && !existing.equals(theEvent)) {
            throw PropertyHashedEventTableUnique.handleUniqueIndexViolation(this.factory.getOrganization().getIndexName(), key);
        }
    }

    @Override
    public void remove(EventBean theEvent, ExprEvaluatorContext exprEvaluatorContext) {
        Object key = this.getKey(theEvent);
        this.propertyIndex.remove(key);
    }

    @Override
    public boolean isEmpty() {
        return this.propertyIndex.isEmpty();
    }

    @Override
    public Iterator<EventBean> iterator() {
        return this.propertyIndex.values().iterator();
    }

    @Override
    public void clear() {
        this.propertyIndex.clear();
    }

    @Override
    public void destroy() {
        this.clear();
    }

    @Override
    public String toString() {
        return this.toQueryPlan();
    }

    @Override
    public Integer getNumberOfEvents() {
        return this.propertyIndex.size();
    }

    @Override
    public Set<EventBean> allValues() {
        if (this.propertyIndex.isEmpty()) {
            return Collections.emptySet();
        }
        return new HashSet<EventBean>(this.propertyIndex.values());
    }

    @Override
    public Class getProviderClass() {
        return PropertyHashedEventTableUnique.class;
    }

    public Map<Object, EventBean> getPropertyIndex() {
        return this.propertyIndex;
    }

    public static EPException handleUniqueIndexViolation(String indexName, Object key) {
        String indexNameDisplay = indexName == null ? "" : " '" + indexName + "'";
        throw new EPException("Unique index violation, index" + indexNameDisplay + " is a unique index and key '" + key + "' already exists");
    }
}

