/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.index.inkeyword;

import com.espertech.esper.common.client.EventPropertyValueGetter;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.epl.index.base.EventTable;
import com.espertech.esper.common.internal.epl.index.base.EventTableFactory;
import com.espertech.esper.common.internal.epl.index.hash.PropertyHashedEventTable;
import com.espertech.esper.common.internal.epl.index.hash.PropertyHashedEventTableFactory;
import com.espertech.esper.common.internal.epl.index.hash.PropertyHashedEventTableUnadorned;
import com.espertech.esper.common.internal.epl.index.hash.PropertyHashedEventTableUnique;
import java.util.Arrays;

public class PropertyHashedArrayFactory
implements EventTableFactory {
    protected final int streamNum;
    protected final String[] propertyNames;
    protected final boolean unique;
    protected final String optionalIndexName;
    protected final EventPropertyValueGetter[] propertyGetters;
    protected final PropertyHashedEventTableFactory[] factories;

    public PropertyHashedArrayFactory(int streamNum, String[] propertyNames, boolean unique, String optionalIndexName, EventPropertyValueGetter[] propertyGetters) {
        this.streamNum = streamNum;
        this.propertyNames = propertyNames;
        this.unique = unique;
        this.optionalIndexName = optionalIndexName;
        this.propertyGetters = propertyGetters;
        this.factories = new PropertyHashedEventTableFactory[propertyGetters.length];
        for (int i = 0; i < this.factories.length; ++i) {
            this.factories[i] = new PropertyHashedEventTableFactory(streamNum, new String[]{propertyNames[i]}, unique, null, propertyGetters[i], null);
        }
    }

    @Override
    public EventTable[] makeEventTables(AgentInstanceContext agentInstanceContext, Integer subqueryNumber) {
        EventTable[] tables = new EventTable[this.propertyGetters.length];
        if (this.unique) {
            for (int i = 0; i < tables.length; ++i) {
                tables[i] = new PropertyHashedEventTableUnique(this.factories[i]);
            }
        } else {
            for (int i = 0; i < tables.length; ++i) {
                tables[i] = new PropertyHashedEventTableUnadorned(this.factories[i]);
            }
        }
        return tables;
    }

    @Override
    public Class getEventTableClass() {
        if (this.unique) {
            return PropertyHashedEventTableUnique.class;
        }
        return PropertyHashedEventTable.class;
    }

    @Override
    public String toQueryPlan() {
        return this.getClass().getSimpleName() + (this.unique ? " unique" : " non-unique") + " streamNum=" + this.streamNum + " propertyNames=" + Arrays.toString(this.propertyNames);
    }
}

