/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.index.inkeyword;

import com.espertech.esper.common.client.EventPropertyValueGetter;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeSymbol;
import com.espertech.esper.common.internal.epl.index.base.EventTableFactoryFactoryForge;
import com.espertech.esper.common.internal.epl.index.hash.PropertyHashedEventTable;
import com.espertech.esper.common.internal.epl.index.inkeyword.PropertyHashedArrayFactoryFactory;
import com.espertech.esper.common.internal.event.core.EventPropertyGetterSPI;
import com.espertech.esper.common.internal.event.core.EventTypeSPI;
import com.espertech.esper.common.internal.event.core.EventTypeUtility;
import com.espertech.esper.common.internal.serde.compiletime.resolve.DataInputOutputSerdeForge;
import java.util.Arrays;

public class PropertyHashedArrayFactoryFactoryForge
implements EventTableFactoryFactoryForge {
    protected final int streamNum;
    protected final EventType eventType;
    protected final String[] propertyNames;
    protected final Class[] propertyTypes;
    protected final DataInputOutputSerdeForge[] serdes;
    protected final boolean unique;
    protected final boolean isFireAndForget;

    public PropertyHashedArrayFactoryFactoryForge(int streamNum, EventType eventType, String[] propertyNames, Class[] propertyTypes, DataInputOutputSerdeForge[] serdes, boolean unique, boolean isFireAndForget) {
        this.streamNum = streamNum;
        this.eventType = eventType;
        this.propertyNames = propertyNames;
        this.propertyTypes = propertyTypes;
        this.serdes = serdes;
        this.unique = unique;
        this.isFireAndForget = isFireAndForget;
    }

    @Override
    public Class getEventTableClass() {
        return PropertyHashedEventTable.class;
    }

    @Override
    public CodegenExpression make(CodegenMethodScope parent, SAIFFInitializeSymbol symbols, CodegenClassScope classScope) {
        CodegenMethod method = parent.makeChild(PropertyHashedArrayFactoryFactory.class, this.getClass(), (CodegenScope)classScope);
        method.getBlock().declareVar(EventPropertyValueGetter[].class, "getters", CodegenExpressionBuilder.newArrayByLength(EventPropertyValueGetter.class, CodegenExpressionBuilder.constant(this.propertyNames.length)));
        for (int i = 0; i < this.propertyNames.length; ++i) {
            EventPropertyGetterSPI getterSPI = ((EventTypeSPI)this.eventType).getGetterSPI(this.propertyNames[i]);
            CodegenExpression getter = EventTypeUtility.codegenGetterWCoerce(getterSPI, this.propertyTypes[i], this.propertyTypes[i], method, this.getClass(), classScope);
            method.getBlock().assignArrayElement(CodegenExpressionBuilder.ref("getters"), CodegenExpressionBuilder.constant(i), getter);
        }
        method.getBlock().methodReturn(CodegenExpressionBuilder.newInstance(PropertyHashedArrayFactoryFactory.class, CodegenExpressionBuilder.constant(this.streamNum), CodegenExpressionBuilder.constant(this.propertyNames), CodegenExpressionBuilder.constant(this.propertyTypes), DataInputOutputSerdeForge.codegenArray(this.serdes, method, classScope, null), CodegenExpressionBuilder.constant(this.unique), CodegenExpressionBuilder.ref("getters"), CodegenExpressionBuilder.constant(this.isFireAndForget)));
        return CodegenExpressionBuilder.localMethod(method, new CodegenExpression[0]);
    }

    @Override
    public String toQueryPlan() {
        return this.getClass().getSimpleName() + (this.unique ? " unique" : " non-unique") + " streamNum=" + this.streamNum + " propertyNames=" + Arrays.toString(this.propertyNames);
    }
}

