/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.index.sorted;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.index.base.EventTable;
import com.espertech.esper.common.internal.epl.index.base.EventTableOrganization;
import com.espertech.esper.common.internal.epl.index.sorted.PropertySortedEventTableFactory;
import com.espertech.esper.common.internal.epl.join.exec.util.RangeIndexLookupValue;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;

public abstract class PropertySortedEventTable
implements EventTable {
    protected final PropertySortedEventTableFactory factory;

    public abstract Set<EventBean> lookupRange(Object var1, boolean var2, Object var3, boolean var4, boolean var5);

    public abstract Collection<EventBean> lookupRangeColl(Object var1, boolean var2, Object var3, boolean var4, boolean var5);

    public abstract Set<EventBean> lookupRangeInverted(Object var1, boolean var2, Object var3, boolean var4);

    public abstract Collection<EventBean> lookupRangeInvertedColl(Object var1, boolean var2, Object var3, boolean var4);

    public abstract Set<EventBean> lookupLess(Object var1);

    public abstract Collection<EventBean> lookupLessThenColl(Object var1);

    public abstract Set<EventBean> lookupLessEqual(Object var1);

    public abstract Collection<EventBean> lookupLessEqualColl(Object var1);

    public abstract Set<EventBean> lookupGreaterEqual(Object var1);

    public abstract Collection<EventBean> lookupGreaterEqualColl(Object var1);

    public abstract Set<EventBean> lookupGreater(Object var1);

    public abstract Collection<EventBean> lookupGreaterColl(Object var1);

    public abstract Set<EventBean> lookupConstants(RangeIndexLookupValue var1);

    public PropertySortedEventTable(PropertySortedEventTableFactory factory) {
        this.factory = factory;
    }

    protected Object getIndexedValue(EventBean theEvent) {
        return this.factory.propertyGetter.get(theEvent);
    }

    @Override
    public void addRemove(EventBean[] newData, EventBean[] oldData, ExprEvaluatorContext exprEvaluatorContext) {
        exprEvaluatorContext.getInstrumentationProvider().qIndexAddRemove(this, newData, oldData);
        if (newData != null) {
            for (EventBean theEvent : newData) {
                this.add(theEvent, exprEvaluatorContext);
            }
        }
        if (oldData != null) {
            for (EventBean theEvent : oldData) {
                this.remove(theEvent, exprEvaluatorContext);
            }
        }
        exprEvaluatorContext.getInstrumentationProvider().aIndexAddRemove();
    }

    @Override
    public void add(EventBean[] events, ExprEvaluatorContext exprEvaluatorContext) {
        if (events != null) {
            for (EventBean theEvent : events) {
                this.add(theEvent, exprEvaluatorContext);
            }
        }
    }

    @Override
    public void remove(EventBean[] events, ExprEvaluatorContext exprEvaluatorContext) {
        if (events != null) {
            for (EventBean theEvent : events) {
                this.remove(theEvent, exprEvaluatorContext);
            }
        }
    }

    @Override
    public Integer getNumberOfEvents() {
        return null;
    }

    protected static Set<EventBean> normalize(SortedMap<Object, Set<EventBean>> submap) {
        if (submap.size() == 0) {
            return null;
        }
        if (submap.size() == 1) {
            return (Set)submap.get(submap.firstKey());
        }
        LinkedHashSet<EventBean> result = new LinkedHashSet<EventBean>();
        for (Map.Entry<Object, Set<EventBean>> entry : submap.entrySet()) {
            result.addAll((Collection<EventBean>)entry.getValue());
        }
        return result;
    }

    protected static Collection<EventBean> normalizeCollection(SortedMap<Object, Set<EventBean>> submap) {
        if (submap.size() == 0) {
            return null;
        }
        if (submap.size() == 1) {
            return (Collection)submap.get(submap.firstKey());
        }
        ArrayDeque<EventBean> result = new ArrayDeque<EventBean>();
        for (Map.Entry<Object, Set<EventBean>> entry : submap.entrySet()) {
            result.addAll((Collection<EventBean>)entry.getValue());
        }
        return result;
    }

    protected static Collection<EventBean> normalizeCollection(SortedMap<Object, Set<EventBean>> submapOne, SortedMap<Object, Set<EventBean>> submapTwo) {
        if (submapOne.size() == 0) {
            return PropertySortedEventTable.normalizeCollection(submapTwo);
        }
        if (submapTwo.size() == 0) {
            return PropertySortedEventTable.normalizeCollection(submapOne);
        }
        ArrayDeque<EventBean> result = new ArrayDeque<EventBean>();
        for (Map.Entry<Object, Set<EventBean>> entry : submapOne.entrySet()) {
            result.addAll((Collection)entry.getValue());
        }
        for (Map.Entry<Object, Set<EventBean>> entry : submapTwo.entrySet()) {
            result.addAll((Collection<EventBean>)entry.getValue());
        }
        return result;
    }

    protected static Set<EventBean> normalize(SortedMap<Object, Set<EventBean>> submapOne, SortedMap<Object, Set<EventBean>> submapTwo) {
        if (submapOne.size() == 0) {
            return PropertySortedEventTable.normalize(submapTwo);
        }
        if (submapTwo.size() == 0) {
            return PropertySortedEventTable.normalize(submapOne);
        }
        LinkedHashSet<EventBean> result = new LinkedHashSet<EventBean>();
        for (Map.Entry<Object, Set<EventBean>> entry : submapOne.entrySet()) {
            result.addAll((Collection)entry.getValue());
        }
        for (Map.Entry<Object, Set<EventBean>> entry : submapTwo.entrySet()) {
            result.addAll((Collection<EventBean>)entry.getValue());
        }
        return result;
    }

    @Override
    public String toQueryPlan() {
        return this.getClass().getSimpleName() + " streamNum=" + this.factory.getOrganization().getStreamNum();
    }

    @Override
    public EventTableOrganization getOrganization() {
        return this.factory.getOrganization();
    }

    public Class getValueType() {
        return this.factory.valueType;
    }
}

