/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.join.base;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.context.util.EPStatementDispatch;
import com.espertech.esper.common.internal.epl.join.base.JoinExecutionStrategy;
import com.espertech.esper.common.internal.event.core.FlushedEventBuffer;
import com.espertech.esper.common.internal.metrics.instrumentation.InstrumentationCommon;
import com.espertech.esper.common.internal.view.util.BufferObserver;
import java.util.HashMap;
import java.util.Map;

public class JoinExecStrategyDispatchable
implements BufferObserver,
EPStatementDispatch {
    private final JoinExecutionStrategy joinExecutionStrategy;
    private final Map<Integer, FlushedEventBuffer> oldStreamBuffer;
    private final Map<Integer, FlushedEventBuffer> newStreamBuffer;
    private final int numStreams;
    private final AgentInstanceContext agentInstanceContext;
    private boolean hasNewData;

    public JoinExecStrategyDispatchable(JoinExecutionStrategy joinExecutionStrategy, int numStreams, AgentInstanceContext agentInstanceContext) {
        this.joinExecutionStrategy = joinExecutionStrategy;
        this.numStreams = numStreams;
        this.agentInstanceContext = agentInstanceContext;
        this.oldStreamBuffer = new HashMap<Integer, FlushedEventBuffer>();
        this.newStreamBuffer = new HashMap<Integer, FlushedEventBuffer>();
    }

    @Override
    public void execute() {
        if (!this.hasNewData) {
            return;
        }
        this.hasNewData = false;
        EventBean[][] oldDataPerStream = new EventBean[this.numStreams][];
        EventBean[][] newDataPerStream = new EventBean[this.numStreams][];
        for (int i = 0; i < this.numStreams; ++i) {
            oldDataPerStream[i] = JoinExecStrategyDispatchable.getBufferData(this.oldStreamBuffer.get(i));
            newDataPerStream[i] = JoinExecStrategyDispatchable.getBufferData(this.newStreamBuffer.get(i));
        }
        InstrumentationCommon instrumentationCommon = this.agentInstanceContext.getInstrumentationProvider();
        if (instrumentationCommon.activated()) {
            instrumentationCommon.qJoinDispatch(newDataPerStream, oldDataPerStream);
            this.joinExecutionStrategy.join(newDataPerStream, oldDataPerStream);
            instrumentationCommon.aJoinDispatch();
            return;
        }
        this.joinExecutionStrategy.join(newDataPerStream, oldDataPerStream);
    }

    private static EventBean[] getBufferData(FlushedEventBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        return buffer.getAndFlush();
    }

    @Override
    public void newData(int streamId, FlushedEventBuffer newEventBuffer, FlushedEventBuffer oldEventBuffer) {
        this.hasNewData = true;
        this.newStreamBuffer.put(streamId, newEventBuffer);
        this.oldStreamBuffer.put(streamId, oldEventBuffer);
    }
}

