/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.join.base;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.collection.MultiKeyArrayOfKeys;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.index.base.EventTable;
import com.espertech.esper.common.internal.epl.join.queryplan.TableLookupIndexReqKey;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class JoinSetComposerUtil {
    private static final EventTable[] EMPTY = new EventTable[0];

    public static boolean isNonUnidirectionalNonSelf(boolean isOuterJoins, boolean isUnidirectional, boolean isPureSelfJoin) {
        return !isUnidirectional && (!isPureSelfJoin || isOuterJoins);
    }

    public static void filter(ExprEvaluator filterExprNode, Set<MultiKeyArrayOfKeys<EventBean>> events, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Iterator<MultiKeyArrayOfKeys<EventBean>> it = events.iterator();
        while (it.hasNext()) {
            MultiKeyArrayOfKeys<EventBean> key = it.next();
            EventBean[] eventArr = key.getArray();
            Boolean matched = (Boolean)filterExprNode.evaluate(eventArr, isNewData, exprEvaluatorContext);
            if (matched != null && matched.booleanValue()) continue;
            it.remove();
        }
    }

    public static EventTable[][] toArray(Map<TableLookupIndexReqKey, EventTable>[] repositories) {
        return JoinSetComposerUtil.toArray(repositories, repositories.length);
    }

    public static EventTable[][] toArray(Map<TableLookupIndexReqKey, EventTable>[] repositories, int length) {
        if (repositories == null) {
            return JoinSetComposerUtil.getDefaultTablesArray(length);
        }
        EventTable[][] tables = new EventTable[repositories.length][];
        for (int i = 0; i < repositories.length; ++i) {
            tables[i] = JoinSetComposerUtil.toArray(repositories[i]);
        }
        return tables;
    }

    private static EventTable[] toArray(Map<TableLookupIndexReqKey, EventTable> repository) {
        if (repository == null) {
            return EMPTY;
        }
        EventTable[] tables = new EventTable[repository.size()];
        int count = 0;
        for (Map.Entry<TableLookupIndexReqKey, EventTable> entries : repository.entrySet()) {
            tables[count] = entries.getValue();
            ++count;
        }
        return tables;
    }

    private static EventTable[][] getDefaultTablesArray(int length) {
        EventTable[][] result = new EventTable[length][];
        for (int i = 0; i < result.length; ++i) {
            result[i] = EMPTY;
        }
        return result;
    }
}

