/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.join.exec.sorted;

import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.join.exec.sorted.SortedAccessStrategy;
import com.espertech.esper.common.internal.epl.join.exec.sorted.SortedAccessStrategyGE;
import com.espertech.esper.common.internal.epl.join.exec.sorted.SortedAccessStrategyGT;
import com.espertech.esper.common.internal.epl.join.exec.sorted.SortedAccessStrategyLE;
import com.espertech.esper.common.internal.epl.join.exec.sorted.SortedAccessStrategyLT;
import com.espertech.esper.common.internal.epl.join.exec.sorted.SortedAccessStrategyRange;
import com.espertech.esper.common.internal.epl.join.exec.sorted.SortedAccessStrategyRangeInverted;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphRangeEnum;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphValueEntryRange;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphValueEntryRangeIn;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphValueEntryRangeRelOp;

public class SortedAccessStrategyFactory {
    public static SortedAccessStrategy make(boolean isNWOnTrigger, int lookupStream, int numStreams, QueryGraphValueEntryRange rangeKeyPair) {
        if (rangeKeyPair.getType().isRange()) {
            QueryGraphValueEntryRangeIn rangeIn = (QueryGraphValueEntryRangeIn)rangeKeyPair;
            ExprEvaluator startExpr = rangeIn.getExprStart();
            ExprEvaluator endExpr = rangeIn.getExprEnd();
            boolean includeStart = rangeKeyPair.getType().isIncludeStart();
            boolean includeEnd = rangeKeyPair.getType().isIncludeEnd();
            if (!rangeKeyPair.getType().isRangeInverted()) {
                return new SortedAccessStrategyRange(isNWOnTrigger, lookupStream, numStreams, startExpr, includeStart, endExpr, includeEnd, rangeIn.isAllowRangeReversal());
            }
            return new SortedAccessStrategyRangeInverted(isNWOnTrigger, lookupStream, numStreams, startExpr, includeStart, endExpr, includeEnd);
        }
        QueryGraphValueEntryRangeRelOp relOp = (QueryGraphValueEntryRangeRelOp)rangeKeyPair;
        ExprEvaluator keyExpr = relOp.getExpression();
        if (rangeKeyPair.getType() == QueryGraphRangeEnum.GREATER_OR_EQUAL) {
            return new SortedAccessStrategyGE(isNWOnTrigger, lookupStream, numStreams, keyExpr);
        }
        if (rangeKeyPair.getType() == QueryGraphRangeEnum.GREATER) {
            return new SortedAccessStrategyGT(isNWOnTrigger, lookupStream, numStreams, keyExpr);
        }
        if (rangeKeyPair.getType() == QueryGraphRangeEnum.LESS_OR_EQUAL) {
            return new SortedAccessStrategyLE(isNWOnTrigger, lookupStream, numStreams, keyExpr);
        }
        if (rangeKeyPair.getType() == QueryGraphRangeEnum.LESS) {
            return new SortedAccessStrategyLT(isNWOnTrigger, lookupStream, numStreams, keyExpr);
        }
        throw new IllegalArgumentException("Comparison operator " + (Object)((Object)rangeKeyPair.getType()) + " not supported");
    }
}

