/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.join.queryplan;

import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.util.CodegenMakeable;
import com.espertech.esper.common.internal.bytecodemodel.util.CodegenMakeableUtil;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeSymbol;
import com.espertech.esper.common.internal.epl.join.assemble.BaseAssemblyNodeFactory;
import com.espertech.esper.common.internal.epl.join.queryplan.LookupInstructionQueryPlanNode;
import com.espertech.esper.common.internal.epl.join.queryplan.QueryPlanNodeForge;
import com.espertech.esper.common.internal.epl.join.queryplan.TableLookupIndexReqKey;
import com.espertech.esper.common.internal.epl.join.queryplanbuild.QueryPlanNodeForgeVisitor;
import com.espertech.esper.common.internal.epl.join.queryplanouter.LookupInstructionPlan;
import com.espertech.esper.common.internal.epl.join.queryplanouter.LookupInstructionPlanForge;
import com.espertech.esper.common.internal.util.IndentWriter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class LookupInstructionQueryPlanNodeForge
extends QueryPlanNodeForge {
    private final int rootStream;
    private final String rootStreamName;
    private final int numStreams;
    private final List<LookupInstructionPlanForge> lookupInstructions;
    private final boolean[] requiredPerStream;
    private final List<BaseAssemblyNodeFactory> assemblyInstructionFactories;

    public LookupInstructionQueryPlanNodeForge(int rootStream, String rootStreamName, int numStreams, boolean[] requiredPerStream, List<LookupInstructionPlanForge> lookupInstructions, List<BaseAssemblyNodeFactory> assemblyInstructionFactories) {
        this.rootStream = rootStream;
        this.rootStreamName = rootStreamName;
        this.lookupInstructions = lookupInstructions;
        this.numStreams = numStreams;
        this.requiredPerStream = requiredPerStream;
        this.assemblyInstructionFactories = assemblyInstructionFactories;
    }

    @Override
    public void addIndexes(HashSet<TableLookupIndexReqKey> usedIndexes) {
        for (LookupInstructionPlanForge plan : this.lookupInstructions) {
            plan.addIndexes(usedIndexes);
        }
    }

    @Override
    public CodegenExpression make(CodegenMethodScope parent, SAIFFInitializeSymbol symbols, CodegenClassScope classScope) {
        CodegenMethod method = this.makeInstructions(this.assemblyInstructionFactories, parent, symbols, classScope);
        return CodegenExpressionBuilder.newInstance(LookupInstructionQueryPlanNode.class, CodegenExpressionBuilder.constant(this.rootStream), CodegenExpressionBuilder.constant(this.rootStreamName), CodegenExpressionBuilder.constant(this.numStreams), CodegenExpressionBuilder.constant(this.requiredPerStream), CodegenMakeableUtil.makeArray((String)"lookupInstructions", LookupInstructionPlan.class, (CodegenMakeable[])this.lookupInstructions.toArray(new LookupInstructionPlanForge[0]), this.getClass(), (CodegenMethodScope)parent, (SAIFFInitializeSymbol)symbols, (CodegenClassScope)classScope), CodegenExpressionBuilder.localMethod(method, new CodegenExpression[0]));
    }

    public static void assembleFactoriesIntoTree(BaseAssemblyNodeFactory[] factories, int[] parents, int[][] children) {
        int i;
        for (i = 0; i < parents.length; ++i) {
            if (parents[i] == -1) continue;
            factories[i].setParent(factories[parents[i]]);
        }
        for (i = 0; i < children.length; ++i) {
            for (int child = 0; child < children[i].length; ++child) {
                factories[i].addChild(factories[children[i][child]]);
            }
        }
    }

    private CodegenMethod makeInstructions(List<BaseAssemblyNodeFactory> factories, CodegenMethodScope parent, SAIFFInitializeSymbol symbols, CodegenClassScope classScope) {
        CodegenMethod method = parent.makeChild(BaseAssemblyNodeFactory[].class, this.getClass(), (CodegenScope)classScope);
        int[] parents = new int[factories.size()];
        int[][] children = new int[factories.size()][];
        for (int i = 0; i < factories.size(); ++i) {
            BaseAssemblyNodeFactory factory = factories.get(i);
            parents[i] = factory.getParentNode() == null ? -1 : this.findFactoryChecked(factory.getParentNode(), factories);
            children[i] = new int[factory.getChildNodes().size()];
            for (int child = 0; child < factory.getChildNodes().size(); ++child) {
                children[i][child] = this.findFactoryChecked(factory.getChildNodes().get(child), factories);
            }
        }
        method.getBlock().declareVar(BaseAssemblyNodeFactory[].class, "factories", CodegenMakeableUtil.makeArray((String)"assemblyInstructions", BaseAssemblyNodeFactory.class, (CodegenMakeable[])factories.toArray(new BaseAssemblyNodeFactory[0]), this.getClass(), (CodegenMethodScope)parent, (SAIFFInitializeSymbol)symbols, (CodegenClassScope)classScope)).staticMethod(LookupInstructionQueryPlanNodeForge.class, "assembleFactoriesIntoTree", CodegenExpressionBuilder.ref("factories"), CodegenExpressionBuilder.constant(parents), CodegenExpressionBuilder.constant(children)).methodReturn(CodegenExpressionBuilder.ref("factories"));
        return method;
    }

    @Override
    protected void print(IndentWriter writer) {
        int i;
        writer.println("LookupInstructionQueryPlanNode rootStream=" + this.rootStream + " requiredPerStream=" + Arrays.toString(this.requiredPerStream));
        writer.incrIndent();
        for (i = 0; i < this.lookupInstructions.size(); ++i) {
            writer.println("lookup step " + i);
            writer.incrIndent();
            this.lookupInstructions.get(i).print(writer);
            writer.decrIndent();
        }
        writer.decrIndent();
        writer.incrIndent();
        for (i = 0; i < this.assemblyInstructionFactories.size(); ++i) {
            writer.println("assembly step " + i);
            writer.incrIndent();
            this.assemblyInstructionFactories.get(i).print(writer);
            writer.decrIndent();
        }
        writer.decrIndent();
    }

    public int getRootStream() {
        return this.rootStream;
    }

    public String getRootStreamName() {
        return this.rootStreamName;
    }

    public int getNumStreams() {
        return this.numStreams;
    }

    public List<LookupInstructionPlanForge> getLookupInstructions() {
        return this.lookupInstructions;
    }

    public boolean[] getRequiredPerStream() {
        return this.requiredPerStream;
    }

    public List<BaseAssemblyNodeFactory> getAssemblyInstructionFactories() {
        return this.assemblyInstructionFactories;
    }

    @Override
    public void accept(QueryPlanNodeForgeVisitor visitor) {
        visitor.visit(this);
    }

    private int findFactoryChecked(BaseAssemblyNodeFactory node, List<BaseAssemblyNodeFactory> factories) {
        int index = factories.indexOf(node);
        if (index == -1) {
            throw new UnsupportedOperationException("Assembly factory not found among list");
        }
        return index;
    }
}

