/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.join.queryplan;

import com.espertech.esper.common.client.EventPropertyValueGetter;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.util.CodegenMakeable;
import com.espertech.esper.common.internal.compile.multikey.MultiKeyClassRef;
import com.espertech.esper.common.internal.compile.multikey.MultiKeyCodegen;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeSymbol;
import com.espertech.esper.common.internal.epl.index.advanced.index.service.EventAdvancedIndexProvisionCompileTime;
import com.espertech.esper.common.internal.epl.join.lookup.IndexedPropDesc;
import com.espertech.esper.common.internal.epl.join.queryplan.QueryPlanIndexItem;
import com.espertech.esper.common.internal.event.core.EventPropertyGetterSPI;
import com.espertech.esper.common.internal.event.core.EventTypeSPI;
import com.espertech.esper.common.internal.event.core.EventTypeUtility;
import com.espertech.esper.common.internal.serde.compiletime.resolve.DataInputOutputSerdeForge;
import com.espertech.esper.common.internal.util.CollectionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class QueryPlanIndexItemForge
implements CodegenMakeable<SAIFFInitializeSymbol> {
    private final String[] hashProps;
    private Class[] hashTypes;
    private MultiKeyClassRef hashMultiKeyClasses;
    private final String[] rangeProps;
    private final Class[] rangeTypes;
    private DataInputOutputSerdeForge[] rangeSerdes;
    private final boolean unique;
    private final EventAdvancedIndexProvisionCompileTime advancedIndexProvisionDesc;
    private final EventType eventType;

    public QueryPlanIndexItemForge(String[] hashProps, Class[] hashTypes, String[] rangeProps, Class[] rangeTypes, boolean unique, EventAdvancedIndexProvisionCompileTime advancedIndexProvisionDesc, EventType eventType) {
        if (advancedIndexProvisionDesc == null) {
            if (unique && hashProps.length == 0) {
                throw new IllegalArgumentException("Invalid unique index planned without hash index props");
            }
            if (unique && rangeProps.length > 0) {
                throw new IllegalArgumentException("Invalid unique index planned that includes range props");
            }
        }
        if (hashProps == null || hashTypes == null || rangeProps == null || rangeTypes == null) {
            throw new IllegalArgumentException("Invalid null hash and range props");
        }
        if (hashProps.length != hashTypes.length) {
            throw new IllegalArgumentException("Mismatch size hash props and types");
        }
        if (rangeProps.length != rangeTypes.length) {
            throw new IllegalArgumentException("Mismatch size hash props and types");
        }
        this.hashProps = hashProps;
        this.hashTypes = hashTypes;
        this.rangeProps = rangeProps;
        this.rangeTypes = rangeTypes;
        this.unique = unique;
        this.advancedIndexProvisionDesc = advancedIndexProvisionDesc;
        this.eventType = eventType;
    }

    public QueryPlanIndexItemForge(List<IndexedPropDesc> hashProps, List<IndexedPropDesc> btreeProps, boolean unique, EventAdvancedIndexProvisionCompileTime advancedIndexProvisionDesc, EventType eventType) {
        this(QueryPlanIndexItemForge.getNames(hashProps), QueryPlanIndexItemForge.getTypes(hashProps), QueryPlanIndexItemForge.getNames(btreeProps), QueryPlanIndexItemForge.getTypes(btreeProps), unique, advancedIndexProvisionDesc, eventType);
    }

    public String[] getHashProps() {
        return this.hashProps;
    }

    public Class[] getHashTypes() {
        return this.hashTypes;
    }

    public String[] getRangeProps() {
        return this.rangeProps;
    }

    public Class[] getRangeTypes() {
        return this.rangeTypes;
    }

    public void setHashTypes(Class[] hashTypes) {
        this.hashTypes = hashTypes;
    }

    public void setHashMultiKeyClasses(MultiKeyClassRef hashMultiKeyClasses) {
        this.hashMultiKeyClasses = hashMultiKeyClasses;
    }

    public void setRangeSerdes(DataInputOutputSerdeForge[] rangeSerdes) {
        this.rangeSerdes = rangeSerdes;
    }

    public MultiKeyClassRef getHashMultiKeyClasses() {
        return this.hashMultiKeyClasses;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public EventAdvancedIndexProvisionCompileTime getAdvancedIndexProvisionDesc() {
        return this.advancedIndexProvisionDesc;
    }

    public String toString() {
        return "QueryPlanIndexItem{unique=" + this.unique + ", hashProps=" + Arrays.asList(this.hashProps) + ", rangeProps=" + Arrays.asList(this.rangeProps) + ", hashTypes=" + Arrays.asList(this.hashTypes) + ", rangeTypes=" + Arrays.asList(this.rangeTypes) + ", advanced=" + (this.advancedIndexProvisionDesc == null ? null : this.advancedIndexProvisionDesc.getIndexDesc().getIndexTypeName()) + "}";
    }

    public boolean equalsCompareSortedProps(QueryPlanIndexItemForge other) {
        if (this.unique != other.unique) {
            return false;
        }
        String[] otherIndexProps = CollectionUtil.copySortArray(other.getHashProps());
        String[] thisIndexProps = CollectionUtil.copySortArray(this.getHashProps());
        String[] otherRangeProps = CollectionUtil.copySortArray(other.getRangeProps());
        String[] thisRangeProps = CollectionUtil.copySortArray(this.getRangeProps());
        boolean compared = CollectionUtil.compare(otherIndexProps, thisIndexProps) && CollectionUtil.compare(otherRangeProps, thisRangeProps);
        return compared && this.advancedIndexProvisionDesc == null && other.advancedIndexProvisionDesc == null;
    }

    public List<IndexedPropDesc> getHashPropsAsList() {
        return this.asList(this.hashProps, this.hashTypes);
    }

    public List<IndexedPropDesc> getBtreePropsAsList() {
        return this.asList(this.rangeProps, this.rangeTypes);
    }

    private List<IndexedPropDesc> asList(String[] props, Class[] types) {
        if (props == null || props.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<IndexedPropDesc> list = new ArrayList<IndexedPropDesc>(props.length);
        for (int i = 0; i < props.length; ++i) {
            list.add(new IndexedPropDesc(props[i], types[i]));
        }
        return list;
    }

    @Override
    public CodegenExpression make(CodegenMethodScope parent, SAIFFInitializeSymbol symbols, CodegenClassScope classScope) {
        return this.make(parent, classScope);
    }

    public CodegenExpression make(CodegenMethodScope parent, CodegenClassScope classScope) {
        CodegenExpression rangeGetters;
        CodegenMethod method = parent.makeChild(QueryPlanIndexItem.class, this.getClass(), (CodegenScope)classScope);
        EventPropertyGetterSPI[] propertyGetters = EventTypeUtility.getGetters(this.eventType, this.hashProps);
        Class[] propertyTypes = EventTypeUtility.getPropertyTypes(this.eventType, this.hashProps);
        CodegenExpression valueGetter = MultiKeyCodegen.codegenGetterMayMultiKey(this.eventType, propertyGetters, propertyTypes, this.hashTypes, this.hashMultiKeyClasses, method, classScope);
        if (this.rangeProps.length == 0) {
            rangeGetters = CodegenExpressionBuilder.newArrayByLength(EventPropertyValueGetter.class, CodegenExpressionBuilder.constant(0));
        } else {
            CodegenMethod makeMethod = parent.makeChild(EventPropertyValueGetter[].class, this.getClass(), (CodegenScope)classScope);
            makeMethod.getBlock().declareVar(EventPropertyValueGetter[].class, "getters", CodegenExpressionBuilder.newArrayByLength(EventPropertyValueGetter.class, CodegenExpressionBuilder.constant(this.rangeProps.length)));
            for (int i = 0; i < this.rangeProps.length; ++i) {
                EventPropertyGetterSPI getter = ((EventTypeSPI)this.eventType).getGetterSPI(this.rangeProps[i]);
                Class getterType = this.eventType.getPropertyType(this.rangeProps[i]);
                Class coercionType = this.rangeTypes == null ? null : this.rangeTypes[i];
                CodegenExpression eval = EventTypeUtility.codegenGetterWCoerce(getter, getterType, coercionType, method, this.getClass(), classScope);
                makeMethod.getBlock().assignArrayElement(CodegenExpressionBuilder.ref("getters"), CodegenExpressionBuilder.constant(i), eval);
            }
            makeMethod.getBlock().methodReturn(CodegenExpressionBuilder.ref("getters"));
            rangeGetters = CodegenExpressionBuilder.localMethod(makeMethod, new CodegenExpression[0]);
        }
        CodegenExpression multiKeyTransform = MultiKeyCodegen.codegenMultiKeyFromArrayTransform(this.hashMultiKeyClasses, method, classScope);
        method.getBlock().methodReturn(CodegenExpressionBuilder.newInstance(QueryPlanIndexItem.class, CodegenExpressionBuilder.constant(this.hashProps), CodegenExpressionBuilder.constant(this.hashTypes), valueGetter, multiKeyTransform, this.hashMultiKeyClasses == null ? CodegenExpressionBuilder.constantNull() : this.hashMultiKeyClasses.getExprMKSerde(method, classScope), CodegenExpressionBuilder.constant(this.rangeProps), CodegenExpressionBuilder.constant(this.rangeTypes), rangeGetters, DataInputOutputSerdeForge.codegenArray(this.rangeSerdes, method, classScope, null), CodegenExpressionBuilder.constant(this.unique), this.advancedIndexProvisionDesc == null ? CodegenExpressionBuilder.constantNull() : this.advancedIndexProvisionDesc.codegenMake(method, classScope)));
        return CodegenExpressionBuilder.localMethod(method, new CodegenExpression[0]);
    }

    private static String[] getNames(List<IndexedPropDesc> props) {
        String[] names = new String[props.size()];
        for (int i = 0; i < props.size(); ++i) {
            names[i] = props.get(i).getIndexPropName();
        }
        return names;
    }

    private static Class[] getTypes(List<IndexedPropDesc> props) {
        Class[] types = new Class[props.size()];
        for (int i = 0; i < props.size(); ++i) {
            types[i] = props.get(i).getCoercionType();
        }
        return types;
    }

    public QueryPlanIndexItem toRuntime() {
        if (this.advancedIndexProvisionDesc == null) {
            return null;
        }
        return new QueryPlanIndexItem(this.hashProps, this.hashTypes, null, null, null, this.rangeProps, this.rangeTypes, null, null, this.unique, this.advancedIndexProvisionDesc.toRuntime());
    }
}

