/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.join.queryplan;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.epl.index.base.EventTable;
import com.espertech.esper.common.internal.epl.join.exec.base.JoinExecTableLookupStrategy;
import com.espertech.esper.common.internal.epl.join.exec.base.TableLookupExecNode;
import com.espertech.esper.common.internal.epl.join.exec.base.TableLookupExecNodeTableLocking;
import com.espertech.esper.common.internal.epl.join.queryplan.QueryPlanNode;
import com.espertech.esper.common.internal.epl.join.queryplan.TableLookupIndexReqKey;
import com.espertech.esper.common.internal.epl.join.queryplan.TableLookupPlan;
import com.espertech.esper.common.internal.epl.join.strategy.ExecNode;
import com.espertech.esper.common.internal.epl.virtualdw.VirtualDWView;
import com.espertech.esper.common.internal.util.IndentWriter;
import com.espertech.esper.common.internal.view.core.Viewable;
import java.util.Map;
import java.util.concurrent.locks.Lock;

public class TableLookupNode
extends QueryPlanNode {
    private TableLookupPlan tableLookupPlan;

    public TableLookupNode(TableLookupPlan tableLookupPlan) {
        this.tableLookupPlan = tableLookupPlan;
    }

    public TableLookupPlan getTableLookupPlan() {
        return this.tableLookupPlan;
    }

    @Override
    public ExecNode makeExec(AgentInstanceContext agentInstanceContext, Map<TableLookupIndexReqKey, EventTable>[] indexesPerStream, EventType[] streamTypes, Viewable[] streamViews, VirtualDWView[] viewExternal, Lock[] tableSecondaryIndexLocks) {
        JoinExecTableLookupStrategy lookupStrategy = this.tableLookupPlan.makeStrategy(agentInstanceContext, indexesPerStream, streamTypes, viewExternal);
        int indexedStream = this.tableLookupPlan.getIndexedStream();
        if (tableSecondaryIndexLocks[indexedStream] != null) {
            return new TableLookupExecNodeTableLocking(indexedStream, lookupStrategy, tableSecondaryIndexLocks[indexedStream]);
        }
        return new TableLookupExecNode(indexedStream, lookupStrategy);
    }

    protected TableLookupPlan getLookupStrategySpec() {
        return this.tableLookupPlan;
    }

    public void print(IndentWriter writer) {
        writer.println("TableLookupNode  tableLookupPlan=" + this.tableLookupPlan);
    }
}

