/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.join.queryplanbuild;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.compile.stage1.spec.OuterJoinDesc;
import com.espertech.esper.common.internal.compile.stage2.StatementRawInfo;
import com.espertech.esper.common.internal.compile.stage3.StatementCompileTimeServices;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeableFactory;
import com.espertech.esper.common.internal.context.aifactory.select.StreamJoinAnalysisResultCompileTime;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.historical.common.HistoricalStreamIndexListForge;
import com.espertech.esper.common.internal.epl.historical.common.HistoricalViewableDesc;
import com.espertech.esper.common.internal.epl.join.assemble.AssemblyStrategyTreeBuilder;
import com.espertech.esper.common.internal.epl.join.assemble.BaseAssemblyNodeFactory;
import com.espertech.esper.common.internal.epl.join.base.JoinSetComposerPrototypeHistoricalDesc;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphForge;
import com.espertech.esper.common.internal.epl.join.queryplan.HistoricalDataPlanNodeForge;
import com.espertech.esper.common.internal.epl.join.queryplan.LookupInstructionQueryPlanNodeForge;
import com.espertech.esper.common.internal.epl.join.queryplan.QueryPlanForge;
import com.espertech.esper.common.internal.epl.join.queryplan.QueryPlanForgeDesc;
import com.espertech.esper.common.internal.epl.join.queryplan.QueryPlanIndexForge;
import com.espertech.esper.common.internal.epl.join.queryplan.QueryPlanNodeForge;
import com.espertech.esper.common.internal.epl.join.queryplan.QueryPlanNodeForgeDesc;
import com.espertech.esper.common.internal.epl.join.queryplan.QueryPlanNodeNoOpForge;
import com.espertech.esper.common.internal.epl.join.queryplan.TableLookupPlanDesc;
import com.espertech.esper.common.internal.epl.join.queryplan.TableLookupPlanForge;
import com.espertech.esper.common.internal.epl.join.queryplanbuild.LookupInstructionPlanDesc;
import com.espertech.esper.common.internal.epl.join.queryplanbuild.NStreamQueryPlanBuilder;
import com.espertech.esper.common.internal.epl.join.queryplanbuild.QueryPlanIndexBuilder;
import com.espertech.esper.common.internal.epl.join.queryplanouter.InnerJoinGraph;
import com.espertech.esper.common.internal.epl.join.queryplanouter.LookupInstructionPlanForge;
import com.espertech.esper.common.internal.epl.join.queryplanouter.OuterInnerDirectionalGraph;
import com.espertech.esper.common.internal.epl.table.compiletime.TableMetaData;
import com.espertech.esper.common.internal.serde.compiletime.resolve.SerdeCompileTimeResolverNonHA;
import com.espertech.esper.common.internal.type.OuterJoinType;
import com.espertech.esper.common.internal.util.CollectionUtil;
import com.espertech.esper.common.internal.util.DependencyGraph;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NStreamOuterQueryPlanBuilder {
    private static final Logger log = LoggerFactory.getLogger(NStreamOuterQueryPlanBuilder.class);

    protected static QueryPlanForgeDesc build(QueryGraphForge queryGraph, OuterJoinDesc[] outerJoinDescList, String[] streamNames, EventType[] typesPerStream, HistoricalViewableDesc historicalViewableDesc, DependencyGraph dependencyGraph, HistoricalStreamIndexListForge[] historicalStreamIndexLists, String[][][] indexedStreamsUniqueProps, TableMetaData[] tablesPerStream, StreamJoinAnalysisResultCompileTime streamJoinAnalysisResult, StatementRawInfo statementRawInfo, StatementCompileTimeServices services) throws ExprValidationException {
        InnerJoinGraph innerJoinGraph;
        OuterInnerDirectionalGraph outerInnerGraph;
        if (log.isDebugEnabled()) {
            log.debug(".build filterQueryGraph=" + queryGraph);
        }
        int numStreams = queryGraph.getNumStreams();
        QueryPlanNodeForge[] planNodeSpecs = new QueryPlanNodeForge[numStreams];
        ArrayList<StmtClassForgeableFactory> additionalForgeables = new ArrayList<StmtClassForgeableFactory>();
        QueryPlanIndexForge[] indexSpecs = QueryPlanIndexBuilder.buildIndexSpec(queryGraph, typesPerStream, indexedStreamsUniqueProps);
        if (historicalViewableDesc.isHasHistorical()) {
            for (int i = 0; i < historicalViewableDesc.getHistorical().length; ++i) {
                if (!historicalViewableDesc.getHistorical()[i]) continue;
                indexSpecs[i] = null;
            }
        }
        if (outerJoinDescList.length > 0) {
            outerInnerGraph = NStreamOuterQueryPlanBuilder.graphOuterJoins(numStreams, outerJoinDescList);
            innerJoinGraph = InnerJoinGraph.graphInnerJoins(numStreams, outerJoinDescList);
        } else {
            outerInnerGraph = new OuterInnerDirectionalGraph(numStreams);
            innerJoinGraph = new InnerJoinGraph(numStreams, true);
        }
        if (log.isDebugEnabled()) {
            log.debug(".build directional graph=" + outerInnerGraph.print());
        }
        for (int streamNo = 0; streamNo < numStreams; ++streamNo) {
            if (historicalViewableDesc.getHistorical()[streamNo] && dependencyGraph.hasDependency(streamNo)) {
                planNodeSpecs[streamNo] = new QueryPlanNodeNoOpForge();
                continue;
            }
            QueryPlanNodeForgeDesc desc = NStreamOuterQueryPlanBuilder.buildPlanNode(numStreams, streamNo, streamNames, queryGraph, outerInnerGraph, outerJoinDescList, innerJoinGraph, indexSpecs, typesPerStream, historicalViewableDesc.getHistorical(), dependencyGraph, historicalStreamIndexLists, tablesPerStream, streamJoinAnalysisResult, statementRawInfo, services);
            QueryPlanNodeForge queryPlanNode = desc.getForge();
            additionalForgeables.addAll(desc.getAdditionalForgeables());
            if (log.isDebugEnabled()) {
                log.debug(".build spec for stream '" + streamNames[streamNo] + "' number " + streamNo + " is " + queryPlanNode);
            }
            planNodeSpecs[streamNo] = queryPlanNode;
        }
        QueryPlanForge queryPlan = new QueryPlanForge(indexSpecs, planNodeSpecs);
        if (log.isDebugEnabled()) {
            log.debug(".build query plan=" + queryPlan.toString());
        }
        return new QueryPlanForgeDesc(queryPlan, additionalForgeables);
    }

    private static QueryPlanNodeForgeDesc buildPlanNode(int numStreams, int streamNo, String[] streamNames, QueryGraphForge queryGraph, OuterInnerDirectionalGraph outerInnerGraph, OuterJoinDesc[] outerJoinDescList, InnerJoinGraph innerJoinGraph, QueryPlanIndexForge[] indexSpecs, EventType[] typesPerStream, boolean[] isHistorical, DependencyGraph dependencyGraph, HistoricalStreamIndexListForge[] historicalStreamIndexLists, TableMetaData[] tablesPerStream, StreamJoinAnalysisResultCompileTime streamJoinAnalysisResult, StatementRawInfo statementRawInfo, StatementCompileTimeServices services) throws ExprValidationException {
        LinkedHashMap<Integer, int[]> substreamsPerStream = new LinkedHashMap<Integer, int[]>();
        boolean[] requiredPerStream = new boolean[numStreams];
        ArrayList<StmtClassForgeableFactory> additionalForgeables = new ArrayList<StmtClassForgeableFactory>(2);
        HashSet<Integer> completedStreams = new HashSet<Integer>();
        Stack<Integer> streamCallStack = new Stack<Integer>();
        streamCallStack.push(streamNo);
        if (innerJoinGraph.isAllInnerJoin()) {
            Arrays.fill(requiredPerStream, true);
            NStreamOuterQueryPlanBuilder.recursiveBuildInnerJoin(streamNo, streamCallStack, queryGraph, completedStreams, substreamsPerStream, dependencyGraph);
            NStreamQueryPlanBuilder.BestChainResult bestChain = NStreamQueryPlanBuilder.computeBestPath(streamNo, queryGraph, dependencyGraph);
            NStreamOuterQueryPlanBuilder.addNotYetNavigated(streamNo, numStreams, substreamsPerStream, bestChain);
        } else {
            NStreamOuterQueryPlanBuilder.recursiveBuild(streamNo, streamCallStack, queryGraph, outerInnerGraph, innerJoinGraph, completedStreams, substreamsPerStream, requiredPerStream, dependencyGraph);
        }
        NStreamOuterQueryPlanBuilder.verifyJoinedPerStream(streamNo, substreamsPerStream);
        LookupInstructionPlanDesc lookupDesc = NStreamOuterQueryPlanBuilder.buildLookupInstructions(streamNo, substreamsPerStream, requiredPerStream, streamNames, queryGraph, indexSpecs, typesPerStream, outerJoinDescList, isHistorical, historicalStreamIndexLists, tablesPerStream, streamJoinAnalysisResult, statementRawInfo, services);
        List<LookupInstructionPlanForge> lookupInstructions = lookupDesc.getForges();
        additionalForgeables.addAll(lookupDesc.getAdditionalForgeables());
        for (LookupInstructionPlanForge lookups : lookupInstructions) {
            for (HistoricalDataPlanNodeForge historical : lookups.getHistoricalPlans()) {
                if (historical == null) continue;
                JoinSetComposerPrototypeHistoricalDesc desc = historicalStreamIndexLists[historical.getStreamNum()].getStrategy(historical.getLookupStreamNum(), statementRawInfo, services.getSerdeResolver());
                historical.setHistoricalIndexLookupStrategy(desc.getLookupForge());
                historical.setPollResultIndexingStrategy(desc.getIndexingForge());
                additionalForgeables.addAll(desc.getAdditionalForgeables());
            }
        }
        BaseAssemblyNodeFactory assemblyTopNodeFactory = AssemblyStrategyTreeBuilder.build(streamNo, substreamsPerStream, requiredPerStream);
        List<BaseAssemblyNodeFactory> assemblyInstructionFactories = BaseAssemblyNodeFactory.getDescendentNodesBottomUp(assemblyTopNodeFactory);
        LookupInstructionQueryPlanNodeForge forge = new LookupInstructionQueryPlanNodeForge(streamNo, streamNames[streamNo], numStreams, requiredPerStream, lookupInstructions, assemblyInstructionFactories);
        return new QueryPlanNodeForgeDesc(forge, additionalForgeables);
    }

    private static void addNotYetNavigated(int streamNo, int numStreams, LinkedHashMap<Integer, int[]> substreamsPerStream, NStreamQueryPlanBuilder.BestChainResult bestChain) {
        HashSet<Integer> streams = new HashSet<Integer>();
        streams.add(streamNo);
        NStreamOuterQueryPlanBuilder.recursiveAdd(streamNo, streamNo, substreamsPerStream, streams, false);
        if (streams.size() == numStreams) {
            return;
        }
        int previous = streamNo;
        for (int stream : bestChain.getChain()) {
            if (streams.contains(stream)) {
                previous = stream;
                continue;
            }
            int[] substreams = substreamsPerStream.get(previous);
            if (substreams == null) {
                substreams = new int[]{};
            }
            int[] added = CollectionUtil.addValue(substreams, stream);
            substreamsPerStream.put(previous, added);
            if (!substreamsPerStream.containsKey(stream)) {
                substreamsPerStream.put(stream, new int[0]);
            }
            previous = stream;
        }
    }

    private static LookupInstructionPlanDesc buildLookupInstructions(int rootStreamNum, LinkedHashMap<Integer, int[]> substreamsPerStream, boolean[] requiredPerStream, String[] streamNames, QueryGraphForge queryGraph, QueryPlanIndexForge[] indexSpecs, EventType[] typesPerStream, OuterJoinDesc[] outerJoinDescList, boolean[] isHistorical, HistoricalStreamIndexListForge[] historicalStreamIndexLists, TableMetaData[] tablesPerStream, StreamJoinAnalysisResultCompileTime streamJoinAnalysisResult, StatementRawInfo statementRawInfo, StatementCompileTimeServices services) {
        LinkedList<LookupInstructionPlanForge> result = new LinkedList<LookupInstructionPlanForge>();
        ArrayList<StmtClassForgeableFactory> additionalForgeables = new ArrayList<StmtClassForgeableFactory>(2);
        for (int fromStream : substreamsPerStream.keySet()) {
            int[] substreams = substreamsPerStream.get(fromStream);
            if (substreams.length == 0) continue;
            TableLookupPlanForge[] plans = new TableLookupPlanForge[substreams.length];
            HistoricalDataPlanNodeForge[] historicalPlans = new HistoricalDataPlanNodeForge[substreams.length];
            for (int i = 0; i < substreams.length; ++i) {
                int toStream = substreams[i];
                if (isHistorical[toStream]) {
                    ExprNode outerJoinExpr = null;
                    if (outerJoinDescList.length > 0) {
                        OuterJoinDesc outerJoinDesc = toStream == 0 ? outerJoinDescList[0] : outerJoinDescList[toStream - 1];
                        outerJoinExpr = outerJoinDesc.makeExprNode(statementRawInfo, services);
                    }
                    if (historicalStreamIndexLists[toStream] == null) {
                        historicalStreamIndexLists[toStream] = new HistoricalStreamIndexListForge(toStream, typesPerStream, queryGraph);
                    }
                    historicalStreamIndexLists[toStream].addIndex(fromStream);
                    historicalPlans[i] = new HistoricalDataPlanNodeForge(toStream, rootStreamNum, fromStream, typesPerStream.length, outerJoinExpr == null ? null : outerJoinExpr.getForge());
                    continue;
                }
                TableLookupPlanDesc planDesc = NStreamQueryPlanBuilder.createLookupPlan(queryGraph, fromStream, toStream, streamJoinAnalysisResult.isVirtualDW(toStream), indexSpecs[toStream], typesPerStream, tablesPerStream[toStream], statementRawInfo, SerdeCompileTimeResolverNonHA.INSTANCE);
                plans[i] = planDesc.getForge();
                additionalForgeables.addAll(planDesc.getAdditionalForgeables());
            }
            String fromStreamName = streamNames[fromStream];
            LookupInstructionPlanForge instruction = new LookupInstructionPlanForge(fromStream, fromStreamName, substreams, plans, historicalPlans, requiredPerStream);
            result.add(instruction);
        }
        return new LookupInstructionPlanDesc(result, additionalForgeables);
    }

    protected static void recursiveBuild(int streamNum, Stack<Integer> streamCallStack, QueryGraphForge queryGraph, OuterInnerDirectionalGraph outerInnerGraph, InnerJoinGraph innerJoinGraph, Set<Integer> completedStreams, LinkedHashMap<Integer, int[]> substreamsPerStream, boolean[] requiredPerStream, DependencyGraph dependencyGraph) throws ExprValidationException {
        completedStreams.add(streamNum);
        if (dependencyGraph.hasDependency(streamNum)) {
            Set<Integer> dependencies = dependencyGraph.getDependenciesForStream(streamNum);
            for (Integer dependentStream : dependencies) {
                if (streamCallStack.contains(dependentStream)) continue;
                throw new ExprValidationException("Historical stream " + streamNum + " parameter dependency originating in stream " + dependentStream + " cannot or may not be satisfied by the join");
            }
        }
        Set<Integer> navigableStreams = queryGraph.getNavigableStreams(streamNum);
        Set<Integer> unqualifiedNavigable = outerInnerGraph.getUnqualifiedNavigableStreams().get(streamNum);
        if (unqualifiedNavigable != null) {
            navigableStreams.addAll(unqualifiedNavigable);
        }
        navigableStreams.removeAll(completedStreams);
        Set<Integer> requiredStreams = NStreamOuterQueryPlanBuilder.getOuterStreams(streamNum, navigableStreams, outerInnerGraph);
        innerJoinGraph.addRequiredStreams(streamNum, requiredStreams, completedStreams);
        Set<Integer> optionalStreams = NStreamOuterQueryPlanBuilder.getInnerStreams(streamNum, navigableStreams, outerInnerGraph, innerJoinGraph, completedStreams);
        requiredStreams.removeAll(optionalStreams);
        if (navigableStreams.isEmpty()) {
            substreamsPerStream.put(streamNum, new int[0]);
            return;
        }
        int[] substreams = new int[requiredStreams.size() + optionalStreams.size()];
        substreamsPerStream.put(streamNum, substreams);
        int count = 0;
        for (int stream : requiredStreams) {
            substreams[count++] = stream;
            requiredPerStream[stream] = true;
        }
        for (int stream : optionalStreams) {
            substreams[count++] = stream;
        }
        for (int stream : requiredStreams) {
            completedStreams.add(stream);
        }
        for (int stream : requiredStreams) {
            streamCallStack.push(stream);
            NStreamOuterQueryPlanBuilder.recursiveBuild(stream, streamCallStack, queryGraph, outerInnerGraph, innerJoinGraph, completedStreams, substreamsPerStream, requiredPerStream, dependencyGraph);
            streamCallStack.pop();
        }
        for (int stream : optionalStreams) {
            streamCallStack.push(stream);
            NStreamOuterQueryPlanBuilder.recursiveBuild(stream, streamCallStack, queryGraph, outerInnerGraph, innerJoinGraph, completedStreams, substreamsPerStream, requiredPerStream, dependencyGraph);
            streamCallStack.pop();
        }
    }

    protected static void recursiveBuildInnerJoin(int streamNum, Stack<Integer> streamCallStack, QueryGraphForge queryGraph, Set<Integer> completedStreams, LinkedHashMap<Integer, int[]> substreamsPerStream, DependencyGraph dependencyGraph) throws ExprValidationException {
        Integer[] navigableStreamArr;
        completedStreams.add(streamNum);
        if (dependencyGraph.hasDependency(streamNum)) {
            Set<Integer> dependencies = dependencyGraph.getDependenciesForStream(streamNum);
            for (Integer n : dependencies) {
                if (streamCallStack.contains(n)) continue;
                throw new ExprValidationException("Historical stream " + streamNum + " parameter dependency originating in stream " + n + " cannot or may not be satisfied by the join");
            }
        }
        Set<Integer> navigableStreams = queryGraph.getNavigableStreams(streamNum);
        Integer[] integerArray = navigableStreamArr = navigableStreams.toArray(new Integer[navigableStreams.size()]);
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int navigableStream = integerArray[i];
            if (!dependencyGraph.hasUnsatisfiedDependency(navigableStream, completedStreams)) continue;
            navigableStreams.remove(navigableStream);
        }
        navigableStreams.removeAll(completedStreams);
        if (navigableStreams.isEmpty()) {
            substreamsPerStream.put(streamNum, new int[0]);
            return;
        }
        int[] nArray = new int[navigableStreams.size()];
        substreamsPerStream.put(streamNum, nArray);
        int count = 0;
        for (int stream : navigableStreams) {
            nArray[count++] = stream;
            completedStreams.add(stream);
        }
        for (int stream : navigableStreams) {
            streamCallStack.push(stream);
            NStreamOuterQueryPlanBuilder.recursiveBuildInnerJoin(stream, streamCallStack, queryGraph, completedStreams, substreamsPerStream, dependencyGraph);
            streamCallStack.pop();
        }
    }

    private static Set<Integer> getInnerStreams(int fromStream, Set<Integer> toStreams, OuterInnerDirectionalGraph outerInnerGraph, InnerJoinGraph innerJoinGraph, Set<Integer> completedStreams) {
        HashSet<Integer> innerStreams = new HashSet<Integer>();
        for (int toStream : toStreams) {
            if (!outerInnerGraph.isInner(fromStream, toStream)) continue;
            boolean hasInnerJoin = false;
            if (!innerJoinGraph.isEmpty()) {
                HashSet<Integer> doNotUseStreams = new HashSet<Integer>(completedStreams);
                completedStreams.add(fromStream);
                hasInnerJoin = NStreamOuterQueryPlanBuilder.recursiveHasInnerJoin(toStream, outerInnerGraph, innerJoinGraph, doNotUseStreams);
            }
            if (hasInnerJoin) continue;
            innerStreams.add(toStream);
        }
        return innerStreams;
    }

    private static boolean recursiveHasInnerJoin(int toStream, OuterInnerDirectionalGraph outerInnerGraph, InnerJoinGraph innerJoinGraph, Set<Integer> completedStreams) {
        Set<Integer> outerToToStream;
        boolean hasInnerJoin = innerJoinGraph.hasInnerJoin(toStream);
        if (hasInnerJoin) {
            return true;
        }
        Set<Integer> innerToToStream = outerInnerGraph.getInner(toStream);
        if (innerToToStream != null) {
            for (int nextStream : innerToToStream) {
                if (completedStreams.contains(nextStream)) continue;
                HashSet<Integer> notConsider = new HashSet<Integer>(completedStreams);
                notConsider.add(toStream);
                boolean result = NStreamOuterQueryPlanBuilder.recursiveHasInnerJoin(nextStream, outerInnerGraph, innerJoinGraph, notConsider);
                if (!result) continue;
                return true;
            }
        }
        if ((outerToToStream = outerInnerGraph.getOuter(toStream)) != null) {
            for (int nextStream : outerToToStream) {
                if (completedStreams.contains(nextStream)) continue;
                HashSet<Integer> notConsider = new HashSet<Integer>(completedStreams);
                notConsider.add(toStream);
                boolean result = NStreamOuterQueryPlanBuilder.recursiveHasInnerJoin(nextStream, outerInnerGraph, innerJoinGraph, notConsider);
                if (!result) continue;
                return true;
            }
        }
        return false;
    }

    private static Set<Integer> getOuterStreams(int fromStream, Set<Integer> toStreams, OuterInnerDirectionalGraph outerInnerGraph) {
        HashSet<Integer> outerStreams = new HashSet<Integer>();
        for (int toStream : toStreams) {
            if (!outerInnerGraph.isOuter(toStream, fromStream)) continue;
            outerStreams.add(toStream);
        }
        return outerStreams;
    }

    protected static OuterInnerDirectionalGraph graphOuterJoins(int numStreams, OuterJoinDesc[] outerJoinDescList) {
        if (outerJoinDescList.length + 1 != numStreams) {
            throw new IllegalArgumentException("Number of outer join descriptors and number of streams not matching up");
        }
        OuterInnerDirectionalGraph graph = new OuterInnerDirectionalGraph(numStreams);
        for (int i = 0; i < outerJoinDescList.length; ++i) {
            int higherStream;
            int lowerStream;
            int streamTwo;
            int streamOne;
            OuterJoinDesc desc = outerJoinDescList[i];
            int streamMax = i + 1;
            if (desc.getOptLeftNode() != null) {
                streamOne = desc.getOptLeftNode().getStreamId();
                streamTwo = desc.getOptRightNode().getStreamId();
                if (streamOne > streamMax || streamTwo > streamMax || streamOne == streamTwo) {
                    throw new IllegalArgumentException("Outer join descriptors reference future streams, or same streams");
                }
                lowerStream = streamOne;
                higherStream = streamTwo;
                if (streamOne > streamTwo) {
                    lowerStream = streamTwo;
                    higherStream = streamOne;
                }
            } else {
                streamOne = i;
                streamTwo = i + 1;
                lowerStream = i;
                higherStream = i + 1;
                graph.addUnqualifiedNavigable(streamOne, streamTwo);
            }
            if (desc.getOuterJoinType() == OuterJoinType.FULL) {
                graph.add(streamOne, streamTwo);
                graph.add(streamTwo, streamOne);
                continue;
            }
            if (desc.getOuterJoinType() == OuterJoinType.LEFT) {
                graph.add(lowerStream, higherStream);
                continue;
            }
            if (desc.getOuterJoinType() == OuterJoinType.RIGHT) {
                graph.add(higherStream, lowerStream);
                continue;
            }
            if (desc.getOuterJoinType() == OuterJoinType.INNER) continue;
            throw new IllegalArgumentException("Outer join descriptors join type not handled, type=" + (Object)((Object)desc.getOuterJoinType()));
        }
        return graph;
    }

    public static void verifyJoinedPerStream(int rootStream, Map<Integer, int[]> streamsJoinedPerStream) {
        HashSet<Integer> streams = new HashSet<Integer>();
        streams.add(rootStream);
        NStreamOuterQueryPlanBuilder.recursiveAdd(rootStream, rootStream, streamsJoinedPerStream, streams, true);
        if (streams.size() != streamsJoinedPerStream.size()) {
            throw new IllegalArgumentException("Not all streams found, streamsJoinedPerStream=" + NStreamOuterQueryPlanBuilder.print(streamsJoinedPerStream));
        }
    }

    private static void recursiveAdd(int validatedStream, int currentStream, Map<Integer, int[]> streamsJoinedPerStream, Set<Integer> streams, boolean verify) {
        if (currentStream >= streamsJoinedPerStream.size() && verify) {
            throw new IllegalArgumentException("Error in stream " + currentStream + " streamsJoinedPerStream=" + NStreamOuterQueryPlanBuilder.print(streamsJoinedPerStream));
        }
        int[] joinedStreams = streamsJoinedPerStream.get(currentStream);
        for (int i = 0; i < joinedStreams.length; ++i) {
            int addStream = joinedStreams[i];
            if (streams.contains(addStream)) {
                throw new IllegalArgumentException("Stream " + addStream + " found twice when validating " + validatedStream);
            }
            streams.add(addStream);
            NStreamOuterQueryPlanBuilder.recursiveAdd(validatedStream, addStream, streamsJoinedPerStream, streams, verify);
        }
    }

    public static String print(Map<Integer, int[]> streamsJoinedPerStream) {
        StringWriter buf = new StringWriter();
        PrintWriter printer = new PrintWriter(buf);
        for (int stream : streamsJoinedPerStream.keySet()) {
            int[] substreams = streamsJoinedPerStream.get(stream);
            printer.println("stream " + stream + " : " + Arrays.toString(substreams));
        }
        return buf.toString();
    }
}

