/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.join.queryplanbuild;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.annotation.HintEnum;
import com.espertech.esper.common.internal.compile.stage1.spec.OuterJoinDesc;
import com.espertech.esper.common.internal.compile.stage2.StatementRawInfo;
import com.espertech.esper.common.internal.compile.stage3.StatementCompileTimeServices;
import com.espertech.esper.common.internal.context.aifactory.select.StreamJoinAnalysisResultCompileTime;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.historical.common.HistoricalStreamIndexListForge;
import com.espertech.esper.common.internal.epl.historical.common.HistoricalViewableDesc;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphForge;
import com.espertech.esper.common.internal.epl.join.queryplan.QueryPlanForge;
import com.espertech.esper.common.internal.epl.join.queryplan.QueryPlanForgeDesc;
import com.espertech.esper.common.internal.epl.join.queryplan.QueryPlanNodeForgeAllUnidirectionalOuter;
import com.espertech.esper.common.internal.epl.join.queryplan.QueryPlanNodeNoOpForge;
import com.espertech.esper.common.internal.epl.join.queryplanbuild.NStreamOuterQueryPlanBuilder;
import com.espertech.esper.common.internal.epl.join.queryplanbuild.NStreamQueryPlanBuilder;
import com.espertech.esper.common.internal.epl.join.queryplanbuild.TwoStreamQueryPlanBuilder;
import com.espertech.esper.common.internal.type.OuterJoinType;
import com.espertech.esper.common.internal.util.DependencyGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryPlanBuilder {
    private static final Logger QUERY_PLAN_LOG = LoggerFactory.getLogger((String)"com.espertech.esper.queryplan");
    private static final Logger log = LoggerFactory.getLogger(QueryPlanBuilder.class);

    public static QueryPlanForgeDesc getPlan(EventType[] typesPerStream, OuterJoinDesc[] outerJoinDescList, QueryGraphForge queryGraph, String[] streamNames, HistoricalViewableDesc historicalViewableDesc, DependencyGraph dependencyGraph, HistoricalStreamIndexListForge[] historicalStreamIndexLists, StreamJoinAnalysisResultCompileTime streamJoinAnalysisResult, boolean isQueryPlanLogging, StatementRawInfo statementRawInfo, StatementCompileTimeServices services) throws ExprValidationException {
        QueryPlanForgeDesc queryPlan;
        boolean isAllInnerJoins;
        String methodName = ".getPlan ";
        int numStreams = typesPerStream.length;
        if (numStreams < 2) {
            throw new IllegalArgumentException("Number of join stream types is less then 2");
        }
        if (outerJoinDescList.length >= numStreams) {
            throw new IllegalArgumentException("Too many outer join descriptors found");
        }
        if (numStreams == 2) {
            OuterJoinType outerJoinType = null;
            if (outerJoinDescList.length > 0) {
                outerJoinType = outerJoinDescList[0].getOuterJoinType();
            }
            QueryPlanForgeDesc queryPlan2 = TwoStreamQueryPlanBuilder.build(typesPerStream, queryGraph, outerJoinType, streamJoinAnalysisResult, statementRawInfo);
            QueryPlanBuilder.removeUnidirectionalAndTable(queryPlan2.getForge(), streamJoinAnalysisResult);
            if (log.isDebugEnabled()) {
                log.debug(methodName + "2-Stream queryPlan=" + queryPlan2);
            }
            return queryPlan2;
        }
        boolean hasPreferMergeJoin = HintEnum.PREFER_MERGE_JOIN.getHint(statementRawInfo.getAnnotations()) != null;
        boolean hasForceNestedIter = HintEnum.FORCE_NESTED_ITER.getHint(statementRawInfo.getAnnotations()) != null;
        boolean bl = isAllInnerJoins = outerJoinDescList.length == 0 || OuterJoinDesc.consistsOfAllInnerJoins(outerJoinDescList);
        if (isAllInnerJoins && !hasPreferMergeJoin) {
            queryPlan = NStreamQueryPlanBuilder.build(queryGraph, typesPerStream, historicalViewableDesc, dependencyGraph, historicalStreamIndexLists, hasForceNestedIter, streamJoinAnalysisResult.getUniqueKeys(), streamJoinAnalysisResult.getTablesPerStream(), streamJoinAnalysisResult, statementRawInfo, services.getSerdeResolver());
            if (queryPlan != null) {
                QueryPlanBuilder.removeUnidirectionalAndTable(queryPlan.getForge(), streamJoinAnalysisResult);
                if (log.isDebugEnabled()) {
                    log.debug(methodName + "N-Stream inner-join queryPlan=" + queryPlan);
                }
                return queryPlan;
            }
            if (isQueryPlanLogging && QUERY_PLAN_LOG.isInfoEnabled()) {
                log.info("Switching to Outer-NStream algorithm for query plan");
            }
        }
        queryPlan = NStreamOuterQueryPlanBuilder.build(queryGraph, outerJoinDescList, streamNames, typesPerStream, historicalViewableDesc, dependencyGraph, historicalStreamIndexLists, streamJoinAnalysisResult.getUniqueKeys(), streamJoinAnalysisResult.getTablesPerStream(), streamJoinAnalysisResult, statementRawInfo, services);
        QueryPlanBuilder.removeUnidirectionalAndTable(queryPlan.getForge(), streamJoinAnalysisResult);
        return queryPlan;
    }

    private static void removeUnidirectionalAndTable(QueryPlanForge queryPlan, StreamJoinAnalysisResultCompileTime streamJoinAnalysisResult) {
        boolean allUnidirectional = streamJoinAnalysisResult.isUnidirectionalAll();
        for (int streamNum = 0; streamNum < queryPlan.getExecNodeSpecs().length; ++streamNum) {
            boolean table;
            if (allUnidirectional) {
                queryPlan.getExecNodeSpecs()[streamNum] = new QueryPlanNodeForgeAllUnidirectionalOuter(streamNum);
                continue;
            }
            boolean unidirectional = streamJoinAnalysisResult.isUnidirectional() && !streamJoinAnalysisResult.getUnidirectionalInd()[streamNum];
            boolean bl = table = streamJoinAnalysisResult.getTablesPerStream()[streamNum] != null;
            if (!unidirectional && !table) continue;
            queryPlan.getExecNodeSpecs()[streamNum] = QueryPlanNodeNoOpForge.INSTANCE;
        }
    }
}

