/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.lookup;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.compile.multikey.MultiKeyClassRef;
import com.espertech.esper.common.internal.compile.multikey.MultiKeyCodegen;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityPrint;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityQuery;
import com.espertech.esper.common.internal.epl.join.queryplan.CoercionDesc;
import com.espertech.esper.common.internal.epl.lookup.SubordHashedTableLookupStrategyExprFactory;
import com.espertech.esper.common.internal.epl.lookup.SubordHashedTableLookupStrategyPropFactory;
import com.espertech.esper.common.internal.epl.lookup.SubordTableLookupStrategyFactory;
import com.espertech.esper.common.internal.epl.lookup.SubordTableLookupStrategyFactoryForge;
import com.espertech.esper.common.internal.epl.lookupplan.SubordPropHashKeyForge;
import com.espertech.esper.common.internal.event.core.EventTypeUtility;
import com.espertech.esper.common.internal.util.IntArrayUtil;
import java.util.Arrays;
import java.util.List;

public class SubordHashedTableLookupStrategyFactoryForge
implements SubordTableLookupStrategyFactoryForge {
    private final boolean isNWOnTrigger;
    private final int numStreamsOuter;
    private final List<SubordPropHashKeyForge> hashKeys;
    private final CoercionDesc hashKeyCoercionTypes;
    private final boolean isStrictKeys;
    private final String[] hashStrictKeys;
    private final int[] keyStreamNumbers;
    private final EventType[] outerStreamTypesZeroIndexed;
    private final MultiKeyClassRef hashMultikeyClasses;

    public SubordHashedTableLookupStrategyFactoryForge(boolean isNWOnTrigger, int numStreamsOuter, List<SubordPropHashKeyForge> hashKeys, CoercionDesc hashKeyCoercionTypes, boolean isStrictKeys, String[] hashStrictKeys, int[] keyStreamNumbers, EventType[] outerStreamTypesZeroIndexed, MultiKeyClassRef hashMultikeyClasses) {
        this.isNWOnTrigger = isNWOnTrigger;
        this.numStreamsOuter = numStreamsOuter;
        this.hashKeys = hashKeys;
        this.hashKeyCoercionTypes = hashKeyCoercionTypes;
        this.isStrictKeys = isStrictKeys;
        this.hashStrictKeys = hashStrictKeys;
        this.keyStreamNumbers = keyStreamNumbers;
        this.outerStreamTypesZeroIndexed = outerStreamTypesZeroIndexed;
        this.hashMultikeyClasses = hashMultikeyClasses;
    }

    @Override
    public String toQueryPlan() {
        return this.getClass().getSimpleName() + " expressions " + Arrays.toString(this.getExpressions());
    }

    @Override
    public CodegenExpression make(CodegenMethodScope parent, SAIFFInitializeSymbol symbols, CodegenClassScope classScope) {
        CodegenMethod methodNode = parent.makeChild(SubordTableLookupStrategyFactory.class, this.getClass(), (CodegenScope)classScope);
        if (this.isStrictKeys) {
            int[] keyStreamNums = IntArrayUtil.copy(this.keyStreamNumbers);
            EventType[] keyStreamTypes = this.outerStreamTypesZeroIndexed;
            if (this.isNWOnTrigger) {
                keyStreamTypes = EventTypeUtility.shiftRight(this.outerStreamTypesZeroIndexed);
                for (int i = 0; i < keyStreamNums.length; ++i) {
                    keyStreamNums[i] = keyStreamNums[i] + 1;
                }
            }
            ExprForge[] forges = ExprNodeUtilityQuery.forgesForProperties(keyStreamTypes, this.hashStrictKeys, keyStreamNums);
            CodegenExpression eval = MultiKeyCodegen.codegenExprEvaluatorMayMultikey(forges, this.hashKeyCoercionTypes.getCoercionTypes(), this.hashMultikeyClasses, methodNode, classScope);
            methodNode.getBlock().methodReturn(CodegenExpressionBuilder.newInstance(SubordHashedTableLookupStrategyPropFactory.class, CodegenExpressionBuilder.constant(this.hashStrictKeys), CodegenExpressionBuilder.constant(keyStreamNums), eval));
            return CodegenExpressionBuilder.localMethod(methodNode, new CodegenExpression[0]);
        }
        ExprForge[] forges = new ExprForge[this.hashKeys.size()];
        for (int i = 0; i < this.hashKeys.size(); ++i) {
            forges[i] = this.hashKeys.get(i).getHashKey().getKeyExpr().getForge();
        }
        String[] expressions = ExprNodeUtilityPrint.toExpressionStringsMinPrecedence(forges);
        CodegenExpression eval = MultiKeyCodegen.codegenExprEvaluatorMayMultikey(forges, this.hashKeyCoercionTypes.getCoercionTypes(), this.hashMultikeyClasses, methodNode, classScope);
        methodNode.getBlock().methodReturn(CodegenExpressionBuilder.newInstance(SubordHashedTableLookupStrategyExprFactory.class, CodegenExpressionBuilder.constant(expressions), eval, CodegenExpressionBuilder.constant(this.isNWOnTrigger), CodegenExpressionBuilder.constant(this.numStreamsOuter)));
        return CodegenExpressionBuilder.localMethod(methodNode, new CodegenExpression[0]);
    }

    private String[] getExpressions() {
        String[] expressions = new String[this.hashKeys.size()];
        for (int i = 0; i < this.hashKeys.size(); ++i) {
            expressions[i] = ExprNodeUtilityPrint.toExpressionStringMinPrecedenceSafe(this.hashKeys.get(i).getHashKey().getKeyExpr());
        }
        return expressions;
    }
}

