/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.lookup;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.lookup.LookupStrategyDesc;
import com.espertech.esper.common.internal.epl.lookup.SubordTableLookupStrategy;
import com.espertech.esper.common.internal.epl.table.core.TableEvalLockUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.locks.Lock;

public class SubordIndexedTableLookupTableStrategy
implements SubordTableLookupStrategy {
    private final SubordTableLookupStrategy inner;
    private final Lock lock;

    public SubordIndexedTableLookupTableStrategy(SubordTableLookupStrategy inner, Lock lock) {
        this.inner = inner;
        this.lock = lock;
    }

    @Override
    public Collection<EventBean> lookup(EventBean[] events, ExprEvaluatorContext context) {
        if (context.getInstrumentationProvider().activated()) {
            context.getInstrumentationProvider().qIndexSubordLookup(this, null, null);
            Collection<EventBean> result = this.lookupInternal(events, context);
            context.getInstrumentationProvider().aIndexSubordLookup(result, null);
            return result;
        }
        return this.lookupInternal(events, context);
    }

    private Collection<EventBean> lookupInternal(EventBean[] events, ExprEvaluatorContext context) {
        TableEvalLockUtil.obtainLockUnless(this.lock, context);
        Collection<EventBean> result = this.inner.lookup(events, context);
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }

    @Override
    public LookupStrategyDesc getStrategyDesc() {
        return this.inner.getStrategyDesc();
    }

    @Override
    public String toQueryPlan() {
        return this.getClass().getSimpleName() + " inner " + this.inner.toQueryPlan();
    }
}

