/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.lookupplansubord;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.index.base.EventTable;
import com.espertech.esper.common.internal.epl.index.base.EventTableUtil;
import com.espertech.esper.common.internal.epl.join.lookup.IndexMultiKey;
import com.espertech.esper.common.internal.epl.join.lookup.IndexedPropDesc;
import com.espertech.esper.common.internal.epl.join.queryplan.CoercionDesc;
import com.espertech.esper.common.internal.epl.join.queryplan.IndexNameAndDescPair;
import com.espertech.esper.common.internal.epl.join.support.QueryPlanIndexDescOnExpr;
import com.espertech.esper.common.internal.epl.join.support.QueryPlanIndexDescSubquery;
import com.espertech.esper.common.internal.epl.join.support.QueryPlanIndexHook;
import com.espertech.esper.common.internal.epl.join.support.QueryPlanIndexHookUtil;
import com.espertech.esper.common.internal.epl.lookup.SubordTableLookupStrategyFactoryForge;
import com.espertech.esper.common.internal.epl.lookupplan.SubordPropHashKeyForge;
import com.espertech.esper.common.internal.epl.lookupplan.SubordPropRangeKeyForge;
import com.espertech.esper.common.internal.epl.lookupplansubord.EventTableIndexMetadata;
import com.espertech.esper.common.internal.epl.lookupplansubord.EventTableIndexRepository;
import com.espertech.esper.common.internal.epl.lookupplansubord.EventTableIndexRepositoryEntry;
import com.espertech.esper.common.internal.epl.lookupplansubord.IndexKeyInfo;
import com.espertech.esper.common.internal.epl.lookupplansubord.SubordinateQueryIndexDesc;
import com.espertech.esper.common.internal.epl.lookupplansubord.SubordinateQueryIndexDescForge;
import com.espertech.esper.common.internal.epl.lookupplansubord.SubordinateQueryPlanDescForge;
import com.espertech.esper.common.internal.epl.lookupplansubord.SubordinateQueryPlannerIndexPropListPair;
import com.espertech.esper.common.internal.epl.lookupplansubord.SubordinateWMatchExprQueryPlanForge;
import com.espertech.esper.common.internal.settings.ClasspathImportService;
import com.espertech.esper.common.internal.util.CollectionUtil;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.slf4j.Logger;

public class SubordinateQueryPlannerUtil {
    public static SubordinateQueryPlannerIndexPropListPair toListOfHashedAndBtreeProps(String[] hashIndexPropsProvided, Class[] hashIndexCoercionType, String[] rangeIndexPropsProvided, Class[] rangeIndexCoercionType) {
        int i;
        ArrayList<IndexedPropDesc> hashedProps = new ArrayList<IndexedPropDesc>();
        ArrayList<IndexedPropDesc> btreeProps = new ArrayList<IndexedPropDesc>();
        for (i = 0; i < hashIndexPropsProvided.length; ++i) {
            hashedProps.add(new IndexedPropDesc(hashIndexPropsProvided[i], hashIndexCoercionType[i]));
        }
        for (i = 0; i < rangeIndexPropsProvided.length; ++i) {
            btreeProps.add(new IndexedPropDesc(rangeIndexPropsProvided[i], rangeIndexCoercionType[i]));
        }
        return new SubordinateQueryPlannerIndexPropListPair(hashedProps, btreeProps);
    }

    public static void queryPlanLogOnExpr(boolean queryPlanLogging, Logger queryPlanLog, SubordinateWMatchExprQueryPlanForge strategy, Annotation[] annotations, ClasspathImportService classpathImportService) {
        QueryPlanIndexHook hook = QueryPlanIndexHookUtil.getHook(annotations, classpathImportService);
        if (queryPlanLogging && (queryPlanLog.isInfoEnabled() || hook != null)) {
            String prefix = "On-Expr ";
            queryPlanLog.info(prefix + "strategy " + strategy.getStrategy().toQueryPlan());
            if (strategy.getIndexes() == null) {
                queryPlanLog.info(prefix + "full table scan");
            } else {
                for (int i = 0; i < strategy.getIndexes().length; ++i) {
                    String indexName = strategy.getIndexes()[i].getIndexName();
                    String indexText = indexName != null ? "index " + indexName + " " : "(implicit) (" + i + ")";
                    queryPlanLog.info(prefix + indexText);
                }
            }
            if (hook != null) {
                IndexNameAndDescPair[] pairs = SubordinateQueryPlannerUtil.getPairs(strategy.getIndexes());
                SubordTableLookupStrategyFactoryForge inner = strategy.getStrategy().getOptionalInnerStrategy();
                hook.infraOnExpr(new QueryPlanIndexDescOnExpr(pairs, strategy.getStrategy().getClass().getSimpleName(), inner == null ? null : inner.getClass().getSimpleName()));
            }
        }
    }

    public static void queryPlanLogOnSubq(boolean queryPlanLogging, Logger queryPlanLog, SubordinateQueryPlanDescForge plan, int subqueryNum, Annotation[] annotations, ClasspathImportService classpathImportService) {
        QueryPlanIndexHook hook = QueryPlanIndexHookUtil.getHook(annotations, classpathImportService);
        if (queryPlanLogging && (queryPlanLog.isInfoEnabled() || hook != null)) {
            String prefix = "Subquery " + subqueryNum + " ";
            String strategy = plan == null || plan.getLookupStrategyFactory() == null ? "table scan" : plan.getLookupStrategyFactory().toQueryPlan();
            queryPlanLog.info(prefix + "strategy " + strategy);
            if (plan != null && plan.getIndexDescs() != null) {
                for (int i = 0; i < plan.getIndexDescs().length; ++i) {
                    String indexName = plan.getIndexDescs()[i].getIndexName();
                    String indexText = indexName != null ? "index " + indexName + " " : "(implicit) ";
                    queryPlanLog.info(prefix + "shared index");
                    queryPlanLog.info(prefix + indexText);
                }
            }
            if (hook != null) {
                IndexNameAndDescPair[] pairs = plan == null ? new IndexNameAndDescPair[]{} : SubordinateQueryPlannerUtil.getPairs(plan.getIndexDescs());
                String factory = plan == null ? null : plan.getLookupStrategyFactory().getClass().getSimpleName();
                hook.subquery(new QueryPlanIndexDescSubquery(pairs, subqueryNum, factory));
            }
        }
    }

    private static IndexNameAndDescPair[] getPairs(SubordinateQueryIndexDescForge[] indexDescs) {
        if (indexDescs == null) {
            return null;
        }
        IndexNameAndDescPair[] pairs = new IndexNameAndDescPair[indexDescs.length];
        for (int i = 0; i < indexDescs.length; ++i) {
            SubordinateQueryIndexDescForge index = indexDescs[i];
            pairs[i] = new IndexNameAndDescPair(index.getIndexName(), index.getIndexMultiKey().toQueryPlan());
        }
        return pairs;
    }

    public static IndexKeyInfo compileIndexKeyInfo(IndexMultiKey indexMultiKey, String[] hashIndexPropsProvided, SubordPropHashKeyForge[] hashJoinedProps, String[] rangeIndexPropsProvided, SubordPropRangeKeyForge[] rangeJoinedProps) {
        IndexedPropDesc[] indexedKeyProps = indexMultiKey.getHashIndexedProps();
        boolean isCoerceHash = false;
        SubordPropHashKeyForge[] hashesDesc = new SubordPropHashKeyForge[indexedKeyProps.length];
        Class[] hashPropCoercionTypes = new Class[indexedKeyProps.length];
        for (int i = 0; i < indexedKeyProps.length; ++i) {
            String indexField = indexedKeyProps[i].getIndexPropName();
            int index = CollectionUtil.findItem(hashIndexPropsProvided, indexField);
            if (index == -1) {
                throw new IllegalStateException("Could not find index property for lookup '" + indexedKeyProps[i]);
            }
            hashesDesc[i] = hashJoinedProps[index];
            hashPropCoercionTypes[i] = indexedKeyProps[i].getCoercionType();
            ExprForge keyForge = hashesDesc[i].getHashKey().getKeyExpr().getForge();
            ExprEvaluator evaluatorHashkey = keyForge.getExprEvaluator();
            if (evaluatorHashkey == null || JavaClassHelper.getBoxedType(indexedKeyProps[i].getCoercionType()) == JavaClassHelper.getBoxedType(keyForge.getEvaluationType())) continue;
            isCoerceHash = true;
        }
        indexedKeyProps = indexMultiKey.getRangeIndexedProps();
        SubordPropRangeKeyForge[] rangesDesc = new SubordPropRangeKeyForge[indexedKeyProps.length];
        Class[] rangePropCoercionTypes = new Class[indexedKeyProps.length];
        boolean isCoerceRange = false;
        for (int i = 0; i < indexedKeyProps.length; ++i) {
            String indexField = indexedKeyProps[i].getIndexPropName();
            int index = CollectionUtil.findItem(rangeIndexPropsProvided, indexField);
            if (index == -1) {
                throw new IllegalStateException("Could not find range property for lookup '" + indexedKeyProps[i]);
            }
            rangesDesc[i] = rangeJoinedProps[index];
            rangePropCoercionTypes[i] = rangeJoinedProps[index].getCoercionType();
            if (JavaClassHelper.getBoxedType(indexedKeyProps[i].getCoercionType()) == JavaClassHelper.getBoxedType(rangePropCoercionTypes[i])) continue;
            isCoerceRange = true;
        }
        return new IndexKeyInfo(Arrays.asList(hashesDesc), new CoercionDesc(isCoerceHash, hashPropCoercionTypes), Arrays.asList(rangesDesc), new CoercionDesc(isCoerceRange, rangePropCoercionTypes));
    }

    public static EventTable[] realizeTables(SubordinateQueryIndexDesc[] indexDescriptors, EventType eventType, EventTableIndexRepository indexRepository, Iterable<EventBean> contents, AgentInstanceContext agentInstanceContext, boolean isRecoveringResilient) {
        EventTable[] tables = new EventTable[indexDescriptors.length];
        for (int i = 0; i < tables.length; ++i) {
            SubordinateQueryIndexDesc desc = indexDescriptors[i];
            EventTable table = indexRepository.getIndexByDesc(desc.getIndexMultiKey());
            if (table == null) {
                table = EventTableUtil.buildIndex(agentInstanceContext, 0, desc.getQueryPlanIndexItem(), eventType, true, desc.getQueryPlanIndexItem().isUnique(), desc.getIndexName(), null, false);
                if (!isRecoveringResilient) {
                    EventBean[] events = new EventBean[1];
                    Iterator<EventBean> iterator = contents.iterator();
                    while (iterator.hasNext()) {
                        EventBean prefilledEvent;
                        events[0] = prefilledEvent = iterator.next();
                        table.add(events, (ExprEvaluatorContext)agentInstanceContext);
                    }
                }
                indexRepository.addIndex(desc.getIndexMultiKey(), new EventTableIndexRepositoryEntry(null, null, table));
            }
            tables[i] = table;
        }
        return tables;
    }

    public static void addIndexMetaAndRef(SubordinateQueryIndexDesc[] indexDescs, EventTableIndexMetadata repo, String deploymentId, String statementName) {
        for (SubordinateQueryIndexDesc desc : indexDescs) {
            if (desc.getIndexName() != null) continue;
            repo.addIndexNonExplicit(desc.getIndexMultiKey(), deploymentId, desc.getQueryPlanIndexItem());
        }
    }
}

