/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.methodbase;

import com.espertech.esper.common.internal.epl.methodbase.DotMethodFPInputEnum;
import com.espertech.esper.common.internal.epl.methodbase.DotMethodFPParam;
import com.espertech.esper.common.internal.epl.methodbase.DotMethodFPProvided;
import com.espertech.esper.common.internal.epl.methodbase.DotMethodFPProvidedParam;
import java.io.Serializable;
import java.io.StringWriter;

public class DotMethodFP
implements Serializable {
    private final DotMethodFPInputEnum input;
    private final DotMethodFPParam[] parameters;

    public DotMethodFP(DotMethodFPInputEnum input, DotMethodFPParam ... parameters) {
        this.input = input;
        this.parameters = parameters;
    }

    public DotMethodFPInputEnum getInput() {
        return this.input;
    }

    public DotMethodFPParam[] getParameters() {
        return this.parameters;
    }

    public String toStringFootprint(boolean isLambdaApplies) {
        if (this.parameters.length == 0) {
            return "no parameters";
        }
        StringWriter buf = new StringWriter();
        String delimiter = "";
        for (DotMethodFPParam param : this.parameters) {
            buf.append(delimiter);
            if (isLambdaApplies) {
                if (param.getLambdaParamNum() == 0) {
                    buf.append("an (non-lambda)");
                } else if (param.getLambdaParamNum() == 1) {
                    buf.append("a lambda");
                } else {
                    buf.append("a " + param.getLambdaParamNum() + "-parameter lambda");
                }
            } else {
                buf.append("an");
            }
            buf.append(" expression");
            buf.append(" providing ");
            buf.append(param.getDescription());
            delimiter = " and ";
        }
        return buf.toString();
    }

    public static String toStringProvided(DotMethodFPProvided provided, boolean isLambdaApplies) {
        if (provided.getParameters().length == 0) {
            return "no parameters";
        }
        StringWriter buf = new StringWriter();
        String delimiter = "";
        if (!isLambdaApplies) {
            buf.append(Integer.toString(provided.getParameters().length));
            buf.append(" expressions");
        } else {
            for (DotMethodFPProvidedParam param : provided.getParameters()) {
                buf.append(delimiter);
                if (param.getLambdaParamNum() == 0) {
                    buf.append("an (non-lambda)");
                } else if (param.getLambdaParamNum() == 1) {
                    buf.append("a lambda");
                } else {
                    buf.append("a " + param.getLambdaParamNum() + "-parameter lambda");
                }
                buf.append(" expression");
                delimiter = " and ";
            }
        }
        return buf.toString();
    }
}

