/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.namedwindow.consume;

import com.espertech.esper.common.client.util.Locking;
import com.espertech.esper.common.internal.context.util.EPStatementAgentInstanceHandle;
import com.espertech.esper.common.internal.epl.namedwindow.consume.NamedWindowConsumerLatch;
import com.espertech.esper.common.internal.epl.namedwindow.consume.NamedWindowConsumerLatchNone;
import com.espertech.esper.common.internal.epl.namedwindow.consume.NamedWindowConsumerLatchSpin;
import com.espertech.esper.common.internal.epl.namedwindow.consume.NamedWindowConsumerLatchWait;
import com.espertech.esper.common.internal.epl.namedwindow.consume.NamedWindowConsumerView;
import com.espertech.esper.common.internal.epl.namedwindow.consume.NamedWindowDeltaData;
import com.espertech.esper.common.internal.schedule.TimeSourceService;
import java.util.List;
import java.util.Map;

public class NamedWindowConsumerLatchFactory {
    protected final String name;
    protected final boolean useSpin;
    protected final TimeSourceService timeSourceService;
    protected final long msecWait;
    protected final boolean enabled;
    private NamedWindowConsumerLatchSpin currentLatchSpin;
    private NamedWindowConsumerLatchWait currentLatchWait;

    public NamedWindowConsumerLatchFactory(String name, boolean enabled, long msecWait, Locking locking, TimeSourceService timeSourceService, boolean initializeNow) {
        this.name = name;
        this.enabled = enabled;
        this.msecWait = msecWait;
        this.timeSourceService = timeSourceService;
        boolean bl = this.useSpin = enabled && locking == Locking.SPIN;
        if (initializeNow && this.useSpin) {
            this.currentLatchSpin = new NamedWindowConsumerLatchSpin(this);
        } else if (initializeNow && enabled) {
            this.currentLatchWait = new NamedWindowConsumerLatchWait(this);
        }
    }

    public NamedWindowConsumerLatch newLatch(NamedWindowDeltaData delta, Map<EPStatementAgentInstanceHandle, List<NamedWindowConsumerView>> consumers) {
        if (this.useSpin) {
            NamedWindowConsumerLatchSpin nextLatch;
            this.currentLatchSpin = nextLatch = new NamedWindowConsumerLatchSpin(delta, consumers, this, this.currentLatchSpin);
            return nextLatch;
        }
        if (this.enabled) {
            NamedWindowConsumerLatchWait nextLatch = new NamedWindowConsumerLatchWait(delta, consumers, this, this.currentLatchWait);
            this.currentLatchWait.setLater(nextLatch);
            this.currentLatchWait = nextLatch;
            return nextLatch;
        }
        return new NamedWindowConsumerLatchNone(delta, consumers);
    }

    public TimeSourceService getTimeSourceService() {
        return this.timeSourceService;
    }

    public String getName() {
        return this.name;
    }

    public long getMsecWait() {
        return this.msecWait;
    }
}

