/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.namedwindow.consume;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.collection.OneEventCollection;
import com.espertech.esper.common.internal.context.util.AgentInstanceStopCallback;
import com.espertech.esper.common.internal.context.util.AgentInstanceStopServices;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.namedwindow.consume.NamedWindowConsumerCallback;
import com.espertech.esper.common.internal.epl.util.FilteredEventIterator;
import com.espertech.esper.common.internal.event.core.FlushedEventBuffer;
import com.espertech.esper.common.internal.filterspec.PropertyEvaluator;
import com.espertech.esper.common.internal.view.core.ViewSupport;
import java.util.Iterator;

public class NamedWindowConsumerView
extends ViewSupport
implements AgentInstanceStopCallback {
    private final int namedWindowConsumerId;
    private final ExprEvaluator filter;
    private final EventType eventType;
    private final NamedWindowConsumerCallback consumerCallback;
    private final ExprEvaluatorContext exprEvaluatorContext;
    private final PropertyEvaluator optPropertyEvaluator;
    private final FlushedEventBuffer optPropertyContainedBuffer;
    private final boolean audit;

    public NamedWindowConsumerView(int namedWindowConsumerId, ExprEvaluator filter, PropertyEvaluator optPropertyEvaluator, EventType eventType, NamedWindowConsumerCallback consumerCallback, ExprEvaluatorContext exprEvaluatorContext, boolean audit) {
        this.namedWindowConsumerId = namedWindowConsumerId;
        this.filter = filter;
        this.optPropertyEvaluator = optPropertyEvaluator;
        this.optPropertyContainedBuffer = optPropertyEvaluator != null ? new FlushedEventBuffer() : null;
        this.eventType = eventType;
        this.consumerCallback = consumerCallback;
        this.exprEvaluatorContext = exprEvaluatorContext;
        this.audit = audit;
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        if (this.audit) {
            this.exprEvaluatorContext.getAuditProvider().stream(newData, oldData, this.exprEvaluatorContext, this.eventType.getName());
        }
        if (this.filter != null) {
            EventBean[] eventPerStream = new EventBean[1];
            newData = this.passFilter(newData, true, this.exprEvaluatorContext, eventPerStream);
            oldData = this.passFilter(oldData, false, this.exprEvaluatorContext, eventPerStream);
        }
        if (this.optPropertyEvaluator != null) {
            newData = this.getUnpacked(newData);
            oldData = this.getUnpacked(oldData);
        }
        if ((newData != null || oldData != null) && this.child != null) {
            this.child.update(newData, oldData);
        }
    }

    private EventBean[] getUnpacked(EventBean[] data) {
        if (data == null) {
            return null;
        }
        if (data.length == 0) {
            return data;
        }
        for (int i = 0; i < data.length; ++i) {
            EventBean[] unpacked = this.optPropertyEvaluator.getProperty(data[i], this.exprEvaluatorContext);
            this.optPropertyContainedBuffer.add(unpacked);
        }
        return this.optPropertyContainedBuffer.getAndFlush();
    }

    private EventBean[] passFilter(EventBean[] eventData, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext, EventBean[] eventPerStream) {
        if (eventData == null || eventData.length == 0) {
            return null;
        }
        if (eventData.length == 1) {
            eventPerStream[0] = eventData[0];
            Boolean result = (Boolean)this.filter.evaluate(eventPerStream, isNewData, exprEvaluatorContext);
            return result != null && result != false ? eventData : null;
        }
        OneEventCollection filtered = null;
        EventBean[] eventBeanArray = eventData;
        int n = eventBeanArray.length;
        for (int i = 0; i < n; ++i) {
            EventBean theEvent;
            eventPerStream[0] = theEvent = eventBeanArray[i];
            Boolean result = (Boolean)this.filter.evaluate(eventPerStream, isNewData, exprEvaluatorContext);
            if (result == null || !result.booleanValue()) continue;
            if (filtered == null) {
                filtered = new OneEventCollection();
            }
            filtered.add(theEvent);
        }
        if (filtered == null) {
            return null;
        }
        return filtered.toArray();
    }

    @Override
    public EventType getEventType() {
        if (this.optPropertyEvaluator != null) {
            return this.optPropertyEvaluator.getFragmentEventType();
        }
        return this.eventType;
    }

    @Override
    public Iterator<EventBean> iterator() {
        if (this.filter == null) {
            return this.consumerCallback.getIterator();
        }
        return new FilteredEventIterator(this.filter, this.consumerCallback.getIterator(), this.exprEvaluatorContext);
    }

    @Override
    public void stop(AgentInstanceStopServices services) {
        this.consumerCallback.stopped(this);
    }

    public int getNamedWindowConsumerId() {
        return this.namedWindowConsumerId;
    }

    public NamedWindowConsumerCallback getConsumerCallback() {
        return this.consumerCallback;
    }

    public ExprEvaluator getFilter() {
        return this.filter;
    }
}

