/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.namedwindow.core;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.util.NameAccessModifier;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.context.module.EPStatementInitServices;
import com.espertech.esper.common.internal.epl.namedwindow.core.NamedWindow;
import com.espertech.esper.common.internal.epl.namedwindow.path.NamedWindowMetaData;

public class NamedWindowDeployTimeResolver {
    public static CodegenExpression makeResolveNamedWindow(NamedWindowMetaData namedWindow, CodegenExpression initSvc) {
        return CodegenExpressionBuilder.staticMethod(NamedWindowDeployTimeResolver.class, "resolveNamedWindow", CodegenExpressionBuilder.constant(namedWindow.getEventType().getName()), CodegenExpressionBuilder.constant((Object)namedWindow.getEventType().getMetadata().getAccessModifier()), CodegenExpressionBuilder.constant(namedWindow.getNamedWindowModuleName()), initSvc);
    }

    public static NamedWindow resolveNamedWindow(String namedWindowName, NameAccessModifier visibility, String optionalModuleName, EPStatementInitServices services) {
        String deploymentId = NamedWindowDeployTimeResolver.resolveDeploymentId(namedWindowName, visibility, optionalModuleName, services);
        NamedWindow namedWindow = services.getNamedWindowManagementService().getNamedWindow(deploymentId, namedWindowName);
        if (namedWindow == null) {
            throw new EPException("Failed to resolve named window '" + namedWindowName + "'");
        }
        return namedWindow;
    }

    private static String resolveDeploymentId(String tableName, NameAccessModifier visibility, String optionalModuleName, EPStatementInitServices services) {
        String deploymentId;
        if (visibility == NameAccessModifier.PRIVATE) {
            deploymentId = services.getDeploymentId();
        } else if (visibility == NameAccessModifier.PUBLIC || visibility == NameAccessModifier.PROTECTED) {
            deploymentId = services.getNamedWindowPathRegistry().getDeploymentId(tableName, optionalModuleName);
            if (deploymentId == null) {
                throw new EPException("Failed to resolve path named window '" + tableName + "'");
            }
        } else {
            throw new IllegalArgumentException("Unrecognized visibility " + (Object)((Object)visibility));
        }
        return deploymentId;
    }
}

