/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.namedwindow.core;

import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.epl.join.lookup.IndexMultiKey;
import com.espertech.esper.common.internal.epl.namedwindow.core.NamedWindow;
import com.espertech.esper.common.internal.epl.namedwindow.core.NamedWindowRootViewInstance;
import com.espertech.esper.common.internal.epl.namedwindow.core.NamedWindowTailViewInstance;

public class NamedWindowInstance {
    private final NamedWindowRootViewInstance rootViewInstance;
    private final NamedWindowTailViewInstance tailViewInstance;

    public NamedWindowInstance(NamedWindow processor, AgentInstanceContext agentInstanceContext) {
        this.rootViewInstance = new NamedWindowRootViewInstance(processor.getRootView(), agentInstanceContext, processor.getEventTableIndexMetadata());
        this.tailViewInstance = new NamedWindowTailViewInstance(this.rootViewInstance, processor.getTailView(), processor, agentInstanceContext);
        this.rootViewInstance.setDataWindowContents(this.tailViewInstance);
    }

    public NamedWindowRootViewInstance getRootViewInstance() {
        return this.rootViewInstance;
    }

    public NamedWindowTailViewInstance getTailViewInstance() {
        return this.tailViewInstance;
    }

    public void destroy() {
        this.tailViewInstance.destroy();
        this.rootViewInstance.destroy();
    }

    public IndexMultiKey[] getIndexDescriptors() {
        return this.rootViewInstance.getIndexes();
    }

    public void removeIndex(IndexMultiKey index) {
        this.rootViewInstance.getIndexRepository().removeIndex(index);
    }

    public long getCountDataWindow() {
        return this.tailViewInstance.getNumberOfEvents();
    }

    public void removeExplicitIndex(String indexName) {
        this.rootViewInstance.getIndexRepository().removeExplicitIndex(indexName);
    }
}

