/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.output.condition;

import com.espertech.esper.common.internal.epl.output.condition.OutputCallback;
import com.espertech.esper.common.internal.epl.output.condition.OutputCondition;
import com.espertech.esper.common.internal.epl.output.condition.OutputConditionBase;
import com.espertech.esper.common.internal.epl.variable.core.VariableReader;

public final class OutputConditionCount
extends OutputConditionBase
implements OutputCondition {
    private static final boolean DO_OUTPUT = true;
    private static final boolean FORCE_UPDATE = false;
    private long eventRate;
    private int newEventsCount;
    private int oldEventsCount;
    private VariableReader variableReader;

    public OutputConditionCount(OutputCallback outputCallback, long eventRate, VariableReader variableReader) {
        super(outputCallback);
        this.eventRate = eventRate;
        this.variableReader = variableReader;
    }

    public int getNewEventsCount() {
        return this.newEventsCount;
    }

    public int getOldEventsCount() {
        return this.oldEventsCount;
    }

    @Override
    public final void updateOutputCondition(int newDataCount, int oldDataCount) {
        Object value;
        if (this.variableReader != null && (value = this.variableReader.getValue()) != null) {
            this.eventRate = ((Number)value).longValue();
        }
        this.newEventsCount += newDataCount;
        this.oldEventsCount += oldDataCount;
        if (this.isSatisfied()) {
            this.newEventsCount = 0;
            this.oldEventsCount = 0;
            this.outputCallback.continueOutputProcessing(true, false);
        }
    }

    public final String toString() {
        return this.getClass().getName() + " eventRate=" + this.eventRate;
    }

    private boolean isSatisfied() {
        return (long)this.newEventsCount >= this.eventRate || (long)this.oldEventsCount >= this.eventRate;
    }

    @Override
    public void terminated() {
        this.outputCallback.continueOutputProcessing(true, true);
    }

    @Override
    public void stopOutputCondition() {
    }
}

