/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.output.condition;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.context.util.AgentInstanceStopCallback;
import com.espertech.esper.common.internal.context.util.AgentInstanceStopServices;
import com.espertech.esper.common.internal.context.util.EPStatementHandleCallbackSchedule;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.output.condition.OutputCallback;
import com.espertech.esper.common.internal.epl.output.condition.OutputCondition;
import com.espertech.esper.common.internal.epl.output.condition.OutputConditionBase;
import com.espertech.esper.common.internal.epl.output.condition.OutputConditionExpressionFactory;
import com.espertech.esper.common.internal.epl.output.condition.OutputConditionExpressionTypeUtil;
import com.espertech.esper.common.internal.epl.variable.core.Variable;
import com.espertech.esper.common.internal.epl.variable.core.VariableChangeCallback;
import com.espertech.esper.common.internal.event.arr.ObjectArrayEventBean;
import com.espertech.esper.common.internal.schedule.ScheduleHandleCallback;
import com.espertech.esper.common.internal.schedule.ScheduleObjectType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputConditionExpression
extends OutputConditionBase
implements OutputCondition,
VariableChangeCallback {
    public static final String NAME_AUDITPROVIDER_SCHEDULE = "expression";
    private static final Logger log = LoggerFactory.getLogger(OutputConditionExpression.class);
    private final AgentInstanceContext agentInstanceContext;
    private final OutputConditionExpressionFactory parent;
    private long scheduleSlot;
    private boolean isCallbackScheduled;
    private boolean ignoreVariableCallbacks;
    private ObjectArrayEventBean builtinProperties;
    private EventBean[] eventsPerStream;
    private int totalNewEventsCount;
    private int totalOldEventsCount;
    private int totalNewEventsSum;
    private int totalOldEventsSum;
    private Long lastOutputTimestamp;
    private EPStatementHandleCallbackSchedule scheduleHandle;

    public OutputConditionExpression(OutputCallback outputCallback, final AgentInstanceContext agentInstanceContext, OutputConditionExpressionFactory parent) {
        super(outputCallback);
        this.agentInstanceContext = agentInstanceContext;
        this.parent = parent;
        this.scheduleSlot = agentInstanceContext.getStatementContext().getScheduleBucket().allocateSlot();
        this.eventsPerStream = new EventBean[1];
        if (parent.getBuiltinPropertiesEventType() != null) {
            this.builtinProperties = new ObjectArrayEventBean(OutputConditionExpressionTypeUtil.getOAPrototype(), parent.getBuiltinPropertiesEventType());
            this.lastOutputTimestamp = agentInstanceContext.getStatementContext().getSchedulingService().getTime();
        }
        if (parent.getVariables() != null && parent.getVariables().length > 0) {
            for (Variable variable : parent.getVariables()) {
                final String theVariableDepId = variable.getDeploymentId();
                final String theVariableName = variable.getMetaData().getVariableName();
                agentInstanceContext.getVariableManagementService().registerCallback(theVariableDepId, theVariableName, agentInstanceContext.getAgentInstanceId(), this);
                agentInstanceContext.addTerminationCallback(new AgentInstanceStopCallback(){

                    @Override
                    public void stop(AgentInstanceStopServices services) {
                        services.getAgentInstanceContext().getVariableManagementService().unregisterCallback(theVariableDepId, theVariableName, agentInstanceContext.getAgentInstanceId(), OutputConditionExpression.this);
                    }
                });
            }
        }
        if (parent.isStartConditionOnCreation()) {
            this.update(0, 0);
        }
    }

    @Override
    public void updateOutputCondition(int newEventsCount, int oldEventsCount) {
        this.totalNewEventsCount += newEventsCount;
        this.totalOldEventsCount += oldEventsCount;
        this.totalNewEventsSum += newEventsCount;
        this.totalOldEventsSum += oldEventsCount;
        boolean isOutput = this.evaluate(this.parent.getWhenExpressionNodeEval());
        if (isOutput) {
            this.executeThenAssignments();
            this.outputCallback.continueOutputProcessing(true, true);
            this.resetBuiltinProperties();
        }
    }

    @Override
    public void update(Object newValue, Object oldValue) {
        if (this.ignoreVariableCallbacks) {
            log.debug(".update Ignoring variable callback");
            return;
        }
        this.agentInstanceContext.getVariableManagementService().setLocalVersion();
        boolean isOutput = this.evaluate(this.parent.getWhenExpressionNodeEval());
        if (isOutput && !this.isCallbackScheduled) {
            this.scheduleCallback();
        }
    }

    @Override
    public void stopOutputCondition() {
        if (this.scheduleHandle != null) {
            this.agentInstanceContext.getAuditProvider().scheduleRemove(this.agentInstanceContext, this.scheduleHandle, ScheduleObjectType.outputratelimiting, NAME_AUDITPROVIDER_SCHEDULE);
            this.agentInstanceContext.getStatementContext().getSchedulingService().remove(this.scheduleHandle, this.scheduleSlot);
            this.scheduleHandle = null;
        }
    }

    @Override
    public void terminated() {
        boolean output = true;
        if (this.parent.getAndWhenTerminatedExpressionNodeEval() != null) {
            output = this.evaluate(this.parent.getAndWhenTerminatedExpressionNodeEval());
        }
        if (this.parent.getVariableReadWritePackageAfterTerminated() != null) {
            if (this.builtinProperties != null) {
                this.populateBuiltinProps();
                this.eventsPerStream[0] = this.builtinProperties;
            }
            this.ignoreVariableCallbacks = true;
            try {
                this.parent.getVariableReadWritePackageAfterTerminated().writeVariables(this.eventsPerStream, null, this.agentInstanceContext);
            }
            finally {
                this.ignoreVariableCallbacks = false;
            }
        }
        if (output) {
            super.terminated();
        }
    }

    private boolean evaluate(ExprEvaluator evaluator) {
        if (this.builtinProperties != null) {
            this.populateBuiltinProps();
            this.eventsPerStream[0] = this.builtinProperties;
        }
        boolean result = false;
        Boolean output = (Boolean)evaluator.evaluate(this.eventsPerStream, true, this.agentInstanceContext);
        if (output != null && output.booleanValue()) {
            result = true;
        }
        return result;
    }

    private void scheduleCallback() {
        this.isCallbackScheduled = true;
        ScheduleHandleCallback callback = new ScheduleHandleCallback(){

            @Override
            public void scheduledTrigger() {
                OutputConditionExpression.this.agentInstanceContext.getInstrumentationProvider().qOutputRateConditionScheduledEval();
                OutputConditionExpression.this.agentInstanceContext.getAuditProvider().scheduleFire(OutputConditionExpression.this.agentInstanceContext, ScheduleObjectType.outputratelimiting, OutputConditionExpression.NAME_AUDITPROVIDER_SCHEDULE);
                OutputConditionExpression.this.isCallbackScheduled = false;
                OutputConditionExpression.this.outputCallback.continueOutputProcessing(true, true);
                OutputConditionExpression.this.resetBuiltinProperties();
                OutputConditionExpression.this.agentInstanceContext.getInstrumentationProvider().aOutputRateConditionScheduledEval();
            }
        };
        this.scheduleHandle = new EPStatementHandleCallbackSchedule(this.agentInstanceContext.getEpStatementAgentInstanceHandle(), callback);
        this.agentInstanceContext.getAuditProvider().scheduleAdd(0L, this.agentInstanceContext, this.scheduleHandle, ScheduleObjectType.outputratelimiting, NAME_AUDITPROVIDER_SCHEDULE);
        this.agentInstanceContext.getStatementContext().getSchedulingService().add(0L, this.scheduleHandle, this.scheduleSlot);
        this.executeThenAssignments();
    }

    private void executeThenAssignments() {
        if (this.parent.getVariableReadWritePackage() != null) {
            if (this.builtinProperties != null) {
                this.populateBuiltinProps();
                this.eventsPerStream[0] = this.builtinProperties;
            }
            this.ignoreVariableCallbacks = true;
            try {
                this.parent.getVariableReadWritePackage().writeVariables(this.eventsPerStream, null, this.agentInstanceContext);
            }
            finally {
                this.ignoreVariableCallbacks = false;
            }
        }
    }

    private void resetBuiltinProperties() {
        if (this.builtinProperties != null) {
            this.totalNewEventsCount = 0;
            this.totalOldEventsCount = 0;
            this.lastOutputTimestamp = this.agentInstanceContext.getStatementContext().getSchedulingService().getTime();
        }
    }

    private void populateBuiltinProps() {
        OutputConditionExpressionTypeUtil.populate(this.builtinProperties.getProperties(), this.totalNewEventsCount, this.totalOldEventsCount, this.totalNewEventsSum, this.totalOldEventsSum, this.lastOutputTimestamp);
    }
}

