/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.output.polled;

import com.espertech.esper.common.internal.epl.output.polled.OutputConditionPolled;
import com.espertech.esper.common.internal.epl.output.polled.OutputConditionPolledCountState;
import com.espertech.esper.common.internal.epl.variable.core.VariableReader;
import com.espertech.esper.common.internal.util.ExecutionPathDebugLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OutputConditionPolledCount
implements OutputConditionPolled {
    private final OutputConditionPolledCountState state;
    private final VariableReader optionalVariableReader;
    private static final Logger log = LoggerFactory.getLogger(OutputConditionPolledCount.class);

    public OutputConditionPolledCount(OutputConditionPolledCountState state, VariableReader optionalVariableReader) {
        this.state = state;
        this.optionalVariableReader = optionalVariableReader;
    }

    @Override
    public OutputConditionPolledCountState getState() {
        return this.state;
    }

    @Override
    public final boolean updateOutputCondition(int newDataCount, int oldDataCount) {
        Object value;
        if (this.optionalVariableReader != null && (value = this.optionalVariableReader.getValue()) != null) {
            this.state.setEventRate(((Number)value).longValue());
        }
        this.state.setNewEventsCount(this.state.getNewEventsCount() + newDataCount);
        this.state.setOldEventsCount(this.state.getOldEventsCount() + oldDataCount);
        if (this.isSatisfied() || this.state.isFirst()) {
            if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
                log.debug(".updateOutputCondition() condition satisfied");
            }
            this.state.setIsFirst(false);
            this.state.setNewEventsCount(0);
            this.state.setOldEventsCount(0);
            return true;
        }
        return false;
    }

    private boolean isSatisfied() {
        return (long)this.state.getNewEventsCount() >= this.state.getEventRate() || (long)this.state.getOldEventsCount() >= this.state.getEventRate();
    }
}

