/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.output.polled;

import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.epl.output.polled.OutputConditionPolledCountFactory;
import com.espertech.esper.common.internal.epl.output.polled.OutputConditionPolledFactoryForge;
import com.espertech.esper.common.internal.epl.variable.compiletime.VariableMetaData;
import com.espertech.esper.common.internal.epl.variable.core.VariableDeployTimeResolver;

public final class OutputConditionPolledCountFactoryForge
implements OutputConditionPolledFactoryForge {
    private final int eventRate;
    private final VariableMetaData variableMetaData;

    public OutputConditionPolledCountFactoryForge(int eventRate, VariableMetaData variableMetaData) {
        this.eventRate = eventRate;
        this.variableMetaData = variableMetaData;
        if (eventRate < 1 && variableMetaData == null) {
            throw new IllegalArgumentException("Limiting output by event count requires an event count of at least 1 or a variable name");
        }
    }

    @Override
    public CodegenExpression make(CodegenMethodScope parent, CodegenClassScope classScope) {
        CodegenExpression variableExpression = CodegenExpressionBuilder.constantNull();
        if (this.variableMetaData != null) {
            variableExpression = VariableDeployTimeResolver.makeVariableField(this.variableMetaData, classScope, this.getClass());
        }
        CodegenMethod method = parent.makeChild(OutputConditionPolledCountFactory.class, this.getClass(), (CodegenScope)classScope);
        method.getBlock().declareVar(OutputConditionPolledCountFactory.class, "factory", CodegenExpressionBuilder.newInstance(OutputConditionPolledCountFactory.class, new CodegenExpression[0])).exprDotMethod(CodegenExpressionBuilder.ref("factory"), "setEventRate", CodegenExpressionBuilder.constant(this.eventRate)).exprDotMethod(CodegenExpressionBuilder.ref("factory"), "setVariable", variableExpression).methodReturn(CodegenExpressionBuilder.ref("factory"));
        return CodegenExpressionBuilder.localMethod(method, new CodegenExpression[0]);
    }
}

