/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.output.view;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.collection.MultiKeyArrayOfKeys;
import com.espertech.esper.common.internal.collection.UniformPair;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.context.util.AgentInstanceStopServices;
import com.espertech.esper.common.internal.context.util.StatementResultService;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.output.condition.OutputCallback;
import com.espertech.esper.common.internal.epl.output.condition.OutputCondition;
import com.espertech.esper.common.internal.epl.output.core.OutputProcessViewWithDeltaSet;
import com.espertech.esper.common.internal.epl.output.core.OutputStrategyUtil;
import com.espertech.esper.common.internal.epl.output.view.OutputProcessViewAfterState;
import com.espertech.esper.common.internal.epl.output.view.OutputProcessViewBaseWAfter;
import com.espertech.esper.common.internal.epl.output.view.OutputProcessViewConditionDeltaSet;
import com.espertech.esper.common.internal.epl.output.view.OutputProcessViewConditionFactory;
import com.espertech.esper.common.internal.epl.resultset.core.ResultSetProcessor;
import com.espertech.esper.common.internal.event.core.EventBeanUtility;
import com.espertech.esper.common.internal.metrics.audit.AuditPath;
import com.espertech.esper.common.internal.metrics.instrumentation.InstrumentationCommon;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public class OutputProcessViewConditionDefault
extends OutputProcessViewBaseWAfter
implements OutputProcessViewWithDeltaSet {
    private final OutputProcessViewConditionFactory parent;
    private final OutputCondition outputCondition;
    private final OutputProcessViewConditionDeltaSet deltaSet;

    public OutputProcessViewConditionDefault(ResultSetProcessor resultSetProcessor, Long afterConditionTime, Integer afterConditionNumberOfEvents, boolean afterConditionSatisfied, OutputProcessViewConditionFactory parent, AgentInstanceContext agentInstanceContext, boolean isJoin, EventType[] eventTypes) {
        super(agentInstanceContext, resultSetProcessor, afterConditionTime, afterConditionNumberOfEvents, afterConditionSatisfied);
        this.parent = parent;
        OutputCallback outputCallback = this.getCallbackToLocal(parent.getStreamCount());
        this.outputCondition = parent.getOutputConditionFactory().instantiateOutputCondition(agentInstanceContext, outputCallback);
        this.deltaSet = agentInstanceContext.getResultSetProcessorHelperFactory().makeOutputConditionChangeSet(eventTypes, agentInstanceContext);
    }

    @Override
    public int getNumChangesetRows() {
        return this.deltaSet.getNumChangesetRows();
    }

    @Override
    public OutputProcessViewConditionDeltaSet getOptionalDeltaSet() {
        return this.deltaSet;
    }

    @Override
    public OutputCondition getOptionalOutputCondition() {
        return this.outputCondition;
    }

    @Override
    public OutputProcessViewAfterState getOptionalAfterConditionState() {
        return null;
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        InstrumentationCommon instrumentationCommon = this.agentInstanceContext.getInstrumentationProvider();
        instrumentationCommon.qOutputProcessWCondition(newData, oldData);
        if (this.parent.isHasAfter()) {
            boolean afterSatisfied = super.checkAfterCondition(newData, this.agentInstanceContext.getStatementContext());
            if (!afterSatisfied) {
                if (!this.parent.isUnaggregatedUngrouped()) {
                    this.deltaSet.addView(new UniformPair<EventBean[]>(newData, oldData));
                }
                instrumentationCommon.aOutputProcessWCondition(true);
                return;
            }
            this.deltaSet.addView(new UniformPair<EventBean[]>(newData, oldData));
        } else {
            this.deltaSet.addView(new UniformPair<EventBean[]>(newData, oldData));
        }
        int newDataLength = 0;
        int oldDataLength = 0;
        if (newData != null) {
            newDataLength = newData.length;
        }
        if (oldData != null) {
            oldDataLength = oldData.length;
        }
        instrumentationCommon.qOutputRateConditionUpdate(newDataLength, oldDataLength);
        this.outputCondition.updateOutputCondition(newDataLength, oldDataLength);
        instrumentationCommon.aOutputRateConditionUpdate();
        instrumentationCommon.aOutputProcessWCondition(false);
    }

    @Override
    public void process(Set<MultiKeyArrayOfKeys<EventBean>> newEvents, Set<MultiKeyArrayOfKeys<EventBean>> oldEvents, ExprEvaluatorContext exprEvaluatorContext) {
        InstrumentationCommon instrumentationCommon = this.agentInstanceContext.getInstrumentationProvider();
        instrumentationCommon.qOutputProcessWConditionJoin(newEvents, oldEvents);
        if (this.parent.isHasAfter()) {
            boolean afterSatisfied = super.checkAfterCondition(newEvents, this.agentInstanceContext.getStatementContext());
            if (!afterSatisfied) {
                if (!this.parent.isUnaggregatedUngrouped()) {
                    OutputProcessViewConditionDefault.addToChangeset(newEvents, oldEvents, this.deltaSet);
                }
                instrumentationCommon.aOutputProcessWConditionJoin(true);
                return;
            }
            OutputProcessViewConditionDefault.addToChangeset(newEvents, oldEvents, this.deltaSet);
        } else {
            OutputProcessViewConditionDefault.addToChangeset(newEvents, oldEvents, this.deltaSet);
        }
        int newEventsSize = 0;
        if (newEvents != null) {
            newEventsSize = newEvents.size();
        }
        int oldEventsSize = 0;
        if (oldEvents != null) {
            oldEventsSize = oldEvents.size();
        }
        instrumentationCommon.qOutputRateConditionUpdate(newEventsSize, oldEventsSize);
        this.outputCondition.updateOutputCondition(newEventsSize, oldEventsSize);
        instrumentationCommon.aOutputRateConditionUpdate();
        instrumentationCommon.aOutputProcessWConditionJoin(false);
    }

    protected void continueOutputProcessingView(boolean doOutput, boolean forceUpdate) {
        this.agentInstanceContext.getInstrumentationProvider().qOutputRateConditionOutputNow();
        StatementResultService statementResultService = this.agentInstanceContext.getStatementResultService();
        boolean isGenerateSynthetic = statementResultService.isMakeSynthetic();
        boolean isGenerateNatural = statementResultService.isMakeNatural();
        UniformPair<EventBean[]> newOldEvents = this.resultSetProcessor.processOutputLimitedView(this.deltaSet.getViewEventsSet(), isGenerateSynthetic);
        if (this.parent.isDistinct() && newOldEvents != null) {
            newOldEvents.setFirst(EventBeanUtility.getDistinctByProp(newOldEvents.getFirst(), this.parent.getDistinctKeyGetter()));
            newOldEvents.setSecond(EventBeanUtility.getDistinctByProp(newOldEvents.getSecond(), this.parent.getDistinctKeyGetter()));
        }
        if (!isGenerateSynthetic && !isGenerateNatural) {
            this.resetEventBatches();
            this.agentInstanceContext.getInstrumentationProvider().aOutputRateConditionOutputNow(false);
            return;
        }
        if (doOutput) {
            this.output(forceUpdate, newOldEvents);
        }
        this.resetEventBatches();
        this.agentInstanceContext.getInstrumentationProvider().aOutputRateConditionOutputNow(true);
    }

    protected void output(boolean forceUpdate, UniformPair<EventBean[]> results) {
        if (this.child != null) {
            OutputStrategyUtil.output(forceUpdate, results, this.child);
        }
    }

    @Override
    public void stop(AgentInstanceStopServices services) {
        super.stop(services);
        this.deltaSet.destroy();
        this.outputCondition.stopOutputCondition();
    }

    private void resetEventBatches() {
        this.deltaSet.clear();
    }

    protected void continueOutputProcessingJoin(boolean doOutput, boolean forceUpdate) {
        this.agentInstanceContext.getInstrumentationProvider().qOutputRateConditionOutputNow();
        StatementResultService statementResultService = this.agentInstanceContext.getStatementResultService();
        boolean isGenerateSynthetic = statementResultService.isMakeSynthetic();
        boolean isGenerateNatural = statementResultService.isMakeNatural();
        UniformPair<EventBean[]> newOldEvents = this.resultSetProcessor.processOutputLimitedJoin(this.deltaSet.getJoinEventsSet(), isGenerateSynthetic);
        if (this.parent.isDistinct() && newOldEvents != null) {
            newOldEvents.setFirst(EventBeanUtility.getDistinctByProp(newOldEvents.getFirst(), this.parent.getDistinctKeyGetter()));
            newOldEvents.setSecond(EventBeanUtility.getDistinctByProp(newOldEvents.getSecond(), this.parent.getDistinctKeyGetter()));
        }
        if (!isGenerateSynthetic && !isGenerateNatural) {
            if (AuditPath.isAuditEnabled) {
                OutputStrategyUtil.indicateEarlyReturn(this.agentInstanceContext.getStatementContext(), newOldEvents);
            }
            this.resetEventBatches();
            this.agentInstanceContext.getInstrumentationProvider().aOutputRateConditionOutputNow(false);
            return;
        }
        if (doOutput) {
            this.output(forceUpdate, newOldEvents);
        }
        this.resetEventBatches();
        this.agentInstanceContext.getInstrumentationProvider().aOutputRateConditionOutputNow(true);
    }

    private OutputCallback getCallbackToLocal(int streamCount) {
        if (streamCount == 1) {
            return new OutputCallback(){

                @Override
                public void continueOutputProcessing(boolean doOutput, boolean forceUpdate) {
                    OutputProcessViewConditionDefault.this.continueOutputProcessingView(doOutput, forceUpdate);
                }
            };
        }
        return new OutputCallback(){

            @Override
            public void continueOutputProcessing(boolean doOutput, boolean forceUpdate) {
                OutputProcessViewConditionDefault.this.continueOutputProcessingJoin(doOutput, forceUpdate);
            }
        };
    }

    @Override
    public Iterator<EventBean> iterator() {
        return OutputStrategyUtil.getIterator(this.joinExecutionStrategy, this.resultSetProcessor, this.parentView, this.parent.isDistinct(), this.parent.getDistinctKeyGetter());
    }

    @Override
    public void terminated() {
        if (this.parent.isTerminable()) {
            this.outputCondition.terminated();
        }
    }

    private static void addToChangeset(Set<MultiKeyArrayOfKeys<EventBean>> newEvents, Set<MultiKeyArrayOfKeys<EventBean>> oldEvents, OutputProcessViewConditionDeltaSet joinEventsSet) {
        LinkedHashSet<Object> copyNew = newEvents != null ? new LinkedHashSet<MultiKeyArrayOfKeys<EventBean>>(newEvents) : new LinkedHashSet();
        LinkedHashSet<Object> copyOld = oldEvents != null ? new LinkedHashSet<MultiKeyArrayOfKeys<EventBean>>(oldEvents) : new LinkedHashSet();
        joinEventsSet.addJoin(new UniformPair<Set<MultiKeyArrayOfKeys<EventBean>>>(copyNew, copyOld));
    }
}

