/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.output.view;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.compile.stage1.spec.SelectClauseStreamSelectorEnum;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.epl.output.condition.OutputConditionFactory;
import com.espertech.esper.common.internal.epl.output.condition.OutputProcessViewConditionDefaultPostProcess;
import com.espertech.esper.common.internal.epl.output.core.OutputProcessView;
import com.espertech.esper.common.internal.epl.output.core.OutputProcessViewConditionLastAllUnordPostProcessAll;
import com.espertech.esper.common.internal.epl.output.core.OutputProcessViewConditionSnapshot;
import com.espertech.esper.common.internal.epl.output.view.OutputProcessViewConditionDefault;
import com.espertech.esper.common.internal.epl.output.view.OutputProcessViewConditionFirst;
import com.espertech.esper.common.internal.epl.output.view.OutputProcessViewConditionFirstPostProcess;
import com.espertech.esper.common.internal.epl.output.view.OutputProcessViewConditionLastAllUnord;
import com.espertech.esper.common.internal.epl.output.view.OutputProcessViewConditionSnapshotPostProcess;
import com.espertech.esper.common.internal.epl.output.view.OutputProcessViewConditionSpec;
import com.espertech.esper.common.internal.epl.output.view.OutputProcessViewDirectDistinctOrAfterFactory;
import com.espertech.esper.common.internal.epl.output.view.OutputStrategyPostProcess;
import com.espertech.esper.common.internal.epl.resultset.core.ResultSetProcessor;
import com.espertech.esper.common.internal.epl.resultset.core.ResultSetProcessorOutputConditionType;

public class OutputProcessViewConditionFactory
extends OutputProcessViewDirectDistinctOrAfterFactory {
    private final OutputConditionFactory outputConditionFactory;
    private final int streamCount;
    private final ResultSetProcessorOutputConditionType conditionType;
    private final boolean terminable;
    private final boolean hasAfter;
    private final boolean isUnaggregatedUngrouped;
    private final SelectClauseStreamSelectorEnum selectClauseStreamSelectorEnum;
    private final EventType[] eventTypes;

    public OutputProcessViewConditionFactory(OutputProcessViewConditionSpec spec) {
        super(spec.getPostProcessFactory(), spec.isDistinct(), spec.getDistinctKeyGetter(), spec.getAfterTimePeriod(), spec.getAfterConditionNumberOfEvents(), spec.getResultEventType());
        this.outputConditionFactory = spec.getOutputConditionFactory();
        this.streamCount = spec.getStreamCount();
        this.conditionType = spec.getConditionType();
        this.terminable = spec.isTerminable();
        this.hasAfter = spec.isHasAfter();
        this.isUnaggregatedUngrouped = spec.isUnaggregatedUngrouped();
        this.selectClauseStreamSelectorEnum = spec.getSelectClauseStreamSelector();
        this.eventTypes = spec.getEventTypes();
    }

    @Override
    public OutputProcessView makeView(ResultSetProcessor resultSetProcessor, AgentInstanceContext agentInstanceContext) {
        boolean isAfterConditionSatisfied = true;
        Long afterConditionTime = null;
        if (this.afterConditionNumberOfEvents != null) {
            isAfterConditionSatisfied = false;
        } else if (this.afterTimePeriod != null) {
            isAfterConditionSatisfied = false;
            long time = agentInstanceContext.getTimeProvider().getTime();
            long delta = this.afterTimePeriod.deltaAdd(time, null, true, agentInstanceContext);
            afterConditionTime = time + delta;
        }
        if (this.conditionType == ResultSetProcessorOutputConditionType.SNAPSHOT) {
            if (this.postProcessFactory == null) {
                return new OutputProcessViewConditionSnapshot(resultSetProcessor, afterConditionTime, this.afterConditionNumberOfEvents, isAfterConditionSatisfied, this, agentInstanceContext);
            }
            OutputStrategyPostProcess postProcess = this.postProcessFactory.make(agentInstanceContext);
            return new OutputProcessViewConditionSnapshotPostProcess(resultSetProcessor, afterConditionTime, this.afterConditionNumberOfEvents, isAfterConditionSatisfied, this, agentInstanceContext, postProcess);
        }
        if (this.conditionType == ResultSetProcessorOutputConditionType.POLICY_FIRST) {
            if (this.postProcessFactory == null) {
                return new OutputProcessViewConditionFirst(resultSetProcessor, afterConditionTime, this.afterConditionNumberOfEvents, isAfterConditionSatisfied, this, agentInstanceContext);
            }
            OutputStrategyPostProcess postProcess = this.postProcessFactory.make(agentInstanceContext);
            return new OutputProcessViewConditionFirstPostProcess(resultSetProcessor, afterConditionTime, this.afterConditionNumberOfEvents, isAfterConditionSatisfied, this, agentInstanceContext, postProcess);
        }
        if (this.conditionType == ResultSetProcessorOutputConditionType.POLICY_LASTALL_UNORDERED) {
            if (this.postProcessFactory == null) {
                return new OutputProcessViewConditionLastAllUnord(resultSetProcessor, afterConditionTime, this.afterConditionNumberOfEvents, isAfterConditionSatisfied, this, agentInstanceContext);
            }
            OutputStrategyPostProcess postProcess = this.postProcessFactory.make(agentInstanceContext);
            return new OutputProcessViewConditionLastAllUnordPostProcessAll(resultSetProcessor, afterConditionTime, this.afterConditionNumberOfEvents, isAfterConditionSatisfied, this, agentInstanceContext, postProcess);
        }
        if (this.postProcessFactory == null) {
            return new OutputProcessViewConditionDefault(resultSetProcessor, afterConditionTime, this.afterConditionNumberOfEvents, isAfterConditionSatisfied, this, agentInstanceContext, this.streamCount > 1, this.eventTypes);
        }
        OutputStrategyPostProcess postProcess = this.postProcessFactory.make(agentInstanceContext);
        return new OutputProcessViewConditionDefaultPostProcess(resultSetProcessor, afterConditionTime, this.afterConditionNumberOfEvents, isAfterConditionSatisfied, this, agentInstanceContext, postProcess, this.streamCount > 1, this.eventTypes);
    }

    public OutputConditionFactory getOutputConditionFactory() {
        return this.outputConditionFactory;
    }

    public int getStreamCount() {
        return this.streamCount;
    }

    public boolean isTerminable() {
        return this.terminable;
    }

    public boolean isHasAfter() {
        return this.hasAfter;
    }

    public boolean isUnaggregatedUngrouped() {
        return this.isUnaggregatedUngrouped;
    }

    public SelectClauseStreamSelectorEnum getSelectClauseStreamSelectorEnum() {
        return this.selectClauseStreamSelectorEnum;
    }
}

