/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.output.view;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.collection.MultiKeyArrayOfKeys;
import com.espertech.esper.common.internal.collection.UniformPair;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.context.util.AgentInstanceStopServices;
import com.espertech.esper.common.internal.context.util.StatementResultService;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.output.condition.OutputCondition;
import com.espertech.esper.common.internal.epl.output.core.OutputProcessView;
import com.espertech.esper.common.internal.epl.output.core.OutputStrategyUtil;
import com.espertech.esper.common.internal.epl.resultset.core.ResultSetProcessor;
import com.espertech.esper.common.internal.metrics.audit.AuditPath;
import com.espertech.esper.common.internal.statement.dispatch.UpdateDispatchView;
import java.util.Iterator;
import java.util.Set;

public class OutputProcessViewDirect
extends OutputProcessView {
    private final AgentInstanceContext agentInstanceContext;
    private final ResultSetProcessor resultSetProcessor;

    public OutputProcessViewDirect(AgentInstanceContext agentInstanceContext, ResultSetProcessor resultSetProcessor) {
        this.agentInstanceContext = agentInstanceContext;
        this.resultSetProcessor = resultSetProcessor;
    }

    @Override
    public int getNumChangesetRows() {
        return 0;
    }

    @Override
    public OutputCondition getOptionalOutputCondition() {
        return null;
    }

    @Override
    public EventType getEventType() {
        return this.resultSetProcessor.getResultEventType();
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        StatementResultService statementResultService = this.agentInstanceContext.getStatementResultService();
        boolean isGenerateSynthetic = statementResultService.isMakeSynthetic();
        boolean isGenerateNatural = statementResultService.isMakeNatural();
        UniformPair<EventBean[]> newOldEvents = this.resultSetProcessor.processViewResult(newData, oldData, isGenerateSynthetic);
        if (!isGenerateSynthetic && !isGenerateNatural) {
            if (AuditPath.isAuditEnabled) {
                OutputStrategyUtil.indicateEarlyReturn(this.agentInstanceContext.getStatementContext(), newOldEvents);
            }
            return;
        }
        boolean forceOutput = false;
        if (newData == null && oldData == null && (newOldEvents == null || newOldEvents.getFirst() == null && newOldEvents.getSecond() == null)) {
            forceOutput = true;
        }
        if (this.child != null) {
            this.postProcess(forceOutput, newOldEvents, this.child);
        }
    }

    @Override
    public void process(Set<MultiKeyArrayOfKeys<EventBean>> newEvents, Set<MultiKeyArrayOfKeys<EventBean>> oldEvents, ExprEvaluatorContext exprEvaluatorContext) {
        StatementResultService statementResultService = this.agentInstanceContext.getStatementResultService();
        boolean isGenerateSynthetic = statementResultService.isMakeSynthetic();
        boolean isGenerateNatural = statementResultService.isMakeNatural();
        UniformPair<EventBean[]> newOldEvents = this.resultSetProcessor.processJoinResult(newEvents, oldEvents, isGenerateSynthetic);
        if (!isGenerateSynthetic && !isGenerateNatural) {
            if (AuditPath.isAuditEnabled) {
                OutputStrategyUtil.indicateEarlyReturn(this.agentInstanceContext.getStatementContext(), newOldEvents);
            }
            return;
        }
        if (newOldEvents == null) {
            return;
        }
        if (this.child != null) {
            this.postProcess(false, newOldEvents, this.child);
        }
    }

    protected void postProcess(boolean force, UniformPair<EventBean[]> newOldEvents, UpdateDispatchView childView) {
        OutputStrategyUtil.output(force, newOldEvents, childView);
    }

    @Override
    public Iterator<EventBean> iterator() {
        return OutputStrategyUtil.getIterator(this.joinExecutionStrategy, this.resultSetProcessor, this.parentView, false, null);
    }

    @Override
    public void terminated() {
    }

    @Override
    public void stop(AgentInstanceStopServices services) {
    }
}

