/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.output.view;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.annotation.AuditEnum;
import com.espertech.esper.common.internal.collection.UniformPair;
import com.espertech.esper.common.internal.compile.stage1.spec.SelectClauseStreamSelectorEnum;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.output.view.OutputStrategyPostProcessFactory;
import com.espertech.esper.common.internal.epl.table.core.TableEvalLockUtil;
import com.espertech.esper.common.internal.epl.table.core.TableInstance;
import com.espertech.esper.common.internal.event.core.NaturalEventBean;
import com.espertech.esper.common.internal.statement.dispatch.UpdateDispatchView;

public class OutputStrategyPostProcess {
    private final OutputStrategyPostProcessFactory parent;
    private final AgentInstanceContext agentInstanceContext;
    private final TableInstance tableInstance;
    private final boolean audit;

    public OutputStrategyPostProcess(OutputStrategyPostProcessFactory parent, AgentInstanceContext agentInstanceContext, TableInstance tableInstance) {
        this.parent = parent;
        this.agentInstanceContext = agentInstanceContext;
        this.tableInstance = tableInstance;
        this.audit = AuditEnum.INSERT.getAudit(agentInstanceContext.getAnnotations()) != null;
    }

    public void output(boolean forceUpdate, UniformPair<EventBean[]> result, UpdateDispatchView finalView) {
        EventBean[] oldEvents;
        EventBean[] newEvents = result != null ? result.getFirst() : null;
        EventBean[] eventBeanArray = oldEvents = result != null ? result.getSecond() : null;
        if (this.parent.isRoute()) {
            if (newEvents != null && this.parent.getInsertIntoStreamSelector().isSelectsIStream()) {
                this.route(newEvents, this.agentInstanceContext);
            }
            if (oldEvents != null && this.parent.getInsertIntoStreamSelector().isSelectsRStream()) {
                this.route(oldEvents, this.agentInstanceContext);
            }
        }
        if (this.parent.getSelectStreamDirEnum() == SelectClauseStreamSelectorEnum.RSTREAM_ONLY) {
            newEvents = oldEvents;
            oldEvents = null;
        } else if (this.parent.getSelectStreamDirEnum() == SelectClauseStreamSelectorEnum.ISTREAM_ONLY) {
            oldEvents = null;
        }
        if (newEvents != null || oldEvents != null) {
            finalView.newResult(new UniformPair<EventBean[]>(newEvents, oldEvents));
        } else if (forceUpdate) {
            finalView.newResult(new UniformPair<Object>(null, null));
        }
    }

    private void route(EventBean[] events, ExprEvaluatorContext exprEvaluatorContext) {
        for (EventBean routed : events) {
            if (routed instanceof NaturalEventBean) {
                NaturalEventBean natural = (NaturalEventBean)routed;
                if (this.audit) {
                    this.agentInstanceContext.getAuditProvider().insert(natural.getOptionalSynthetic(), this.agentInstanceContext);
                }
                if (this.tableInstance != null) {
                    TableEvalLockUtil.obtainLockUnless(this.tableInstance.getTableLevelRWLock().writeLock(), exprEvaluatorContext);
                    this.tableInstance.addEventUnadorned(natural.getOptionalSynthetic());
                    continue;
                }
                this.agentInstanceContext.getInternalEventRouter().route(natural.getOptionalSynthetic(), this.agentInstanceContext, this.parent.isAddToFront());
                continue;
            }
            if (this.audit) {
                this.agentInstanceContext.getAuditProvider().insert(routed, this.agentInstanceContext);
            }
            if (this.tableInstance != null) {
                TableEvalLockUtil.obtainLockUnless(this.tableInstance.getTableLevelRWLock().writeLock(), exprEvaluatorContext);
                this.tableInstance.addEventUnadorned(routed);
                continue;
            }
            this.agentInstanceContext.getInternalEventRouter().route(routed, this.agentInstanceContext, this.parent.isAddToFront());
        }
    }
}

