/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.pattern.filter;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.context.util.EPStatementHandleCallbackFilter;
import com.espertech.esper.common.internal.epl.pattern.core.EvalNode;
import com.espertech.esper.common.internal.epl.pattern.core.EvalStateNode;
import com.espertech.esper.common.internal.epl.pattern.core.EvalStateNodeVisitor;
import com.espertech.esper.common.internal.epl.pattern.core.Evaluator;
import com.espertech.esper.common.internal.epl.pattern.core.PatternConsumptionUtil;
import com.espertech.esper.common.internal.epl.pattern.filter.EvalFilterNode;
import com.espertech.esper.common.internal.filterspec.FilterSpecActivatable;
import com.espertech.esper.common.internal.filterspec.FilterValueSetParam;
import com.espertech.esper.common.internal.filterspec.MatchedEventMap;
import com.espertech.esper.common.internal.filtersvc.FilterHandleCallback;
import com.espertech.esper.common.internal.filtersvc.FilterService;
import java.util.Collection;
import java.util.Set;

public class EvalFilterStateNode
extends EvalStateNode
implements FilterHandleCallback {
    protected final EvalFilterNode evalFilterNode;
    protected boolean isStarted;
    protected EPStatementHandleCallbackFilter handle;
    protected MatchedEventMap beginState;

    public EvalFilterStateNode(Evaluator parentNode, EvalFilterNode evalFilterNode) {
        super(parentNode);
        this.evalFilterNode = evalFilterNode;
    }

    @Override
    public EvalNode getFactoryNode() {
        return this.evalFilterNode;
    }

    @Override
    public final void start(MatchedEventMap beginState) {
        AgentInstanceContext agentInstanceContext = this.evalFilterNode.getContext().getAgentInstanceContext();
        agentInstanceContext.getInstrumentationProvider().qPatternFilterStart(this.evalFilterNode.factoryNode, beginState);
        this.beginState = beginState;
        if (this.isStarted) {
            throw new IllegalStateException("Filter state node already active");
        }
        agentInstanceContext.getAuditProvider().patternInstance(true, this.evalFilterNode.factoryNode, agentInstanceContext);
        this.isStarted = true;
        FilterService filterService = this.evalFilterNode.getContext().getFilterService();
        this.handle = new EPStatementHandleCallbackFilter(this.evalFilterNode.getContext().getAgentInstanceContext().getEpStatementAgentInstanceHandle(), this);
        FilterSpecActivatable filterSpec = this.evalFilterNode.getFactoryNode().getFilterSpec();
        FilterValueSetParam[][] filterValues = filterSpec.getValueSet(beginState, this.evalFilterNode.getAddendumFilters(), agentInstanceContext, agentInstanceContext.getStatementContextFilterEvalEnv());
        filterService.add(filterSpec.getFilterForEventType(), filterValues, this.handle);
        long filtersVersion = filterService.getFiltersVersion();
        this.evalFilterNode.getContext().getAgentInstanceContext().getEpStatementAgentInstanceHandle().getStatementFilterVersion().setStmtFilterVersion(filtersVersion);
        agentInstanceContext.getInstrumentationProvider().aPatternFilterStart();
    }

    @Override
    public final void quit() {
        AgentInstanceContext agentInstanceContext = this.evalFilterNode.getContext().getAgentInstanceContext();
        agentInstanceContext.getInstrumentationProvider().qPatternFilterQuit(this.evalFilterNode.factoryNode, this.beginState);
        agentInstanceContext.getAuditProvider().patternInstance(false, this.evalFilterNode.factoryNode, agentInstanceContext);
        this.isStarted = false;
        this.stopFiltering();
        agentInstanceContext.getInstrumentationProvider().aPatternFilterQuit();
    }

    private void evaluateTrue(MatchedEventMap theEvent, boolean isQuitted, EventBean optionalTriggeringEvent) {
        AgentInstanceContext agentInstanceContext = this.evalFilterNode.getContext().getAgentInstanceContext();
        agentInstanceContext.getAuditProvider().patternTrue(this.evalFilterNode.getFactoryNode(), this, theEvent, isQuitted, agentInstanceContext);
        this.getParentEvaluator().evaluateTrue(theEvent, this, isQuitted, optionalTriggeringEvent);
    }

    public EvalFilterNode getEvalFilterNode() {
        return this.evalFilterNode;
    }

    @Override
    public void matchFound(EventBean theEvent, Collection<FilterHandleCallback> allStmtMatches) {
        AgentInstanceContext agentInstanceContext = this.evalFilterNode.getContext().getAgentInstanceContext();
        agentInstanceContext.getInstrumentationProvider().qPatternFilterMatch(this.evalFilterNode.factoryNode, theEvent);
        if (!this.isStarted) {
            agentInstanceContext.getInstrumentationProvider().aPatternFilterMatch(true);
            return;
        }
        MatchedEventMap passUp = this.beginState.shallowCopy();
        if (this.evalFilterNode.getFactoryNode().getFilterSpec().getOptionalPropertyEvaluator() != null) {
            EventBean[] propertyEvents = this.evalFilterNode.getFactoryNode().getFilterSpec().getOptionalPropertyEvaluator().getProperty(theEvent, this.evalFilterNode.getContext().getAgentInstanceContext());
            if (propertyEvents == null) {
                return;
            }
            if (this.evalFilterNode.getFactoryNode().getEventAsName() != null) {
                passUp.add(this.evalFilterNode.getFactoryNode().getEventAsTagNumber(), propertyEvents);
            }
        } else if (this.evalFilterNode.getFactoryNode().getEventAsName() != null) {
            passUp.add(this.evalFilterNode.getFactoryNode().getEventAsTagNumber(), theEvent);
        }
        boolean isQuitted = false;
        if (!this.getParentEvaluator().isFilterChildNonQuitting()) {
            this.stopFiltering();
            isQuitted = true;
            agentInstanceContext.getAuditProvider().patternInstance(false, this.evalFilterNode.factoryNode, agentInstanceContext);
        }
        this.evaluateTrue(passUp, isQuitted, theEvent);
        agentInstanceContext.getInstrumentationProvider().aPatternFilterMatch(isQuitted);
    }

    @Override
    public final void accept(EvalStateNodeVisitor visitor) {
        visitor.visitFilter(this.evalFilterNode.getFactoryNode(), this, this.handle, this.beginState);
    }

    @Override
    public boolean isSubSelect() {
        return false;
    }

    public final String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("EvalFilterStateNode");
        buffer.append(" tag=");
        buffer.append(this.evalFilterNode.getFactoryNode().getFilterSpec());
        buffer.append(" spec=");
        buffer.append(this.evalFilterNode.getFactoryNode().getFilterSpec());
        return buffer.toString();
    }

    @Override
    public boolean isFilterStateNode() {
        return true;
    }

    @Override
    public boolean isNotOperator() {
        return false;
    }

    @Override
    public boolean isObserverStateNodeNonRestarting() {
        return false;
    }

    @Override
    public void removeMatch(Set<EventBean> matchEvent) {
        if (!this.isStarted) {
            return;
        }
        if (PatternConsumptionUtil.containsEvent(matchEvent, this.beginState)) {
            this.quit();
            AgentInstanceContext agentInstanceContext = this.evalFilterNode.getContext().getAgentInstanceContext();
            agentInstanceContext.getAuditProvider().patternFalse(this.evalFilterNode.getFactoryNode(), this, agentInstanceContext);
            this.getParentEvaluator().evaluateFalse(this, true);
        }
    }

    private void stopFiltering() {
        AgentInstanceContext agentInstanceContext = this.evalFilterNode.getContext().getAgentInstanceContext();
        FilterSpecActivatable filterSpec = this.evalFilterNode.getFactoryNode().getFilterSpec();
        FilterValueSetParam[][] filterValues = filterSpec.getValueSet(this.beginState, this.evalFilterNode.getAddendumFilters(), agentInstanceContext, agentInstanceContext.getStatementContextFilterEvalEnv());
        FilterService filterService = this.evalFilterNode.getContext().getFilterService();
        if (this.handle != null) {
            filterService.remove(this.handle, filterSpec.getFilterForEventType(), filterValues);
        }
        this.handle = null;
        this.isStarted = false;
        long filtersVersion = filterService.getFiltersVersion();
        this.evalFilterNode.getContext().getAgentInstanceContext().getEpStatementAgentInstanceHandle().getStatementFilterVersion().setStmtFilterVersion(filtersVersion);
    }
}

