/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.pattern.followedby;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.hook.condition.ConditionPatternSubexpressionMax;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.epl.pattern.core.EvalNode;
import com.espertech.esper.common.internal.epl.pattern.core.EvalStateNode;
import com.espertech.esper.common.internal.epl.pattern.core.EvalStateNodeVisitor;
import com.espertech.esper.common.internal.epl.pattern.core.Evaluator;
import com.espertech.esper.common.internal.epl.pattern.core.PatternConsumptionUtil;
import com.espertech.esper.common.internal.epl.pattern.followedby.EvalFollowedByNode;
import com.espertech.esper.common.internal.epl.pattern.pool.PatternSubexpressionPoolStmtSvc;
import com.espertech.esper.common.internal.filterspec.MatchedEventMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class EvalFollowedByWithMaxStateNodeManaged
extends EvalStateNode
implements Evaluator {
    protected final EvalFollowedByNode evalFollowedByNode;
    protected final HashMap<EvalStateNode, Integer> nodes;
    protected final int[] countActivePerChild;

    public EvalFollowedByWithMaxStateNodeManaged(Evaluator parentNode, EvalFollowedByNode evalFollowedByNode) {
        super(parentNode);
        this.evalFollowedByNode = evalFollowedByNode;
        this.nodes = new HashMap();
        this.countActivePerChild = (int[])(evalFollowedByNode.isTrackWithMax() ? new int[evalFollowedByNode.getChildNodes().length - 1] : null);
    }

    @Override
    public void removeMatch(Set<EventBean> matchEvent) {
        PatternConsumptionUtil.childNodeRemoveMatches(matchEvent, this.nodes.keySet());
    }

    @Override
    public EvalNode getFactoryNode() {
        return this.evalFollowedByNode;
    }

    @Override
    public final void start(MatchedEventMap beginState) {
        AgentInstanceContext agentInstanceContext = this.evalFollowedByNode.getContext().getAgentInstanceContext();
        agentInstanceContext.getInstrumentationProvider().qPatternFollowedByStart(this.evalFollowedByNode.factoryNode, beginState);
        agentInstanceContext.getAuditProvider().patternInstance(true, this.evalFollowedByNode.factoryNode, agentInstanceContext);
        EvalNode child = this.evalFollowedByNode.getChildNodes()[0];
        EvalStateNode childState = child.newState(this);
        this.nodes.put(childState, 0);
        childState.start(beginState);
        agentInstanceContext.getInstrumentationProvider().aPatternFollowedByStart();
    }

    @Override
    public final void evaluateTrue(MatchedEventMap matchEvent, EvalStateNode fromNode, boolean isQuitted, EventBean optionalTriggeringEvent) {
        Integer index = this.nodes.get(fromNode);
        AgentInstanceContext agentInstanceContext = this.evalFollowedByNode.getContext().getAgentInstanceContext();
        agentInstanceContext.getInstrumentationProvider().qPatternFollowedByEvaluateTrue(this.evalFollowedByNode.factoryNode, matchEvent, index);
        if (isQuitted) {
            this.nodes.remove(fromNode);
            if (index != null && index > 0) {
                if (this.evalFollowedByNode.isTrackWithMax()) {
                    int n = index - 1;
                    this.countActivePerChild[n] = this.countActivePerChild[n] - 1;
                }
                if (this.evalFollowedByNode.isTrackWithPool()) {
                    PatternSubexpressionPoolStmtSvc poolSvc = this.evalFollowedByNode.getContext().getStatementContext().getPatternSubexpressionPoolSvc();
                    poolSvc.getRuntimeSvc().decreaseCount(this.evalFollowedByNode, this.evalFollowedByNode.getContext().getAgentInstanceContext());
                    poolSvc.getStmtHandler().decreaseCount();
                }
            }
        }
        if (index == null) {
            agentInstanceContext.getInstrumentationProvider().aPatternFollowedByEvaluateTrue(false);
            return;
        }
        int numChildNodes = this.evalFollowedByNode.getChildNodes().length;
        boolean isFollowedByQuitted = false;
        if (index == numChildNodes - 1) {
            if (this.nodes.isEmpty()) {
                isFollowedByQuitted = true;
                agentInstanceContext.getAuditProvider().patternInstance(false, this.evalFollowedByNode.factoryNode, agentInstanceContext);
            }
            agentInstanceContext.getAuditProvider().patternTrue(this.evalFollowedByNode.getFactoryNode(), this, matchEvent, isFollowedByQuitted, agentInstanceContext);
            this.getParentEvaluator().evaluateTrue(matchEvent, this, isFollowedByQuitted, optionalTriggeringEvent);
        } else {
            int max;
            if (this.evalFollowedByNode.isTrackWithMax() && (max = this.evalFollowedByNode.getFactoryNode().getMax(index)) != -1 && max >= 0 && this.countActivePerChild[index] >= max) {
                this.evalFollowedByNode.getContext().getAgentInstanceContext().getStatementContext().getExceptionHandlingService().handleCondition(new ConditionPatternSubexpressionMax(max), this.evalFollowedByNode.getContext().getAgentInstanceContext().getStatementContext());
                return;
            }
            if (this.evalFollowedByNode.isTrackWithPool()) {
                PatternSubexpressionPoolStmtSvc poolSvc = this.evalFollowedByNode.getContext().getStatementContext().getPatternSubexpressionPoolSvc();
                boolean allow = poolSvc.getRuntimeSvc().tryIncreaseCount(this.evalFollowedByNode, this.evalFollowedByNode.getContext().getAgentInstanceContext());
                if (!allow) {
                    return;
                }
                poolSvc.getStmtHandler().increaseCount();
            }
            if (this.evalFollowedByNode.isTrackWithMax()) {
                int n = index;
                this.countActivePerChild[n] = this.countActivePerChild[n] + 1;
            }
            EvalNode child = this.evalFollowedByNode.getChildNodes()[index + 1];
            EvalStateNode childState = child.newState(this);
            this.nodes.put(childState, index + 1);
            childState.start(matchEvent);
        }
        agentInstanceContext.getInstrumentationProvider().aPatternFollowedByEvaluateTrue(isFollowedByQuitted);
    }

    @Override
    public final void evaluateFalse(EvalStateNode fromNode, boolean restartable) {
        AgentInstanceContext agentInstanceContext = this.evalFollowedByNode.getContext().getAgentInstanceContext();
        agentInstanceContext.getInstrumentationProvider().qPatternFollowedByEvalFalse(this.evalFollowedByNode.factoryNode);
        fromNode.quit();
        Integer index = this.nodes.remove(fromNode);
        if (index != null && index > 0) {
            if (this.evalFollowedByNode.isTrackWithMax()) {
                int n = index - 1;
                this.countActivePerChild[n] = this.countActivePerChild[n] - 1;
            }
            if (this.evalFollowedByNode.isTrackWithPool()) {
                PatternSubexpressionPoolStmtSvc poolSvc = this.evalFollowedByNode.getContext().getStatementContext().getPatternSubexpressionPoolSvc();
                poolSvc.getRuntimeSvc().decreaseCount(this.evalFollowedByNode, this.evalFollowedByNode.getContext().getAgentInstanceContext());
                poolSvc.getStmtHandler().decreaseCount();
            }
        }
        if (this.nodes.isEmpty()) {
            agentInstanceContext.getAuditProvider().patternFalse(this.evalFollowedByNode.getFactoryNode(), this, agentInstanceContext);
            this.getParentEvaluator().evaluateFalse(this, true);
            this.quit();
        }
        agentInstanceContext.getInstrumentationProvider().aPatternFollowedByEvalFalse();
    }

    @Override
    public boolean isNotOperator() {
        return false;
    }

    @Override
    public boolean isFilterStateNode() {
        return false;
    }

    @Override
    public boolean isFilterChildNonQuitting() {
        return false;
    }

    @Override
    public boolean isObserverStateNodeNonRestarting() {
        return false;
    }

    @Override
    public final void quit() {
        AgentInstanceContext agentInstanceContext = this.evalFollowedByNode.getContext().getAgentInstanceContext();
        agentInstanceContext.getInstrumentationProvider().qPatternFollowedByQuit(this.evalFollowedByNode.factoryNode);
        agentInstanceContext.getAuditProvider().patternInstance(false, this.evalFollowedByNode.factoryNode, agentInstanceContext);
        for (Map.Entry<EvalStateNode, Integer> entry : this.nodes.entrySet()) {
            entry.getKey().quit();
            if (!this.evalFollowedByNode.isTrackWithPool() || entry.getValue() <= 0) continue;
            PatternSubexpressionPoolStmtSvc poolSvc = this.evalFollowedByNode.getContext().getStatementContext().getPatternSubexpressionPoolSvc();
            poolSvc.getRuntimeSvc().decreaseCount(this.evalFollowedByNode, this.evalFollowedByNode.getContext().getAgentInstanceContext());
            poolSvc.getStmtHandler().decreaseCount();
        }
        agentInstanceContext.getInstrumentationProvider().aPatternFollowedByQuit();
    }

    @Override
    public final void accept(EvalStateNodeVisitor visitor) {
        visitor.visitFollowedBy(this.evalFollowedByNode.getFactoryNode(), this, this.nodes, this.countActivePerChild);
        for (EvalStateNode node : this.nodes.keySet()) {
            node.accept(visitor);
        }
    }

    public final String toString() {
        return "EvalFollowedByStateNode nodes=" + this.nodes.size();
    }
}

