/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.pattern.observer;

import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.context.util.EPStatementHandleCallbackSchedule;
import com.espertech.esper.common.internal.epl.pattern.observer.EventObserver;
import com.espertech.esper.common.internal.epl.pattern.observer.EventObserverVisitor;
import com.espertech.esper.common.internal.epl.pattern.observer.ObserverEventEvaluator;
import com.espertech.esper.common.internal.filterspec.MatchedEventMap;
import com.espertech.esper.common.internal.schedule.ScheduleHandleCallback;
import com.espertech.esper.common.internal.schedule.ScheduleObjectType;

public class TimerIntervalObserver
implements EventObserver,
ScheduleHandleCallback {
    public static final String NAME_AUDITPROVIDER_SCHEDULE = "timer-interval";
    private final long deltaTime;
    private final MatchedEventMap beginState;
    private final ObserverEventEvaluator observerEventEvaluator;
    private final long scheduleSlot;
    private boolean isTimerActive = false;
    private EPStatementHandleCallbackSchedule scheduleHandle;

    public TimerIntervalObserver(long deltaTime, MatchedEventMap beginState, ObserverEventEvaluator observerEventEvaluator) {
        this.deltaTime = deltaTime;
        this.beginState = beginState;
        this.observerEventEvaluator = observerEventEvaluator;
        this.scheduleSlot = observerEventEvaluator.getContext().getAgentInstanceContext().getScheduleBucket().allocateSlot();
    }

    @Override
    public final void scheduledTrigger() {
        AgentInstanceContext agentInstanceContext = this.observerEventEvaluator.getContext().getAgentInstanceContext();
        agentInstanceContext.getInstrumentationProvider().qPatternObserverScheduledEval();
        agentInstanceContext.getAuditProvider().scheduleFire(agentInstanceContext, ScheduleObjectType.pattern, NAME_AUDITPROVIDER_SCHEDULE);
        this.observerEventEvaluator.observerEvaluateTrue(this.beginState, true);
        this.isTimerActive = false;
        agentInstanceContext.getInstrumentationProvider().aPatternObserverScheduledEval();
    }

    @Override
    public MatchedEventMap getBeginState() {
        return this.beginState;
    }

    @Override
    public void startObserve() {
        if (this.isTimerActive) {
            throw new IllegalStateException("Timer already active");
        }
        if (this.deltaTime <= 0L) {
            this.observerEventEvaluator.observerEvaluateTrue(this.beginState, true);
        } else {
            AgentInstanceContext agentInstanceContext = this.observerEventEvaluator.getContext().getAgentInstanceContext();
            this.scheduleHandle = new EPStatementHandleCallbackSchedule(agentInstanceContext.getEpStatementAgentInstanceHandle(), this);
            agentInstanceContext.getAuditProvider().scheduleAdd(this.deltaTime, agentInstanceContext, this.scheduleHandle, ScheduleObjectType.pattern, NAME_AUDITPROVIDER_SCHEDULE);
            this.observerEventEvaluator.getContext().getStatementContext().getSchedulingService().add(this.deltaTime, this.scheduleHandle, this.scheduleSlot);
            this.isTimerActive = true;
        }
    }

    @Override
    public void stopObserve() {
        if (this.isTimerActive) {
            AgentInstanceContext agentInstanceContext = this.observerEventEvaluator.getContext().getAgentInstanceContext();
            agentInstanceContext.getAuditProvider().scheduleRemove(agentInstanceContext, this.scheduleHandle, ScheduleObjectType.pattern, NAME_AUDITPROVIDER_SCHEDULE);
            agentInstanceContext.getSchedulingService().remove(this.scheduleHandle, this.scheduleSlot);
            this.isTimerActive = false;
            this.scheduleHandle = null;
        }
    }

    @Override
    public void accept(EventObserverVisitor visitor) {
        visitor.visitObserver(this.beginState, 10, this.scheduleSlot);
    }
}

