/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.pattern.observer;

import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.time.abacus.TimeAbacus;
import com.espertech.esper.common.internal.epl.expression.time.node.ExprTimePeriod;
import com.espertech.esper.common.internal.epl.pattern.core.MatchedEventConvertorForge;
import com.espertech.esper.common.internal.epl.pattern.core.PatternDeltaComputeUtil;
import com.espertech.esper.common.internal.epl.pattern.observer.ObserverForge;
import com.espertech.esper.common.internal.epl.pattern.observer.ObserverParameterException;
import com.espertech.esper.common.internal.epl.pattern.observer.ObserverParameterUtil;
import com.espertech.esper.common.internal.epl.pattern.observer.TimerIntervalObserverFactory;
import com.espertech.esper.common.internal.schedule.ScheduleHandleCallbackProvider;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.util.List;

public class TimerIntervalObserverForge
implements ObserverForge,
ScheduleHandleCallbackProvider {
    private static final String NAME = "Timer-interval observer";
    protected ExprNode parameter;
    protected int scheduleCallbackId = -1;
    protected TimeAbacus timeAbacus;
    protected MatchedEventConvertorForge convertor;

    @Override
    public void setObserverParameters(List<ExprNode> parameters, MatchedEventConvertorForge convertor, ExprValidationContext validationContext) throws ObserverParameterException {
        Class returnType;
        ObserverParameterUtil.validateNoNamedParameters(NAME, parameters);
        String errorMessage = "Timer-interval observer requires a single numeric or time period parameter";
        if (parameters.size() != 1) {
            throw new ObserverParameterException(errorMessage);
        }
        if (!(parameters.get(0) instanceof ExprTimePeriod) && !JavaClassHelper.isNumeric(returnType = parameters.get(0).getForge().getEvaluationType())) {
            throw new ObserverParameterException(errorMessage);
        }
        this.parameter = parameters.get(0);
        this.convertor = convertor;
        this.timeAbacus = validationContext.getClasspathImportService().getTimeAbacus();
    }

    @Override
    public void setScheduleCallbackId(int id) {
        this.scheduleCallbackId = id;
    }

    @Override
    public void collectSchedule(List<ScheduleHandleCallbackProvider> schedules) {
        schedules.add(this);
    }

    @Override
    public CodegenExpression makeCodegen(CodegenMethodScope parent, SAIFFInitializeSymbol symbols, CodegenClassScope classScope) {
        if (this.scheduleCallbackId == -1) {
            throw new IllegalStateException("Unassigned schedule callback id");
        }
        CodegenMethod method = parent.makeChild(TimerIntervalObserverFactory.class, TimerIntervalObserverForge.class, (CodegenScope)classScope);
        CodegenExpression patternDelta = PatternDeltaComputeUtil.makePatternDeltaAnonymous(this.parameter, this.convertor, this.timeAbacus, method, classScope);
        method.getBlock().declareVar(TimerIntervalObserverFactory.class, "factory", (CodegenExpression)CodegenExpressionBuilder.exprDotMethodChain(symbols.getAddInitSvc(method)).add("getPatternFactoryService", new CodegenExpression[0]).add("observerTimerInterval", new CodegenExpression[0])).exprDotMethod(CodegenExpressionBuilder.ref("factory"), "setScheduleCallbackId", CodegenExpressionBuilder.constant(this.scheduleCallbackId)).exprDotMethod(CodegenExpressionBuilder.ref("factory"), "setDeltaCompute", patternDelta).methodReturn(CodegenExpressionBuilder.ref("factory"));
        return CodegenExpressionBuilder.localMethod(method, new CodegenExpression[0]);
    }
}

