/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.resultset.core;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.annotation.HookType;
import com.espertech.esper.common.client.annotation.IterableUnbound;
import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.compile.multikey.MultiKeyClassRef;
import com.espertech.esper.common.internal.compile.multikey.MultiKeyPlan;
import com.espertech.esper.common.internal.compile.multikey.MultiKeyPlanner;
import com.espertech.esper.common.internal.compile.stage1.spec.DBStatementStreamSpec;
import com.espertech.esper.common.internal.compile.stage1.spec.GroupByClauseExpressions;
import com.espertech.esper.common.internal.compile.stage1.spec.InsertIntoDesc;
import com.espertech.esper.common.internal.compile.stage1.spec.MethodStreamSpec;
import com.espertech.esper.common.internal.compile.stage1.spec.OrderByItem;
import com.espertech.esper.common.internal.compile.stage1.spec.OutputLimitLimitType;
import com.espertech.esper.common.internal.compile.stage1.spec.OutputLimitSpec;
import com.espertech.esper.common.internal.compile.stage1.spec.SelectClauseStreamSelectorEnum;
import com.espertech.esper.common.internal.compile.stage1.spec.StreamSpecCompiled;
import com.espertech.esper.common.internal.compile.stage1.spec.TableQueryStreamSpec;
import com.espertech.esper.common.internal.compile.stage2.SelectClauseElementCompiled;
import com.espertech.esper.common.internal.compile.stage2.SelectClauseExprCompiledSpec;
import com.espertech.esper.common.internal.compile.stage2.SelectClauseSpecCompiled;
import com.espertech.esper.common.internal.compile.stage2.StatementRawInfo;
import com.espertech.esper.common.internal.compile.stage3.StatementCompileTimeServices;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeableFactory;
import com.espertech.esper.common.internal.context.util.ContextPropertyRegistry;
import com.espertech.esper.common.internal.epl.agg.core.AggregationGroupByRollupDescForge;
import com.espertech.esper.common.internal.epl.agg.core.AggregationGroupByRollupLevelForge;
import com.espertech.esper.common.internal.epl.agg.core.AggregationServiceFactoryFactory;
import com.espertech.esper.common.internal.epl.agg.core.AggregationServiceForgeDesc;
import com.espertech.esper.common.internal.epl.agg.rollup.GroupByRollupPerLevelForge;
import com.espertech.esper.common.internal.epl.agg.rollup.GroupByRollupPlanDesc;
import com.espertech.esper.common.internal.epl.agg.rollup.GroupByRollupPlanHook;
import com.espertech.esper.common.internal.epl.annotation.AnnotationUtil;
import com.espertech.esper.common.internal.epl.expression.agg.base.ExprAggregateNode;
import com.espertech.esper.common.internal.epl.expression.agg.base.ExprAggregateNodeUtil;
import com.espertech.esper.common.internal.epl.expression.core.ExprConstantNodeImpl;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprGroupingIdNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprGroupingNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprIdentNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeBase;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeOrigin;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodePropOrStreamDesc;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodePropOrStreamExprDesc;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodePropOrStreamPropDesc;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodePropOrStreamSet;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityAggregation;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityCompare;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityModify;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityPrint;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityQuery;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityValidate;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContextBuilder;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.declared.compiletime.ExprDeclaredNode;
import com.espertech.esper.common.internal.epl.expression.prev.ExprPreviousNode;
import com.espertech.esper.common.internal.epl.expression.prior.ExprPriorNode;
import com.espertech.esper.common.internal.epl.expression.time.node.ExprTimePeriod;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeDeclaredVisitor;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeGroupingVisitorWParent;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeIdentifierAndStreamRefVisitor;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeIdentifierCollectVisitorWContainer;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeSubselectDeclaredDotVisitor;
import com.espertech.esper.common.internal.epl.output.polled.OutputConditionPolledFactoryFactory;
import com.espertech.esper.common.internal.epl.output.polled.OutputConditionPolledFactoryForge;
import com.espertech.esper.common.internal.epl.resultset.agggrouped.ResultSetProcessorAggregateGroupedForge;
import com.espertech.esper.common.internal.epl.resultset.core.ColumnNamedNodeSwapper;
import com.espertech.esper.common.internal.epl.resultset.core.GroupByRollupInfo;
import com.espertech.esper.common.internal.epl.resultset.core.ResultSetProcessorDesc;
import com.espertech.esper.common.internal.epl.resultset.core.ResultSetProcessorFactoryForge;
import com.espertech.esper.common.internal.epl.resultset.core.ResultSetProcessorOutputConditionType;
import com.espertech.esper.common.internal.epl.resultset.core.ResultSetProcessorType;
import com.espertech.esper.common.internal.epl.resultset.core.ResultSetSpec;
import com.espertech.esper.common.internal.epl.resultset.handthru.ResultSetProcessorHandThroughFactoryForge;
import com.espertech.esper.common.internal.epl.resultset.order.OrderByElementForge;
import com.espertech.esper.common.internal.epl.resultset.order.OrderByProcessorFactoryFactory;
import com.espertech.esper.common.internal.epl.resultset.order.OrderByProcessorFactoryForge;
import com.espertech.esper.common.internal.epl.resultset.rowforall.ResultSetProcessorRowForAllForge;
import com.espertech.esper.common.internal.epl.resultset.rowperevent.ResultSetProcessorRowPerEventForge;
import com.espertech.esper.common.internal.epl.resultset.rowpergroup.ResultSetProcessorRowPerGroupForge;
import com.espertech.esper.common.internal.epl.resultset.rowpergrouprollup.ResultSetProcessorRowPerGroupRollupForge;
import com.espertech.esper.common.internal.epl.resultset.select.core.SelectClauseStreamCompiledSpec;
import com.espertech.esper.common.internal.epl.resultset.select.core.SelectExprProcessorDescriptor;
import com.espertech.esper.common.internal.epl.resultset.select.core.SelectExprProcessorFactory;
import com.espertech.esper.common.internal.epl.resultset.select.core.SelectExprProcessorForge;
import com.espertech.esper.common.internal.epl.resultset.select.core.SelectProcessorArgs;
import com.espertech.esper.common.internal.epl.resultset.select.core.SelectSubscriberDescriptor;
import com.espertech.esper.common.internal.epl.resultset.simple.ResultSetProcessorSimpleForge;
import com.espertech.esper.common.internal.epl.streamtype.PropertyResolutionDescriptor;
import com.espertech.esper.common.internal.epl.streamtype.StreamTypeService;
import com.espertech.esper.common.internal.epl.streamtype.StreamTypeServiceImpl;
import com.espertech.esper.common.internal.epl.streamtype.StreamTypesException;
import com.espertech.esper.common.internal.epl.table.compiletime.TableMetaData;
import com.espertech.esper.common.internal.event.core.NativeEventType;
import com.espertech.esper.common.internal.serde.compiletime.eventtype.SerdeEventTypeUtility;
import com.espertech.esper.common.internal.settings.ClasspathImportUtil;
import com.espertech.esper.common.internal.util.CollectionUtil;
import com.espertech.esper.common.internal.view.access.ViewResourceDelegateExpr;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultSetProcessorFactoryFactory {
    private static final Logger log = LoggerFactory.getLogger(ResultSetProcessorFactoryFactory.class);

    public static ResultSetProcessorDesc getProcessorPrototype(ResultSetSpec spec, StreamTypeService typeService, ViewResourceDelegateExpr viewResourceDelegate, boolean[] isUnidirectionalStream, boolean allowAggregation, ContextPropertyRegistry contextPropertyRegistry, boolean isFireAndForget, boolean isOnSelect, StatementRawInfo statementRawInfo, StatementCompileTimeServices services) throws ExprValidationException {
        ExprNodePropOrStreamSet nonAggregatedPropsOrderBy;
        boolean allInSelect;
        String reasonMessage;
        boolean isFirst;
        boolean hasOutputLimit;
        boolean isSelectRStream;
        boolean isAggregated;
        MultiKeyClassRef groupByMultiKey;
        AggregationGroupByRollupDescForge groupByRollupDesc;
        ExprNode[] groupByNodesValidated;
        GroupByRollupInfo groupByRollupInfo;
        int numStreams;
        StreamSpecCompiled streamSpec;
        List<OrderByItem> orderByListUnexpanded = spec.getOrderByList();
        SelectClauseSpecCompiled selectClauseSpec = spec.getSelectClauseSpec();
        InsertIntoDesc insertIntoDesc = spec.getInsertIntoDesc();
        ExprNode optionalHavingNode = spec.getHavingClause();
        OutputLimitSpec outputLimitSpec = spec.getOptionalOutputLimitSpec();
        GroupByClauseExpressions groupByClauseExpressions = spec.getGroupByClauseExpressions();
        ArrayList<ExprDeclaredNode> declaredNodes = new ArrayList<ExprDeclaredNode>();
        ArrayList<StmtClassForgeableFactory> additionalForgeables = new ArrayList<StmtClassForgeableFactory>(2);
        ResultSetProcessorFactoryFactory.validateOutputLimit(outputLimitSpec, statementRawInfo, services);
        boolean isUnidirectional = false;
        for (int i = 0; i < isUnidirectionalStream.length; ++i) {
            isUnidirectional |= isUnidirectionalStream[i];
        }
        boolean isHistoricalOnly = false;
        if (spec.getStreamSpecs().length == 1 && ((streamSpec = spec.getStreamSpecs()[0]) instanceof DBStatementStreamSpec || streamSpec instanceof MethodStreamSpec || streamSpec instanceof TableQueryStreamSpec)) {
            isHistoricalOnly = true;
        }
        boolean join = (numStreams = typeService.getEventTypes().length) > 1;
        List<OrderByItem> orderByList = ResultSetProcessorFactoryFactory.expandColumnNames(selectClauseSpec.getSelectExprList(), orderByListUnexpanded);
        LinkedList<SelectClauseExprCompiledSpec> namedSelectionList = new LinkedList<SelectClauseExprCompiledSpec>();
        boolean allowRollup = groupByClauseExpressions != null && groupByClauseExpressions.getGroupByRollupLevels() != null;
        boolean resettableAggs = isUnidirectional || statementRawInfo.getStatementType().isOnTriggerInfra();
        String intoTableName = spec.getIntoTableSpec() == null ? null : spec.getIntoTableSpec().getName();
        ExprValidationContext validationContext = new ExprValidationContextBuilder(typeService, statementRawInfo, services).withViewResourceDelegate(viewResourceDelegate).withAllowRollupFunctions(allowRollup).withAllowBindingConsumption(true).withIsResettingAggregations(resettableAggs).withIntoTableName(intoTableName).build();
        ResultSetProcessorFactoryFactory.validateSelectAssignColNames(selectClauseSpec, namedSelectionList, validationContext);
        if (spec.getGroupByClauseExpressions() != null && spec.getGroupByClauseExpressions().getSelectClausePerLevel() != null) {
            ExprNodeUtilityValidate.getValidatedSubtree(ExprNodeOrigin.GROUPBY, spec.getGroupByClauseExpressions().getSelectClausePerLevel(), validationContext);
        }
        boolean isUsingWildcard = selectClauseSpec.isUsingWildcard();
        boolean isUsingStreamSelect = false;
        for (SelectClauseElementCompiled compiled : selectClauseSpec.getSelectExprList()) {
            if (!(compiled instanceof SelectClauseStreamCompiledSpec)) continue;
            SelectClauseStreamCompiledSpec streamSelectSpec = (SelectClauseStreamCompiledSpec)compiled;
            int streamNum = Integer.MIN_VALUE;
            boolean isFragmentEvent = false;
            boolean isProperty = false;
            Object propertyType = null;
            isUsingStreamSelect = true;
            for (int i = 0; i < typeService.getStreamNames().length; ++i) {
                String streamName = streamSelectSpec.getStreamName();
                if (typeService.getStreamNames()[i].equals(streamName)) {
                    streamNum = i;
                    break;
                }
                EventType candidateProviderOfFragments = typeService.getEventTypes()[i];
                if (candidateProviderOfFragments instanceof NativeEventType || candidateProviderOfFragments.getFragmentType(streamName) == null) continue;
                streamNum = i;
                isFragmentEvent = true;
                break;
            }
            if (streamNum == Integer.MIN_VALUE) {
                PropertyResolutionDescriptor desc = null;
                try {
                    desc = typeService.resolveByPropertyName(streamSelectSpec.getStreamName(), false);
                }
                catch (StreamTypesException streamName) {
                    // empty catch block
                }
                if (desc == null) {
                    throw new ExprValidationException("Stream selector '" + streamSelectSpec.getStreamName() + ".*' does not match any stream name in the from clause");
                }
                isProperty = true;
                propertyType = desc.getPropertyType();
                streamNum = desc.getStreamNum();
            }
            streamSelectSpec.setStreamNumber(streamNum);
            streamSelectSpec.setFragmentEvent(isFragmentEvent);
            streamSelectSpec.setProperty(isProperty, (Class)propertyType);
            if (streamNum < 0) continue;
            TableMetaData table = services.getTableCompileTimeResolver().resolveTableFromEventType(typeService.getEventTypes()[streamNum]);
            streamSelectSpec.setTableMetadata(table);
        }
        if (optionalHavingNode != null) {
            optionalHavingNode = ExprNodeUtilityValidate.getValidatedSubtree(ExprNodeOrigin.HAVING, optionalHavingNode, validationContext);
            if (spec.getGroupByClauseExpressions() != null) {
                ExprNodeUtilityValidate.getValidatedSubtree(ExprNodeOrigin.GROUPBY, spec.getGroupByClauseExpressions().getOptHavingNodePerLevel(), validationContext);
            }
        }
        for (int i = 0; i < orderByList.size(); ++i) {
            ExprNode orderByNode = orderByList.get(i).getExprNode();
            ExprNodeSubselectDeclaredDotVisitor visitor = new ExprNodeSubselectDeclaredDotVisitor();
            orderByNode.accept(visitor);
            if (visitor.getSubselects().size() > 0) {
                throw new ExprValidationException("Subselects not allowed within order-by clause");
            }
            Boolean isDescending = orderByList.get(i).isDescending();
            OrderByItem validatedOrderBy = new OrderByItem(ExprNodeUtilityValidate.getValidatedSubtree(ExprNodeOrigin.ORDERBY, orderByNode, validationContext), isDescending);
            orderByList.set(i, validatedOrderBy);
            if (spec.getGroupByClauseExpressions() == null || spec.getGroupByClauseExpressions().getOptOrderByPerLevel() == null) continue;
            ExprNodeUtilityValidate.getValidatedSubtree(ExprNodeOrigin.GROUPBY, spec.getGroupByClauseExpressions().getOptOrderByPerLevel(), validationContext);
        }
        ArrayList<ExprNode> selectNodes = new ArrayList<ExprNode>();
        for (SelectClauseExprCompiledSpec element : namedSelectionList) {
            selectNodes.add(element.getSelectExpression());
        }
        ArrayList<ExprNode> orderByNodes = new ArrayList<ExprNode>();
        for (OrderByItem element : orderByList) {
            orderByNodes.add(element.getExprNode());
        }
        LinkedList<ExprAggregateNode> selectAggregateExprNodes = new LinkedList<ExprAggregateNode>();
        HashMap<ExprNode, String> selectAggregationNodesNamed = new HashMap<ExprNode, String>();
        ExprNodeDeclaredVisitor declaredNodeVisitor = new ExprNodeDeclaredVisitor();
        for (SelectClauseExprCompiledSpec element : namedSelectionList) {
            ExprAggregateNodeUtil.getAggregatesBottomUp(element.getSelectExpression(), selectAggregateExprNodes);
            if (element.getProvidedName() != null) {
                selectAggregationNodesNamed.put(element.getSelectExpression(), element.getProvidedName());
            }
            element.getSelectExpression().accept(declaredNodeVisitor);
            declaredNodes.addAll(declaredNodeVisitor.getDeclaredExpressions());
            declaredNodeVisitor.clear();
        }
        if (spec.getGroupByClauseExpressions() != null) {
            ExprAggregateNodeUtil.getAggregatesBottomUp(spec.getGroupByClauseExpressions().getSelectClausePerLevel(), selectAggregateExprNodes);
        }
        if (!allowAggregation && !selectAggregateExprNodes.isEmpty()) {
            throw new ExprValidationException("Aggregation functions are not allowed in this context");
        }
        LinkedList<ExprAggregateNode> havingAggregateExprNodes = new LinkedList<ExprAggregateNode>();
        ExprNodePropOrStreamSet propertiesAggregatedHaving = new ExprNodePropOrStreamSet();
        if (optionalHavingNode != null) {
            ExprAggregateNodeUtil.getAggregatesBottomUp(optionalHavingNode, havingAggregateExprNodes);
            if (groupByClauseExpressions != null) {
                ExprAggregateNodeUtil.getAggregatesBottomUp(groupByClauseExpressions.getOptHavingNodePerLevel(), havingAggregateExprNodes);
            }
            propertiesAggregatedHaving = ExprNodeUtilityAggregation.getAggregatedProperties(havingAggregateExprNodes);
        }
        if (!allowAggregation && !havingAggregateExprNodes.isEmpty()) {
            throw new ExprValidationException("Aggregation functions are not allowed in this context");
        }
        LinkedList<ExprAggregateNode> orderByAggregateExprNodes = new LinkedList<ExprAggregateNode>();
        if (orderByNodes != null && !orderByNodes.isEmpty()) {
            for (ExprNode orderByNode : orderByNodes) {
                ExprAggregateNodeUtil.getAggregatesBottomUp(orderByNode, orderByAggregateExprNodes);
            }
            if (groupByClauseExpressions != null) {
                ExprAggregateNodeUtil.getAggregatesBottomUp(groupByClauseExpressions.getOptOrderByPerLevel(), orderByAggregateExprNodes);
            }
            if (!allowAggregation && !orderByAggregateExprNodes.isEmpty()) {
                throw new ExprValidationException("Aggregation functions are not allowed in this context");
            }
        }
        if ((groupByRollupInfo = ResultSetProcessorFactoryFactory.analyzeValidateGroupBy(groupByClauseExpressions, validationContext)) == null) {
            groupByNodesValidated = ExprNodeUtilityQuery.EMPTY_EXPR_ARRAY;
            groupByRollupDesc = null;
            groupByMultiKey = null;
        } else {
            groupByNodesValidated = groupByRollupInfo.getExprNodes();
            groupByRollupDesc = groupByRollupInfo.getRollupDesc();
            groupByMultiKey = groupByRollupInfo.getOptionalMultiKey();
            additionalForgeables.addAll(groupByRollupInfo.getAdditionalForgeables());
        }
        boolean hasGroupBy = groupByNodesValidated.length > 0;
        AggregationServiceForgeDesc aggregationServiceForgeDesc = AggregationServiceFactoryFactory.getService(selectAggregateExprNodes, selectAggregationNodesNamed, declaredNodes, groupByNodesValidated, groupByMultiKey, havingAggregateExprNodes, orderByAggregateExprNodes, Collections.emptyList(), hasGroupBy, statementRawInfo.getAnnotations(), services.getVariableCompileTimeResolver(), false, spec.getWhereClause(), spec.getHavingClause(), typeService.getEventTypes(), groupByRollupDesc, spec.getContextName(), spec.getIntoTableSpec(), services.getTableCompileTimeResolver(), isUnidirectional, isFireAndForget, isOnSelect, services.getClasspathImportServiceCompileTime(), statementRawInfo, services.getSerdeResolver());
        additionalForgeables.addAll(aggregationServiceForgeDesc.getAdditionalForgeables());
        boolean localGroupByMatchesGroupBy = ResultSetProcessorFactoryFactory.analyzeLocalGroupBy(groupByNodesValidated, selectAggregateExprNodes, havingAggregateExprNodes, orderByAggregateExprNodes);
        SelectProcessorArgs args = new SelectProcessorArgs(selectClauseSpec.getSelectExprList(), groupByRollupInfo, isUsingWildcard, null, spec.getForClauseSpec(), typeService, null, isFireAndForget, spec.getAnnotations(), statementRawInfo, services);
        SelectExprProcessorDescriptor selectExprProcessorDesc = SelectExprProcessorFactory.getProcessor(args, insertIntoDesc, true);
        SelectExprProcessorForge selectExprProcessorForge = selectExprProcessorDesc.getForge();
        additionalForgeables.addAll(selectExprProcessorDesc.getAdditionalForgeables());
        SelectSubscriberDescriptor selectSubscriberDescriptor = selectExprProcessorDesc.getSubscriberDescriptor();
        EventType resultEventType = selectExprProcessorForge.getResultEventType();
        GroupByRollupPerLevelForge rollupPerLevelForges = null;
        if (groupByRollupDesc != null) {
            rollupPerLevelForges = ResultSetProcessorFactoryFactory.getRollUpPerLevelExpressions(spec, groupByNodesValidated, groupByRollupDesc, groupByRollupInfo, insertIntoDesc, typeService, validationContext, isFireAndForget, statementRawInfo, services);
        }
        OrderByProcessorFactoryForge orderByProcessorFactory = OrderByProcessorFactoryFactory.getProcessor(namedSelectionList, orderByList, spec.getRowLimitSpec(), services.getVariableCompileTimeResolver(), services.getConfiguration().getCompiler().getLanguage().isSortUsingCollator(), spec.getContextName(), rollupPerLevelForges == null ? (OrderByElementForge[][])null : rollupPerLevelForges.getOptionalOrderByElements());
        boolean hasOrderBy = orderByProcessorFactory != null;
        ExprNodePropOrStreamSet propertiesGroupBy = ExprNodeUtilityAggregation.getGroupByPropertiesValidateHasOne(groupByNodesValidated);
        ExprNodePropOrStreamSet nonAggregatedPropsSelect = ExprNodeUtilityAggregation.getNonAggregatedProps(typeService.getEventTypes(), selectNodes, contextPropertyRegistry);
        if (optionalHavingNode != null) {
            ExprNodeUtilityAggregation.addNonAggregatedProps(optionalHavingNode, nonAggregatedPropsSelect, typeService.getEventTypes(), contextPropertyRegistry);
        }
        boolean bl = isAggregated = !selectAggregateExprNodes.isEmpty() || !havingAggregateExprNodes.isEmpty() || !orderByAggregateExprNodes.isEmpty() || !propertiesAggregatedHaving.isEmpty();
        if (optionalHavingNode != null && isAggregated) {
            ResultSetProcessorFactoryFactory.validateHaving(propertiesGroupBy, optionalHavingNode);
        }
        boolean bl2 = isSelectRStream = spec.getSelectClauseStreamSelector() == SelectClauseStreamSelectorEnum.RSTREAM_ISTREAM_BOTH || spec.getSelectClauseStreamSelector() == SelectClauseStreamSelectorEnum.RSTREAM_ONLY;
        if (spec.getInsertIntoDesc() != null && spec.getInsertIntoDesc().getStreamSelector().isSelectsRStream()) {
            isSelectRStream = true;
        }
        ExprForge optionalHavingForge = optionalHavingNode == null ? null : optionalHavingNode.getForge();
        boolean hasOutputLimitOpt = ResultSetProcessorOutputConditionType.getOutputLimitOpt(statementRawInfo.getAnnotations(), services.getConfiguration(), hasOrderBy);
        boolean hasOutputLimitSnapshot = outputLimitSpec != null && outputLimitSpec.getDisplayLimit() == OutputLimitLimitType.SNAPSHOT;
        boolean isGrouped = groupByNodesValidated.length > 0 || groupByRollupDesc != null;
        ResultSetProcessorOutputConditionType outputConditionType = outputLimitSpec != null ? ResultSetProcessorOutputConditionType.getConditionType(outputLimitSpec.getDisplayLimit(), isAggregated, hasOrderBy, hasOutputLimitOpt, isGrouped) : null;
        OutputConditionPolledFactoryForge optionalOutputFirstConditionFactoryForge = null;
        if (outputLimitSpec != null && outputLimitSpec.getDisplayLimit() == OutputLimitLimitType.FIRST) {
            optionalOutputFirstConditionFactoryForge = OutputConditionPolledFactoryFactory.createConditionFactory(outputLimitSpec, statementRawInfo, services);
        }
        boolean bl3 = hasOutputLimit = outputLimitSpec != null;
        if (hasOutputLimitOpt && hasOutputLimit) {
            ResultSetProcessorFactoryFactory.planSerdes(selectExprProcessorForge.getResultEventType(), additionalForgeables, statementRawInfo, services);
        }
        if (groupByNodesValidated.length == 0 && selectAggregateExprNodes.isEmpty() && havingAggregateExprNodes.isEmpty()) {
            boolean isOutputLimitingNoSnapshot;
            boolean bl4 = isOutputLimitingNoSnapshot = outputLimitSpec != null && outputLimitSpec.getDisplayLimit() != OutputLimitLimitType.SNAPSHOT;
            if (orderByNodes.isEmpty() && optionalHavingNode == null && !isOutputLimitingNoSnapshot && spec.getRowLimitSpec() == null) {
                log.debug(".getProcessor Using no result processor");
                ResultSetProcessorHandThroughFactoryForge forge = new ResultSetProcessorHandThroughFactoryForge(resultEventType, selectExprProcessorForge, isSelectRStream);
                return new ResultSetProcessorDesc(forge, ResultSetProcessorType.HANDTHROUGH, new SelectExprProcessorForge[]{selectExprProcessorForge}, join, hasOutputLimit, outputConditionType, hasOutputLimitSnapshot, resultEventType, false, aggregationServiceForgeDesc, orderByProcessorFactory, selectSubscriberDescriptor, additionalForgeables);
            }
            ResultSetProcessorSimpleForge forge = new ResultSetProcessorSimpleForge(resultEventType, selectExprProcessorForge, optionalHavingForge, isSelectRStream, outputLimitSpec, outputConditionType, hasOrderBy, typeService.getEventTypes());
            return new ResultSetProcessorDesc(forge, ResultSetProcessorType.UNAGGREGATED_UNGROUPED, new SelectExprProcessorForge[]{selectExprProcessorForge}, join, hasOutputLimit, outputConditionType, hasOutputLimitSnapshot, resultEventType, false, aggregationServiceForgeDesc, orderByProcessorFactory, selectSubscriberDescriptor, additionalForgeables);
        }
        boolean isLast = outputLimitSpec != null && outputLimitSpec.getDisplayLimit() == OutputLimitLimitType.LAST;
        boolean bl5 = isFirst = outputLimitSpec != null && outputLimitSpec.getDisplayLimit() == OutputLimitLimitType.FIRST;
        if (namedSelectionList.isEmpty() && propertiesAggregatedHaving.isEmpty() && havingAggregateExprNodes.isEmpty() && !isLast && !isFirst) {
            ResultSetProcessorSimpleForge forge = new ResultSetProcessorSimpleForge(resultEventType, selectExprProcessorForge, optionalHavingForge, isSelectRStream, outputLimitSpec, outputConditionType, hasOrderBy, typeService.getEventTypes());
            return new ResultSetProcessorDesc(forge, ResultSetProcessorType.UNAGGREGATED_UNGROUPED, new SelectExprProcessorForge[]{selectExprProcessorForge}, join, hasOutputLimit, outputConditionType, hasOutputLimitSnapshot, resultEventType, false, aggregationServiceForgeDesc, orderByProcessorFactory, selectSubscriberDescriptor, additionalForgeables);
        }
        if (groupByNodesValidated.length == 0 && isAggregated) {
            boolean hasStreamSelect = ExprNodeUtilityQuery.hasStreamSelect(selectNodes);
            if (nonAggregatedPropsSelect.isEmpty() && !hasStreamSelect && !isUsingWildcard && !isUsingStreamSelect && localGroupByMatchesGroupBy && (viewResourceDelegate == null || viewResourceDelegate.getPreviousRequests().isEmpty())) {
                log.debug(".getProcessor Using ResultSetProcessorRowForAll");
                ResultSetProcessorRowForAllForge forge = new ResultSetProcessorRowForAllForge(resultEventType, selectExprProcessorForge, optionalHavingForge, isSelectRStream, isUnidirectional, isHistoricalOnly, outputLimitSpec, hasOrderBy, outputConditionType);
                return new ResultSetProcessorDesc(forge, ResultSetProcessorType.FULLYAGGREGATED_UNGROUPED, new SelectExprProcessorForge[]{selectExprProcessorForge}, join, hasOutputLimit, outputConditionType, hasOutputLimitSnapshot, resultEventType, false, aggregationServiceForgeDesc, orderByProcessorFactory, selectSubscriberDescriptor, additionalForgeables);
            }
            log.debug(".getProcessor Using ResultSetProcessorRowPerEventImpl");
            ResultSetProcessorRowPerEventForge forge = new ResultSetProcessorRowPerEventForge(selectExprProcessorForge.getResultEventType(), selectExprProcessorForge, optionalHavingForge, isSelectRStream, isUnidirectional, isHistoricalOnly, outputLimitSpec, outputConditionType, hasOrderBy);
            return new ResultSetProcessorDesc(forge, ResultSetProcessorType.AGGREGATED_UNGROUPED, new SelectExprProcessorForge[]{selectExprProcessorForge}, join, hasOutputLimit, outputConditionType, hasOutputLimitSnapshot, resultEventType, false, aggregationServiceForgeDesc, orderByProcessorFactory, selectSubscriberDescriptor, additionalForgeables);
        }
        if (groupByNodesValidated.length == 0) {
            throw new IllegalStateException("Unexpected empty group-by expression list");
        }
        boolean allInGroupBy = true;
        String notInGroupByReason = null;
        if (isUsingStreamSelect) {
            allInGroupBy = false;
            notInGroupByReason = "stream select";
        }
        if ((reasonMessage = propertiesGroupBy.notContainsAll(nonAggregatedPropsSelect)) != null) {
            notInGroupByReason = reasonMessage;
            allInGroupBy = false;
        }
        if (isUsingWildcard) {
            allInGroupBy = false;
            notInGroupByReason = "wildcard select";
        }
        boolean bl6 = allInSelect = (reasonMessage = nonAggregatedPropsSelect.notContainsAll(nonAggregatedPropsOrderBy = ExprNodeUtilityAggregation.getNonAggregatedProps(typeService.getEventTypes(), orderByNodes, contextPropertyRegistry))) == null;
        if (isUsingWildcard) {
            allInSelect = true;
        }
        if (allInGroupBy && allInSelect && localGroupByMatchesGroupBy) {
            boolean rollup;
            SelectExprProcessorForge[] selectExprProcessorForges;
            ResultSetProcessorType type;
            ResultSetProcessorFactoryForge forge;
            boolean noDataWindowSingleStream = typeService.getIStreamOnly()[0] && typeService.getEventTypes().length < 2;
            boolean iterableUnboundConfig = services.getConfiguration().getCompiler().getViewResources().isIterableUnbound();
            boolean iterateUnbounded = noDataWindowSingleStream && (iterableUnboundConfig || AnnotationUtil.hasAnnotation(statementRawInfo.getAnnotations(), IterableUnbound.class));
            log.debug(".getProcessor Using ResultSetProcessorRowPerGroup");
            if (groupByRollupDesc != null) {
                if (outputLimitSpec != null) {
                    ResultSetProcessorFactoryFactory.planSerdes(typeService, additionalForgeables, statementRawInfo, services);
                }
                forge = new ResultSetProcessorRowPerGroupRollupForge(resultEventType, rollupPerLevelForges, groupByNodesValidated, isSelectRStream, isUnidirectional, outputLimitSpec, orderByProcessorFactory != null, noDataWindowSingleStream, groupByRollupDesc, typeService.getEventTypes().length > 1, isHistoricalOnly, iterateUnbounded, outputConditionType, optionalOutputFirstConditionFactoryForge, typeService.getEventTypes(), groupByMultiKey);
                type = ResultSetProcessorType.FULLYAGGREGATED_GROUPED_ROLLUP;
                selectExprProcessorForges = rollupPerLevelForges.getSelectExprProcessorForges();
                rollup = true;
            } else {
                boolean unboundedProcessor;
                boolean noDataWindowSingleSnapshot = iterateUnbounded || outputLimitSpec != null && outputLimitSpec.getDisplayLimit() == OutputLimitLimitType.SNAPSHOT && noDataWindowSingleStream;
                boolean bl7 = unboundedProcessor = noDataWindowSingleSnapshot && !isHistoricalOnly;
                if (unboundedProcessor) {
                    ResultSetProcessorFactoryFactory.planSerdes(typeService, additionalForgeables, statementRawInfo, services);
                }
                forge = new ResultSetProcessorRowPerGroupForge(resultEventType, typeService.getEventTypes(), groupByNodesValidated, optionalHavingForge, isSelectRStream, isUnidirectional, outputLimitSpec, hasOrderBy, isHistoricalOnly, outputConditionType, typeService.getEventTypes(), optionalOutputFirstConditionFactoryForge, groupByMultiKey, unboundedProcessor);
                type = ResultSetProcessorType.FULLYAGGREGATED_GROUPED;
                selectExprProcessorForges = new SelectExprProcessorForge[]{selectExprProcessorForge};
                rollup = false;
            }
            return new ResultSetProcessorDesc(forge, type, selectExprProcessorForges, join, hasOutputLimit, outputConditionType, hasOutputLimitSnapshot, resultEventType, rollup, aggregationServiceForgeDesc, orderByProcessorFactory, selectSubscriberDescriptor, additionalForgeables);
        }
        if (groupByRollupDesc != null) {
            throw new ExprValidationException("Group-by with rollup requires a fully-aggregated query, the query is not full-aggregated because of " + notInGroupByReason);
        }
        ResultSetProcessorAggregateGroupedForge forge = new ResultSetProcessorAggregateGroupedForge(resultEventType, groupByNodesValidated, optionalHavingForge, isSelectRStream, isUnidirectional, outputLimitSpec, hasOrderBy, isHistoricalOnly, outputConditionType, optionalOutputFirstConditionFactoryForge, typeService.getEventTypes(), groupByMultiKey);
        return new ResultSetProcessorDesc(forge, ResultSetProcessorType.AGGREGATED_GROUPED, new SelectExprProcessorForge[]{selectExprProcessorForge}, join, hasOutputLimit, outputConditionType, hasOutputLimitSnapshot, resultEventType, false, aggregationServiceForgeDesc, orderByProcessorFactory, selectSubscriberDescriptor, additionalForgeables);
    }

    private static void planSerdes(StreamTypeService typeService, List<StmtClassForgeableFactory> additionalForgeables, StatementRawInfo raw, StatementCompileTimeServices services) {
        for (EventType eventType : typeService.getEventTypes()) {
            List<StmtClassForgeableFactory> serdeForgeables = SerdeEventTypeUtility.plan(eventType, raw, services.getSerdeEventTypeRegistry(), services.getSerdeResolver());
            additionalForgeables.addAll(serdeForgeables);
        }
    }

    private static void planSerdes(EventType eventType, List<StmtClassForgeableFactory> additionalForgeables, StatementRawInfo raw, StatementCompileTimeServices services) {
        List<StmtClassForgeableFactory> serdeForgeables = SerdeEventTypeUtility.plan(eventType, raw, services.getSerdeEventTypeRegistry(), services.getSerdeResolver());
        additionalForgeables.addAll(serdeForgeables);
    }

    private static void validateOutputLimit(OutputLimitSpec outputLimitSpec, StatementRawInfo statementRawInfo, StatementCompileTimeServices services) throws ExprValidationException {
        ExprTimePeriod timePeriodExpr;
        if (outputLimitSpec == null) {
            return;
        }
        ExprValidationContext validationContext = new ExprValidationContextBuilder(new StreamTypeServiceImpl(false), statementRawInfo, services).build();
        if (outputLimitSpec.getAfterTimePeriodExpr() != null) {
            timePeriodExpr = (ExprTimePeriod)ExprNodeUtilityValidate.getValidatedSubtree(ExprNodeOrigin.OUTPUTLIMIT, outputLimitSpec.getAfterTimePeriodExpr(), validationContext);
            outputLimitSpec.setAfterTimePeriodExpr(timePeriodExpr);
        }
        if (outputLimitSpec.getTimePeriodExpr() != null) {
            timePeriodExpr = (ExprTimePeriod)ExprNodeUtilityValidate.getValidatedSubtree(ExprNodeOrigin.OUTPUTLIMIT, outputLimitSpec.getTimePeriodExpr(), validationContext);
            outputLimitSpec.setTimePeriodExpr(timePeriodExpr);
            if (timePeriodExpr.isConstantResult() && timePeriodExpr.evaluateAsSeconds(null, true, null) <= 0.0) {
                throw new ExprValidationException("Invalid time period expression returns a zero or negative time interval");
            }
        }
    }

    private static boolean analyzeLocalGroupBy(ExprNode[] groupByNodesValidated, List<ExprAggregateNode> selectAggregateExprNodes, List<ExprAggregateNode> havingAggregateExprNodes, List<ExprAggregateNode> orderByAggregateExprNodes) {
        boolean localGroupByMatchesGroupBy = ResultSetProcessorFactoryFactory.analyzeLocalGroupBy(groupByNodesValidated, selectAggregateExprNodes);
        localGroupByMatchesGroupBy = localGroupByMatchesGroupBy && ResultSetProcessorFactoryFactory.analyzeLocalGroupBy(groupByNodesValidated, havingAggregateExprNodes);
        localGroupByMatchesGroupBy = localGroupByMatchesGroupBy && ResultSetProcessorFactoryFactory.analyzeLocalGroupBy(groupByNodesValidated, orderByAggregateExprNodes);
        return localGroupByMatchesGroupBy;
    }

    private static boolean analyzeLocalGroupBy(ExprNode[] groupByNodesValidated, List<ExprAggregateNode> aggNodes) {
        for (ExprAggregateNode agg : aggNodes) {
            if (agg.getOptionalLocalGroupBy() == null || ExprNodeUtilityCompare.deepEqualsIsSubset(agg.getOptionalLocalGroupBy().getPartitionExpressions(), groupByNodesValidated)) continue;
            return false;
        }
        return true;
    }

    private static GroupByRollupInfo analyzeValidateGroupBy(GroupByClauseExpressions groupBy, ExprValidationContext validationContext) throws ExprValidationException {
        if (groupBy == null) {
            return null;
        }
        ExprNodeUtilityValidate.validateNoSpecialsGroupByExpressions(groupBy.getGroupByNodes());
        ExprNode[] validated = new ExprNode[groupBy.getGroupByNodes().length];
        for (int i = 0; i < validated.length; ++i) {
            validated[i] = ExprNodeUtilityValidate.getValidatedSubtree(ExprNodeOrigin.GROUPBY, groupBy.getGroupByNodes()[i], validationContext);
        }
        MultiKeyPlan groupByMKPLan = MultiKeyPlanner.planMultiKey(validated, false, validationContext.getStatementRawInfo(), validationContext.getSerdeResolver());
        if (groupBy.getGroupByRollupLevels() == null) {
            return new GroupByRollupInfo(validated, null, groupByMKPLan.getMultiKeyForgeables(), groupByMKPLan.getClassRef());
        }
        ArrayList<AggregationGroupByRollupLevelForge> levels = new ArrayList<AggregationGroupByRollupLevelForge>();
        int countOffset = 0;
        int countNumber = -1;
        Class[] allGroupKeyTypes = ExprNodeUtilityQuery.getExprResultTypes(validated);
        ArrayList<StmtClassForgeableFactory> additionalForgeables = new ArrayList<StmtClassForgeableFactory>(groupByMKPLan.getMultiKeyForgeables());
        for (int[] mki : groupBy.getGroupByRollupLevels()) {
            MultiKeyPlan levelMKPLan;
            ++countNumber;
            if (mki.length == 0) {
                levels.add(new AggregationGroupByRollupLevelForge(countNumber, -1, null, allGroupKeyTypes, groupByMKPLan.getClassRef(), null));
                continue;
            }
            ExprNode[] levelExpressions = new ExprNode[mki.length];
            for (int i = 0; i < levelExpressions.length; ++i) {
                levelExpressions[i] = validated[mki[i]];
            }
            if (ResultSetProcessorFactoryFactory.sameExpressions(levelExpressions, validated)) {
                levelMKPLan = groupByMKPLan;
            } else {
                levelMKPLan = MultiKeyPlanner.planMultiKey(levelExpressions, false, validationContext.getStatementRawInfo(), validationContext.getSerdeResolver());
                additionalForgeables.addAll(levelMKPLan.getMultiKeyForgeables());
            }
            levels.add(new AggregationGroupByRollupLevelForge(countNumber, countOffset, mki, allGroupKeyTypes, groupByMKPLan.getClassRef(), levelMKPLan.getClassRef()));
            ++countOffset;
        }
        AggregationGroupByRollupLevelForge[] levelsarr = levels.toArray(new AggregationGroupByRollupLevelForge[levels.size()]);
        AggregationGroupByRollupDescForge rollup = new AggregationGroupByRollupDescForge(levelsarr);
        try {
            GroupByRollupPlanHook hook = (GroupByRollupPlanHook)ClasspathImportUtil.getAnnotationHook(validationContext.getAnnotations(), HookType.INTERNAL_GROUPROLLUP_PLAN, GroupByRollupPlanHook.class, validationContext.getClasspathImportService());
            if (hook != null) {
                hook.query(new GroupByRollupPlanDesc(validated, rollup));
            }
        }
        catch (ExprValidationException e) {
            throw new EPException("Failed to obtain hook for " + (Object)((Object)HookType.INTERNAL_QUERY_PLAN));
        }
        return new GroupByRollupInfo(validated, rollup, additionalForgeables, groupByMKPLan.getClassRef());
    }

    private static GroupByRollupPerLevelForge getRollUpPerLevelExpressions(ResultSetSpec spec, ExprNode[] groupByNodesValidated, AggregationGroupByRollupDescForge groupByRollupDesc, GroupByRollupInfo groupByRollupInfo, InsertIntoDesc insertIntoDesc, StreamTypeService typeService, ExprValidationContext validationContext, boolean isFireAndForget, StatementRawInfo statementRawInfo, StatementCompileTimeServices compileTimeServices) throws ExprValidationException {
        int i;
        int numLevels = groupByRollupDesc.getLevels().length;
        GroupByClauseExpressions groupByExpressions = spec.getGroupByClauseExpressions();
        SelectExprProcessorForge[] processors = new SelectExprProcessorForge[numLevels];
        ExprForge[] havingClauses = null;
        if (groupByExpressions.getOptHavingNodePerLevel() != null) {
            havingClauses = new ExprForge[numLevels];
        }
        OrderByElementForge[][] orderByElements = null;
        if (groupByExpressions.getOptOrderByPerLevel() != null) {
            orderByElements = new OrderByElementForge[numLevels][];
        }
        ExprNodePropOrStreamSet[] propsPerGroupByExpr = new ExprNodePropOrStreamSet[groupByNodesValidated.length];
        for (i = 0; i < groupByNodesValidated.length; ++i) {
            propsPerGroupByExpr[i] = ExprNodeUtilityAggregation.getGroupByPropertiesValidateHasOne(new ExprNode[]{groupByNodesValidated[i]});
        }
        for (i = 0; i < numLevels; ++i) {
            SelectExprProcessorForge forge;
            AggregationGroupByRollupLevelForge level = groupByRollupDesc.getLevels()[i];
            ExprNodePropOrStreamSet rolledupProps = ResultSetProcessorFactoryFactory.getRollupProperties(level, propsPerGroupByExpr);
            ExprNode[] selectClauseLevel = groupByExpressions.getSelectClausePerLevel()[i];
            SelectClauseElementCompiled[] selectClause = ResultSetProcessorFactoryFactory.getRollUpSelectClause(spec.getSelectClauseSpec(), selectClauseLevel, level, rolledupProps, groupByNodesValidated, validationContext);
            SelectProcessorArgs args = new SelectProcessorArgs(selectClause, groupByRollupInfo, false, null, spec.getForClauseSpec(), typeService, statementRawInfo.getOptionalContextDescriptor(), isFireAndForget, spec.getAnnotations(), statementRawInfo, compileTimeServices);
            processors[i] = forge = SelectExprProcessorFactory.getProcessor(args, insertIntoDesc, false).getForge();
            if (havingClauses != null) {
                ExprNode havingNode = ResultSetProcessorFactoryFactory.rewriteRollupValidateExpression(ExprNodeOrigin.HAVING, groupByExpressions.getOptHavingNodePerLevel()[i], validationContext, rolledupProps, groupByNodesValidated, level);
                havingClauses[i] = havingNode.getForge();
            }
            if (orderByElements == null) continue;
            orderByElements[i] = ResultSetProcessorFactoryFactory.rewriteRollupOrderBy(spec.getOrderByList(), groupByExpressions.getOptOrderByPerLevel()[i], validationContext, rolledupProps, groupByNodesValidated, level);
        }
        return new GroupByRollupPerLevelForge(processors, havingClauses, orderByElements);
    }

    private static OrderByElementForge[] rewriteRollupOrderBy(List<OrderByItem> items, ExprNode[] orderByList, ExprValidationContext validationContext, ExprNodePropOrStreamSet rolledupProps, ExprNode[] groupByNodes, AggregationGroupByRollupLevelForge level) throws ExprValidationException {
        OrderByElementForge[] elements = new OrderByElementForge[orderByList.length];
        for (int i = 0; i < orderByList.length; ++i) {
            ExprNode validated = ResultSetProcessorFactoryFactory.rewriteRollupValidateExpression(ExprNodeOrigin.ORDERBY, orderByList[i], validationContext, rolledupProps, groupByNodes, level);
            elements[i] = new OrderByElementForge(validated, items.get(i).isDescending());
        }
        return elements;
    }

    private static ExprNodePropOrStreamSet getRollupProperties(AggregationGroupByRollupLevelForge level, ExprNodePropOrStreamSet[] propsPerGroupByExpr) {
        ExprNodePropOrStreamSet rolledupProps = new ExprNodePropOrStreamSet();
        for (int i = 0; i < propsPerGroupByExpr.length; ++i) {
            if (level.isAggregationTop()) {
                rolledupProps.addAll(propsPerGroupByExpr[i]);
                continue;
            }
            boolean rollupContainsGroupExpr = false;
            for (int num : level.getRollupKeys()) {
                if (num != i) continue;
                rollupContainsGroupExpr = true;
                break;
            }
            if (rollupContainsGroupExpr) continue;
            rolledupProps.addAll(propsPerGroupByExpr[i]);
        }
        return rolledupProps;
    }

    private static SelectClauseElementCompiled[] getRollUpSelectClause(SelectClauseSpecCompiled selectClauseSpec, ExprNode[] selectClauseLevel, AggregationGroupByRollupLevelForge level, ExprNodePropOrStreamSet rolledupProps, ExprNode[] groupByNodesValidated, ExprValidationContext validationContext) throws ExprValidationException {
        SelectClauseElementCompiled[] rewritten = new SelectClauseElementCompiled[selectClauseSpec.getSelectExprList().length];
        for (int i = 0; i < rewritten.length; ++i) {
            SelectClauseElementCompiled spec = selectClauseSpec.getSelectExprList()[i];
            if (!(spec instanceof SelectClauseExprCompiledSpec)) {
                throw new ExprValidationException("Group-by clause with roll-up does not allow wildcard");
            }
            SelectClauseExprCompiledSpec exprSpec = (SelectClauseExprCompiledSpec)spec;
            ExprNode validated = ResultSetProcessorFactoryFactory.rewriteRollupValidateExpression(ExprNodeOrigin.SELECT, selectClauseLevel[i], validationContext, rolledupProps, groupByNodesValidated, level);
            rewritten[i] = new SelectClauseExprCompiledSpec(validated, exprSpec.getAssignedName(), exprSpec.getProvidedName(), exprSpec.isEvents());
        }
        return rewritten;
    }

    private static ExprNode rewriteRollupValidateExpression(ExprNodeOrigin exprNodeOrigin, ExprNode exprNode, ExprValidationContext validationContext, ExprNodePropOrStreamSet rolledupProps, ExprNode[] groupByNodes, AggregationGroupByRollupLevelForge level) throws ExprValidationException {
        int[] combination;
        ExprNodeGroupingVisitorWParent groupingVisitor = new ExprNodeGroupingVisitorWParent();
        exprNode.accept(groupingVisitor);
        for (Pair<ExprNode, ExprGroupingNode> pair : groupingVisitor.getGroupingNodes()) {
            int[] rollupIndexes;
            combination = ResultSetProcessorFactoryFactory.getGroupExprCombination(groupByNodes, pair.getSecond().getChildNodes());
            boolean found = false;
            for (int index : rollupIndexes = level.isAggregationTop() ? new int[]{} : level.getRollupKeys()) {
                if (index != combination[0]) continue;
                found = true;
                break;
            }
            int result = found ? 0 : 1;
            ExprConstantNodeImpl exprConstantNodeImpl = new ExprConstantNodeImpl(result, Integer.class);
            if (pair.getFirst() != null) {
                ExprNodeUtilityModify.replaceChildNode(pair.getFirst(), pair.getSecond(), exprConstantNodeImpl);
                continue;
            }
            exprNode = exprConstantNodeImpl;
        }
        for (Pair<ExprNode, ExprNodeBase> pair : groupingVisitor.getGroupingIdNodes()) {
            combination = ResultSetProcessorFactoryFactory.getGroupExprCombination(groupByNodes, ((ExprGroupingIdNode)pair.getSecond()).getChildNodes());
            int result = 0;
            for (int i = 0; i < combination.length; ++i) {
                int[] rollupIndexes;
                int index = combination[i];
                boolean bl = false;
                for (int rollupIndex : rollupIndexes = level.isAggregationTop() ? new int[]{} : level.getRollupKeys()) {
                    if (index != rollupIndex) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                result += ResultSetProcessorFactoryFactory.pow2(combination.length - i - 1);
            }
            ExprConstantNodeImpl constant = new ExprConstantNodeImpl(result, Integer.class);
            if (pair.getFirst() != null) {
                ExprNodeUtilityModify.replaceChildNode(pair.getFirst(), pair.getSecond(), constant);
                continue;
            }
            exprNode = constant;
        }
        ExprNodeIdentifierCollectVisitorWContainer identVisitor = new ExprNodeIdentifierCollectVisitorWContainer();
        exprNode.accept(identVisitor);
        for (Pair<ExprNode, ExprIdentNode> node : identVisitor.getExprProperties()) {
            boolean rewrite = false;
            ExprNodePropOrStreamExprDesc firstRollupNonPropExpr = rolledupProps.getFirstExpression();
            if (firstRollupNonPropExpr != null) {
                throw new ExprValidationException("Invalid rollup expression " + firstRollupNonPropExpr.getTextual());
            }
            for (ExprNodePropOrStreamDesc exprNodePropOrStreamDesc : rolledupProps.getProperties()) {
                ExprNodePropOrStreamPropDesc prop = (ExprNodePropOrStreamPropDesc)exprNodePropOrStreamDesc;
                if (exprNodePropOrStreamDesc.getStreamNum() != node.getSecond().getStreamId() || !prop.getPropertyName().equals(node.getSecond().getResolvedPropertyName())) continue;
                rewrite = true;
                break;
            }
            if (node.getFirst() != null && (node.getFirst() instanceof ExprPreviousNode || node.getFirst() instanceof ExprPriorNode)) {
                rewrite = false;
            }
            if (!rewrite) continue;
            ExprConstantNodeImpl constant = new ExprConstantNodeImpl(null, node.getSecond().getForge().getEvaluationType());
            if (node.getFirst() != null) {
                ExprNodeUtilityModify.replaceChildNode(node.getFirst(), node.getSecond(), constant);
                continue;
            }
            exprNode = constant;
        }
        return ExprNodeUtilityValidate.getValidatedSubtree(exprNodeOrigin, exprNode, validationContext);
    }

    private static int[] getGroupExprCombination(ExprNode[] groupByNodes, ExprNode[] childNodes) throws ExprValidationException {
        TreeSet<Integer> indexes = new TreeSet<Integer>();
        for (ExprNode child : childNodes) {
            boolean found = false;
            for (int i = 0; i < groupByNodes.length; ++i) {
                if (!ExprNodeUtilityCompare.deepEquals(child, groupByNodes[i], false)) continue;
                if (indexes.contains(i)) {
                    throw new ExprValidationException("Duplicate expression '" + ExprNodeUtilityPrint.toExpressionStringMinPrecedenceSafe(child) + "' among grouping function parameters");
                }
                indexes.add(i);
                found = true;
            }
            if (found) continue;
            throw new ExprValidationException("Failed to find expression '" + ExprNodeUtilityPrint.toExpressionStringMinPrecedenceSafe(child) + "' among group-by expressions");
        }
        return CollectionUtil.intArray(indexes);
    }

    private static void validateSelectAssignColNames(SelectClauseSpecCompiled selectClauseSpec, List<SelectClauseExprCompiledSpec> namedSelectionList, ExprValidationContext validationContext) throws ExprValidationException {
        for (int i = 0; i < selectClauseSpec.getSelectExprList().length; ++i) {
            SelectClauseElementCompiled element = selectClauseSpec.getSelectExprList()[i];
            if (!(element instanceof SelectClauseExprCompiledSpec)) continue;
            SelectClauseExprCompiledSpec expr = (SelectClauseExprCompiledSpec)element;
            ExprNode validatedExpression = ExprNodeUtilityValidate.getValidatedSubtree(ExprNodeOrigin.SELECT, expr.getSelectExpression(), validationContext);
            String asName = expr.getAssignedName();
            if (asName == null) {
                asName = ExprNodeUtilityPrint.toExpressionStringMinPrecedenceSafe(validatedExpression);
            }
            expr.setAssignedName(asName);
            expr.setSelectExpression(validatedExpression);
            namedSelectionList.add(expr);
        }
    }

    private static void validateHaving(ExprNodePropOrStreamSet propertiesGroupedBy, ExprNode havingNode) throws ExprValidationException {
        LinkedList<ExprAggregateNode> aggregateNodesHaving = new LinkedList<ExprAggregateNode>();
        ExprAggregateNodeUtil.getAggregatesBottomUp(havingNode, aggregateNodesHaving);
        if (!propertiesGroupedBy.isEmpty()) {
            ExprNodeIdentifierAndStreamRefVisitor visitor = new ExprNodeIdentifierAndStreamRefVisitor(true);
            havingNode.accept(visitor);
            List<ExprNodePropOrStreamDesc> allPropertiesHaving = visitor.getRefs();
            ExprNodePropOrStreamSet aggPropertiesHaving = ExprNodeUtilityAggregation.getAggregatedProperties(aggregateNodesHaving);
            aggPropertiesHaving.removeFromList(allPropertiesHaving);
            propertiesGroupedBy.removeFromList(allPropertiesHaving);
            if (!allPropertiesHaving.isEmpty()) {
                ExprNodePropOrStreamDesc desc = allPropertiesHaving.iterator().next();
                throw new ExprValidationException("Non-aggregated " + desc.getTextual() + " in the HAVING clause must occur in the group-by clause");
            }
        }
    }

    private static int pow2(int exponent) {
        if (exponent == 0) {
            return 1;
        }
        int result = 2;
        for (int i = 0; i < exponent - 1; ++i) {
            result = 2 * result;
        }
        return result;
    }

    private static List<OrderByItem> expandColumnNames(SelectClauseElementCompiled[] selectionList, List<OrderByItem> orderByUnexpanded) {
        if (orderByUnexpanded == null || orderByUnexpanded.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<OrderByItem> expanded = new ArrayList<OrderByItem>();
        for (OrderByItem item : orderByUnexpanded) {
            expanded.add(item.copy());
        }
        for (SelectClauseElementCompiled selectElement : selectionList) {
            SelectClauseExprCompiledSpec selectExpr;
            String name;
            if (!(selectElement instanceof SelectClauseExprCompiledSpec) || (name = (selectExpr = (SelectClauseExprCompiledSpec)selectElement).getAssignedName()) == null) continue;
            ExprNode fullExpr = selectExpr.getSelectExpression();
            ListIterator<OrderByItem> iterator = expanded.listIterator();
            while (iterator.hasNext()) {
                OrderByItem orderByElement = (OrderByItem)iterator.next();
                ExprNode swapped = ColumnNamedNodeSwapper.swap(orderByElement.getExprNode(), name, fullExpr);
                OrderByItem newOrderByElement = new OrderByItem(swapped, orderByElement.isDescending());
                iterator.set(newOrderByElement);
            }
        }
        return expanded;
    }

    private static boolean sameExpressions(ExprNode[] levelExpressions, ExprNode[] validated) {
        if (levelExpressions.length != validated.length) {
            return false;
        }
        for (int i = 0; i < levelExpressions.length; ++i) {
            if (validated[i] == levelExpressions[i]) continue;
            return false;
        }
        return true;
    }
}

