/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.resultset.order;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.epl.resultset.order.RowLimitProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.TreeMap;

public class OrderByProcessorUtil {
    public static EventBean[] sortGivenOutgoingAndSortKeys(EventBean[] outgoingEvents, List<Object> sortValuesMultiKeys, Comparator<Object> comparator) {
        HashMap<Object, ArrayList<EventBean>> sortToOutgoing = new HashMap<Object, ArrayList<EventBean>>();
        int countOne = 0;
        for (Object sortValues : sortValuesMultiKeys) {
            ArrayList<EventBean> list = (ArrayList<EventBean>)sortToOutgoing.get(sortValues);
            if (list == null) {
                list = new ArrayList<EventBean>();
            }
            list.add(outgoingEvents[countOne++]);
            sortToOutgoing.put(sortValues, list);
        }
        Collections.sort(sortValuesMultiKeys, comparator);
        LinkedHashSet<Object> sortSet = new LinkedHashSet<Object>(sortValuesMultiKeys);
        EventBean[] result = new EventBean[outgoingEvents.length];
        int countTwo = 0;
        for (Object e : sortSet) {
            Collection output = (Collection)sortToOutgoing.get(e);
            for (EventBean theEvent : output) {
                result[countTwo++] = theEvent;
            }
        }
        return result;
    }

    public static EventBean[] sortWOrderKeys(EventBean[] outgoingEvents, Object[] orderKeys, Comparator<Object> comparator) {
        TreeMap<Object, Object> sort = new TreeMap<Object, Object>(comparator);
        if (outgoingEvents == null || outgoingEvents.length < 2) {
            return outgoingEvents;
        }
        for (int i = 0; i < outgoingEvents.length; ++i) {
            ArrayList<EventBean> list;
            Object entry = sort.get(orderKeys[i]);
            if (entry == null) {
                sort.put(orderKeys[i], outgoingEvents[i]);
                continue;
            }
            if (entry instanceof EventBean) {
                list = new ArrayList<EventBean>();
                list.add((EventBean)entry);
                list.add(outgoingEvents[i]);
                sort.put(orderKeys[i], list);
                continue;
            }
            list = (ArrayList<EventBean>)entry;
            list.add(outgoingEvents[i]);
        }
        EventBean[] result = new EventBean[outgoingEvents.length];
        int count = 0;
        for (Object entry : sort.values()) {
            if (entry instanceof List) {
                List output = (List)entry;
                for (EventBean theEvent : output) {
                    result[count++] = theEvent;
                }
                continue;
            }
            result[count++] = (EventBean)entry;
        }
        return result;
    }

    public static EventBean determineLocalMinMaxWOrderKeys(EventBean[] outgoingEvents, Object[] orderKeys, Comparator<Object> comparator) {
        Object localMinMax = null;
        EventBean outgoingMinMaxBean = null;
        for (int i = 0; i < outgoingEvents.length; ++i) {
            boolean newMinMax;
            boolean bl = newMinMax = localMinMax == null || comparator.compare(localMinMax, orderKeys[i]) > 0;
            if (!newMinMax) continue;
            localMinMax = orderKeys[i];
            outgoingMinMaxBean = outgoingEvents[i];
        }
        return outgoingMinMaxBean;
    }

    public static EventBean[] sortWOrderKeysWLimit(EventBean[] outgoingEvents, Object[] orderKeys, Comparator<Object> comparator, RowLimitProcessor rowLimitProcessor) {
        rowLimitProcessor.determineCurrentLimit();
        if (rowLimitProcessor.getCurrentRowLimit() == 1 && rowLimitProcessor.getCurrentOffset() == 0 && outgoingEvents != null && outgoingEvents.length > 1) {
            EventBean minmax = OrderByProcessorUtil.determineLocalMinMaxWOrderKeys(outgoingEvents, orderKeys, comparator);
            return new EventBean[]{minmax};
        }
        EventBean[] sorted = OrderByProcessorUtil.sortWOrderKeys(outgoingEvents, orderKeys, comparator);
        return rowLimitProcessor.applyLimit(sorted);
    }
}

