/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.resultset.order;

import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.compile.stage1.spec.RowLimitSpec;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.resultset.order.RowLimitProcessorFactory;
import com.espertech.esper.common.internal.epl.variable.compiletime.VariableCompileTimeResolver;
import com.espertech.esper.common.internal.epl.variable.compiletime.VariableMetaData;
import com.espertech.esper.common.internal.epl.variable.core.VariableDeployTimeResolver;
import com.espertech.esper.common.internal.epl.variable.core.VariableUtil;
import com.espertech.esper.common.internal.util.JavaClassHelper;

public class RowLimitProcessorFactoryForge {
    private final VariableMetaData numRowsVariableMetaData;
    private final VariableMetaData offsetVariableMetaData;
    private int currentRowLimit;
    private int currentOffset;

    public RowLimitProcessorFactoryForge(RowLimitSpec rowLimitSpec, VariableCompileTimeResolver variableCompileTimeResolver, String optionalContextName) throws ExprValidationException {
        String message;
        if (rowLimitSpec.getNumRowsVariable() != null) {
            this.numRowsVariableMetaData = variableCompileTimeResolver.resolve(rowLimitSpec.getNumRowsVariable());
            if (this.numRowsVariableMetaData == null) {
                throw new ExprValidationException("Limit clause variable by name '" + rowLimitSpec.getNumRowsVariable() + "' has not been declared");
            }
            message = VariableUtil.checkVariableContextName(optionalContextName, this.numRowsVariableMetaData);
            if (message != null) {
                throw new ExprValidationException(message);
            }
            if (!JavaClassHelper.isNumeric(this.numRowsVariableMetaData.getType())) {
                throw new ExprValidationException("Limit clause requires a variable of numeric type");
            }
        } else {
            this.numRowsVariableMetaData = null;
            this.currentRowLimit = rowLimitSpec.getNumRows();
            if (this.currentRowLimit < 0) {
                this.currentRowLimit = Integer.MAX_VALUE;
            }
        }
        if (rowLimitSpec.getOptionalOffsetVariable() != null) {
            this.offsetVariableMetaData = variableCompileTimeResolver.resolve(rowLimitSpec.getOptionalOffsetVariable());
            if (this.offsetVariableMetaData == null) {
                throw new ExprValidationException("Limit clause variable by name '" + rowLimitSpec.getOptionalOffsetVariable() + "' has not been declared");
            }
            message = VariableUtil.checkVariableContextName(optionalContextName, this.offsetVariableMetaData);
            if (message != null) {
                throw new ExprValidationException(message);
            }
            if (!JavaClassHelper.isNumeric(this.offsetVariableMetaData.getType())) {
                throw new ExprValidationException("Limit clause requires a variable of numeric type");
            }
        } else {
            this.offsetVariableMetaData = null;
            if (rowLimitSpec.getOptionalOffset() != null) {
                this.currentOffset = rowLimitSpec.getOptionalOffset();
                if (this.currentOffset <= 0) {
                    throw new ExprValidationException("Limit clause requires a positive offset");
                }
            } else {
                this.currentOffset = 0;
            }
        }
    }

    public CodegenExpression make(CodegenMethodScope parent, CodegenClassScope classScope) {
        CodegenExpression numRowsVariable = CodegenExpressionBuilder.constantNull();
        if (this.numRowsVariableMetaData != null) {
            numRowsVariable = VariableDeployTimeResolver.makeVariableField(this.numRowsVariableMetaData, classScope, this.getClass());
        }
        CodegenExpression offsetVariable = CodegenExpressionBuilder.constantNull();
        if (this.offsetVariableMetaData != null) {
            offsetVariable = VariableDeployTimeResolver.makeVariableField(this.offsetVariableMetaData, classScope, this.getClass());
        }
        CodegenMethod method = parent.makeChild(RowLimitProcessorFactory.class, this.getClass(), (CodegenScope)classScope);
        method.getBlock().declareVar(RowLimitProcessorFactory.class, "factory", CodegenExpressionBuilder.newInstance(RowLimitProcessorFactory.class, new CodegenExpression[0])).exprDotMethod(CodegenExpressionBuilder.ref("factory"), "setNumRowsVariable", numRowsVariable).exprDotMethod(CodegenExpressionBuilder.ref("factory"), "setOffsetVariable", offsetVariable).exprDotMethod(CodegenExpressionBuilder.ref("factory"), "setCurrentRowLimit", CodegenExpressionBuilder.constant(this.currentRowLimit)).exprDotMethod(CodegenExpressionBuilder.ref("factory"), "setCurrentOffset", CodegenExpressionBuilder.constant(this.currentOffset)).methodReturn(CodegenExpressionBuilder.ref("factory"));
        return CodegenExpressionBuilder.localMethod(method, new CodegenExpression[0]);
    }
}

