/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.resultset.select.core;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.compile.stage1.spec.SelectClauseElementWildcard;
import com.espertech.esper.common.internal.compile.stage2.SelectClauseElementCompiled;
import com.espertech.esper.common.internal.compile.stage2.SelectClauseExprCompiledSpec;
import com.espertech.esper.common.internal.epl.expression.codegen.CodegenLegoMayVoid;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityPrint;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.resultset.select.core.BindProcessorStream;
import com.espertech.esper.common.internal.epl.resultset.select.core.BindProcessorStreamTable;
import com.espertech.esper.common.internal.epl.resultset.select.core.SelectClauseStreamCompiledSpec;
import com.espertech.esper.common.internal.epl.resultset.select.core.SelectExprProcessorForge;
import com.espertech.esper.common.internal.epl.table.compiletime.TableCompileTimeResolver;
import com.espertech.esper.common.internal.epl.table.compiletime.TableMetaData;
import java.util.ArrayList;

public class BindProcessorForge {
    private ExprForge[] expressionForges;
    private Class[] expressionTypes;
    private String[] columnNamesAssigned;

    public BindProcessorForge(SelectExprProcessorForge synthetic, SelectClauseElementCompiled[] selectionList, EventType[] typesPerStream, String[] streamNames, TableCompileTimeResolver tableService) throws ExprValidationException {
        ArrayList<ExprForge> expressions = new ArrayList<ExprForge>();
        ArrayList<Class> types = new ArrayList<Class>();
        ArrayList<String> columnNames = new ArrayList<String>();
        for (SelectClauseElementCompiled element : selectionList) {
            if (element instanceof SelectClauseElementWildcard) {
                for (int i = 0; i < typesPerStream.length; ++i) {
                    Class returnType = typesPerStream[i].getUnderlyingType();
                    TableMetaData tableMetadata = tableService.resolveTableFromEventType(typesPerStream[i]);
                    ExprForge forge = tableMetadata != null ? new BindProcessorStreamTable(i, returnType, tableMetadata) : new BindProcessorStream(i, returnType);
                    expressions.add(forge);
                    types.add(returnType);
                    columnNames.add(streamNames[i]);
                }
                continue;
            }
            if (element instanceof SelectClauseStreamCompiledSpec) {
                SelectClauseStreamCompiledSpec streamSpec = (SelectClauseStreamCompiledSpec)element;
                EventType type = typesPerStream[streamSpec.getStreamNumber()];
                Class returnType = type.getUnderlyingType();
                TableMetaData tableMetadata = tableService.resolveTableFromEventType(type);
                ExprForge forge = tableMetadata != null ? new BindProcessorStreamTable(streamSpec.getStreamNumber(), returnType, tableMetadata) : new BindProcessorStream(streamSpec.getStreamNumber(), returnType);
                expressions.add(forge);
                types.add(returnType);
                columnNames.add(streamNames[streamSpec.getStreamNumber()]);
                continue;
            }
            if (element instanceof SelectClauseExprCompiledSpec) {
                SelectClauseExprCompiledSpec expr = (SelectClauseExprCompiledSpec)element;
                ExprForge forge = expr.getSelectExpression().getForge();
                expressions.add(forge);
                types.add(forge.getEvaluationType());
                if (expr.getAssignedName() != null) {
                    columnNames.add(expr.getAssignedName());
                    continue;
                }
                columnNames.add(ExprNodeUtilityPrint.toExpressionStringMinPrecedenceSafe(expr.getSelectExpression()));
                continue;
            }
            throw new IllegalStateException("Unrecognized select expression element of type " + element.getClass());
        }
        this.expressionForges = expressions.toArray(new ExprForge[expressions.size()]);
        this.expressionTypes = types.toArray(new Class[types.size()]);
        this.columnNamesAssigned = columnNames.toArray(new String[columnNames.size()]);
    }

    public ExprForge[] getExpressionForges() {
        return this.expressionForges;
    }

    public Class[] getExpressionTypes() {
        return this.expressionTypes;
    }

    public String[] getColumnNamesAssigned() {
        return this.columnNamesAssigned;
    }

    public CodegenMethod processCodegen(CodegenMethod processMethod, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenMethod methodNode = processMethod.makeChild(Object[].class, this.getClass(), (CodegenScope)codegenClassScope);
        CodegenBlock block = methodNode.getBlock().declareVar(Object[].class, "parameters", CodegenExpressionBuilder.newArrayByLength(Object.class, CodegenExpressionBuilder.constant(this.expressionForges.length)));
        for (int i = 0; i < this.expressionForges.length; ++i) {
            block.assignArrayElement("parameters", CodegenExpressionBuilder.constant(i), CodegenLegoMayVoid.expressionMayVoid(Object.class, this.expressionForges[i], methodNode, exprSymbol, codegenClassScope));
        }
        block.methodReturn(CodegenExpressionBuilder.ref("parameters"));
        return methodNode;
    }
}

